/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.world;

import com.denfop.IUItem;
import com.denfop.world.WorldBaseGen;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;

public class HiveGenerator
extends Feature<NoneFeatureConfiguration> {
    public HiveGenerator(Codec<NoneFeatureConfiguration> p_65786_) {
        super(p_65786_);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel world = context.m_159774_();
        if (WorldBaseGen.random.nextBoolean() && WorldBaseGen.random.nextInt(10) <= 5) {
            ChunkPos chunkPos = new ChunkPos(context.m_159777_());
            int chunkX = chunkPos.f_45578_;
            int chunkZ = chunkPos.f_45579_;
            this.generateHives(world, WorldBaseGen.random, chunkX * 16, chunkZ * 16);
            return true;
        }
        return false;
    }

    private void placeHive(WorldGenLevel world, BlockPos pos, int meta) {
        for (Direction facing : Direction.values()) {
            BlockPos placePos = pos.m_121955_(facing.m_122436_());
            if (!world.m_8055_(placePos).m_60795_()) continue;
            BlockState state = IUItem.hive.getItem(meta).m_40614_().m_49966_();
            world.m_7731_(pos, state, 11);
            break;
        }
    }

    private void generateHives(WorldGenLevel world, Random rand, int x, int z) {
        int hivesPerChunk = 1;
        for (int i = 0; i < hivesPerChunk; ++i) {
            int posZ;
            int posX = x + rand.nextInt(16);
            BlockPos pos = this.getPosForHive(world, posX, posZ = z + rand.nextInt(16));
            if (pos == null) continue;
            Holder biome = world.m_204166_(pos);
            if (biome.m_203656_(Tags.Biomes.IS_COLD)) {
                this.placeHive(world, pos, 2);
                continue;
            }
            if (biome.m_203656_(BiomeTags.f_207611_)) {
                this.placeHive(world, pos, 0);
                continue;
            }
            if (biome.m_203656_(Tags.Biomes.IS_PLAINS)) {
                this.placeHive(world, pos, 1);
                continue;
            }
            if (biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
                this.placeHive(world, pos, 3);
                continue;
            }
            if (!biome.m_203656_(BiomeTags.f_207610_)) continue;
            this.placeHive(world, pos, 4);
        }
    }

    public static boolean isTreeBlock(BlockState blockState) {
        Block block = blockState.m_60734_();
        return blockState.m_204336_(BlockTags.f_13035_) || blockState.m_204336_(BlockTags.f_13106_);
    }

    public static boolean canReplace(BlockState blockState) {
        Block block = blockState.m_60734_();
        return blockState.m_60722_(Fluids.f_76191_) && !blockState.m_278721_();
    }

    public BlockPos getPosForHive(WorldGenLevel world, int x, int z) {
        BlockPos topPos = new BlockPos(x, world.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z) - 1, z);
        if (topPos.m_123342_() <= 0) {
            return null;
        }
        BlockState blockState = world.m_8055_(topPos);
        if (!HiveGenerator.isTreeBlock(blockState)) {
            return null;
        }
        BlockPos.MutableBlockPos pos = topPos.m_122032_();
        do {
            pos.m_122173_(Direction.DOWN);
        } while (HiveGenerator.isTreeBlock(blockState = world.m_8055_((BlockPos)pos)) && pos.m_123342_() > 0);
        return pos.m_7949_();
    }
}

