/*
 * Decompiled with CFR 0.152.
 */
package fr.Nat0uille.NATWhitelist.Listeners;

import fr.Nat0uille.NATWhitelist.Main;
import fr.Nat0uille.NATWhitelist.Whitelist;
import java.sql.SQLException;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerListener
implements Listener {
    private final Whitelist whitelist;
    private final Main main;

    public PlayerListener(Whitelist whitelist, Main main) {
        this.whitelist = whitelist;
        this.main = main;
    }

    @EventHandler
    public void onPlayerLogin(final PlayerLoginEvent event) {
        final MiniMessage mm = MiniMessage.miniMessage();
        final Component prefix = mm.deserialize((Object)this.main.getLangMessage("prefix"));
        Component kickmessage = mm.deserialize((Object)this.main.getLangMessage("kickmessage"));
        UUID playerUUID = event.getPlayer().getUniqueId();
        String currentName = event.getPlayer().getName();
        new BukkitRunnable(){

            public void run() {
                if (event.getPlayer().hasPermission("natwhitelist.admin") && PlayerListener.this.main.getCheckVersion().outdated()) {
                    event.getPlayer().sendMessage(prefix.append(mm.deserialize((Object)PlayerListener.this.main.getLangMessage("outdated").replace("{latest}", PlayerListener.this.main.getCheckVersion().getRemoteVersion()).replace("{local}", PlayerListener.this.main.getCheckVersion().getLocalVersion()))));
                }
            }
        }.runTaskLater((Plugin)this.main, 10L);
        try {
            String storedName = this.whitelist.getPlayerNameByUUID(playerUUID);
            if (storedName != null && !storedName.equalsIgnoreCase(currentName)) {
                this.whitelist.updatePlayerName(playerUUID, currentName);
            }
            if (!event.getPlayer().hasPermission("natwhitelist.bypass") && this.whitelist.isEnabled() && !this.whitelist.isWhitelisted(playerUUID)) {
                event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, prefix.append(kickmessage));
                String title = this.main.getLangMessage("webhook-notwhitelisted-title");
                String desc = this.main.getLangMessage("webhook-notwhitelisted-desc").replace("{player}", currentName);
                this.whitelist.SendDiscordWebhook(title, desc);
            }
        }
        catch (SQLException e) {
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, prefix.append(mm.deserialize((Object)"<red>SQL error</red>")));
            e.printStackTrace();
        }
    }
}

