/*
 * Decompiled with CFR 0.152.
 */
package fr.Nat0uille.NATWhitelist;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.Nat0uille.NATWhitelist.Main;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Whitelist {
    private final Connection conn;
    private Main main;
    private final List<String> removedPlayers = new ArrayList<String>();

    public Whitelist(Main main, Connection conn) {
        this.main = main;
        this.conn = conn;
    }

    public boolean add(UUID uuid) throws SQLException {
        String type = this.main.getConfig().getString("database.type");
        String sql = "MySQL".equalsIgnoreCase(type) ? "INSERT IGNORE INTO nat_whitelist (player_name, uuid) VALUES (?, ?)" : "INSERT OR IGNORE INTO nat_whitelist (player_name, uuid) VALUES (?, ?)";
        String playerName = null;
        Player online = Bukkit.getPlayer((UUID)uuid);
        playerName = online != null ? online.getName() : Bukkit.getOfflinePlayer((UUID)uuid).getName();
        if (playerName == null) {
            playerName = uuid.toString();
        }
        try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
            boolean result;
            stmt.setString(1, playerName);
            stmt.setString(2, uuid.toString());
            boolean bl = result = stmt.executeUpdate() > 0;
            if (result) {
                String title = this.main.getLangMessage("webhook-add-title");
                String desc = this.main.getLangMessage("webhook-add-desc").replace("{player}", playerName);
                this.SendDiscordWebhook(title, desc);
            }
            boolean bl2 = result;
            return bl2;
        }
    }

    public boolean remove(UUID uuid) throws SQLException {
        String type = this.main.getConfig().getString("database.type");
        String sql = "DELETE FROM nat_whitelist WHERE uuid = ?";
        String playerName = this.getPlayerNameByUUID(uuid);
        try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
            boolean result;
            stmt.setString(1, uuid.toString());
            boolean bl = result = stmt.executeUpdate() > 0;
            if (result) {
                String title = this.main.getLangMessage("webhook-remove-title");
                String desc = this.main.getLangMessage("webhook-remove-desc").replace("{player}", playerName);
                this.SendDiscordWebhook(title, desc);
            }
            boolean bl2 = result;
            return bl2;
        }
    }

    public void removeOffline(UUID uuid) throws SQLException {
        String type = this.main.getConfig().getString("database.type");
        String sql = "DELETE FROM nat_whitelist WHERE uuid = ?";
        String playerName = this.getPlayerNameByUUID(uuid);
        try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
            boolean result;
            stmt.setString(1, uuid.toString());
            boolean bl = result = stmt.executeUpdate() > 0;
            if (result) {
                String title = this.main.getLangMessage("webhook-removeoffline-title");
                String desc = this.main.getLangMessage("webhook-removeoffline-desc").replace("{player}", playerName);
                this.SendDiscordWebhook(title, desc);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isWhitelisted(UUID uuid) {
        String sql = "SELECT 1 FROM nat_whitelist WHERE uuid = ?";
        try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
            boolean bl;
            block14: {
                stmt.setString(1, uuid.toString());
                ResultSet rs = stmt.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block14;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public List<String> getWhitelistedPlayers() throws SQLException {
        ArrayList<String> players = new ArrayList<String>();
        String sql = "SELECT player_name FROM nat_whitelist";
        try (Statement stmt = this.conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                players.add(rs.getString("player_name"));
            }
        }
        return players;
    }

    public String listWhitelistedPlayers() throws SQLException {
        List<String> players = this.getWhitelistedPlayers();
        ArrayList<CallSite> coloredPlayers = new ArrayList<CallSite>();
        for (String playerName : players) {
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player != null && player.isOnline()) {
                coloredPlayers.add((CallSite)((Object)("<#63c74d>" + playerName)));
                continue;
            }
            coloredPlayers.add((CallSite)((Object)("<#951919>" + playerName)));
        }
        return String.join((CharSequence)", ", coloredPlayers);
    }

    public void setEnabled(boolean enabled) {
        String desc;
        String title;
        this.main.getConfig().set("enabled", (Object)enabled);
        this.main.saveConfig();
        if (enabled) {
            title = this.main.getLangMessage("webhook-on-title");
            desc = this.main.getLangMessage("webhook-on-desc");
        } else {
            title = this.main.getLangMessage("webhook-off-title");
            desc = this.main.getLangMessage("webhook-off-desc");
        }
        this.SendDiscordWebhook(title, desc);
    }

    public boolean isEnabled() {
        return this.main.getConfig().getBoolean("enabled", false);
    }

    public static String getCorrectUsernameFromMojang(String username) {
        try {
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + username);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            if (connection.getResponseCode() == 200) {
                JsonObject response = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream())).getAsJsonObject();
                return response.get("name").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void kickNoWhitelistedPlayers(Main main) {
        MiniMessage mm = MiniMessage.miniMessage();
        Component prefix = mm.deserialize((Object)main.getLangMessage("prefix"));
        Component kickmessage = mm.deserialize((Object)main.getLangMessage("kickmessage"));
        for (Player player : Bukkit.getOnlinePlayers()) {
            try {
                if (this.isWhitelisted(player.getUniqueId()) || player.hasPermission("natwhitelist.bypass")) continue;
                player.kick(prefix.append(kickmessage));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void removeNoWhitelistedPlayers(Main main) throws SQLException {
        this.removedPlayers.clear();
        for (String playerName : this.getWhitelistedPlayers()) {
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player != null && player.isOnline()) continue;
            String uuidStr = null;
            String sql = "SELECT uuid FROM nat_whitelist WHERE player_name = ?";
            try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
                stmt.setString(1, playerName);
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        uuidStr = rs.getString("uuid");
                    }
                }
            }
            if (uuidStr == null) continue;
            UUID uuid = UUID.fromString(uuidStr);
            this.removeOffline(uuid);
            this.removedPlayers.add(playerName);
        }
    }

    public List<String> getRemovedPlayers() {
        return this.removedPlayers;
    }

    public String getPlayerNameByUUID(UUID uuid) throws SQLException {
        String sql = "SELECT player_name FROM nat_whitelist WHERE uuid = ?";
        try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
            stmt.setString(1, uuid.toString());
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    String string = rs.getString("player_name");
                    return string;
                }
            }
        }
        return null;
    }

    public void updatePlayerName(UUID uuid, String newName) throws SQLException {
        String sql = "UPDATE nat_whitelist SET player_name = ? WHERE uuid = ?";
        try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
            stmt.setString(1, newName);
            stmt.setString(2, uuid.toString());
            stmt.executeUpdate();
        }
    }

    public void SendDiscordWebhook(String title, String description) {
        block11: {
            String url = this.main.getConfig().getString("discord-webhook-url");
            if (url == null) {
                return;
            }
            try {
                String jsonPayload = "{\"embeds\":[{\"title\":\"" + title.replace("\"", "\\\"") + "\",\"description\":\"" + description.replace("\"", "\\\"") + "\",\"color\":13107200,\"footer\":{\"text\":\"NAT-Whitelist\",\"icon_url\":\"https://i.imgur.com/qxAdLlM.jpeg\"},\"timestamp\":\"" + Instant.now().toString() + "\"}]}";
                URL webhookUrl = new URL(url);
                HttpURLConnection connection = (HttpURLConnection)webhookUrl.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/json");
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                int responseCode = connection.getResponseCode();
                if (responseCode != 204 && this.main != null) {
                    this.main.getLogger().warning("Discord webhook send failed: code " + responseCode);
                }
            }
            catch (IOException e) {
                if (this.main == null) break block11;
                this.main.getLogger().warning("Error sending Discord webhook: " + e.getMessage());
            }
        }
    }
}

