/*
 * Decompiled with CFR 0.152.
 */
package fr.Nat0uille.NATWhitelist;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class CheckVersion {
    private static final String REMOTE_URL = "https://raw.githubusercontent.com/Nat0uille/NAT-Whitelist/refs/heads/master/VERSION";
    private static final long PERIOD_TICKS = 216000L;
    public boolean outdated;
    public String remoteVersion;
    public String localVersion;

    public static void startVersionCheck(final Plugin plugin, final CheckVersion checkVersion) {
        new BukkitRunnable(){

            public void run() {
                try {
                    checkVersion.remoteVersion = CheckVersion.fetchRemoteVersion();
                    checkVersion.localVersion = CheckVersion.fetchLocalVersion(plugin);
                    if (!checkVersion.remoteVersion.equals(checkVersion.localVersion)) {
                        Bukkit.getLogger().warning("[NATWhitelist] The plugin is not up to date. Local version: " + checkVersion.localVersion + ", latest version: " + checkVersion.remoteVersion);
                        checkVersion.outdated = true;
                    }
                }
                catch (Exception e) {
                    Bukkit.getLogger().severe("[NATWhitelist] Error while checking version: " + e.getMessage());
                }
            }
        }.runTaskTimerAsynchronously(plugin, 0L, 216000L);
    }

    public boolean outdated() {
        return this.outdated;
    }

    public String getRemoteVersion() {
        return this.remoteVersion;
    }

    public String getLocalVersion() {
        return this.localVersion;
    }

    private static String fetchRemoteVersion() throws Exception {
        URL url = new URL(REMOTE_URL);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));){
            String string = in.readLine().trim();
            return string;
        }
    }

    private static String fetchLocalVersion(Plugin plugin) {
        return plugin.getDescription().getVersion();
    }
}

