/*
 * Decompiled with CFR 0.152.
 */
package fr.Nat0uille.NATWhitelist.Commands;

import fr.Nat0uille.NATWhitelist.Listeners.WhitelistListener;
import fr.Nat0uille.NATWhitelist.Main;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WhitelistCommand
implements CommandExecutor {
    private final Main main;
    private final WhitelistListener whitelistListener;

    public WhitelistCommand(Main main, WhitelistListener whitelistListener) {
        this.main = main;
        this.whitelistListener = whitelistListener;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        MiniMessage mm = MiniMessage.miniMessage();
        Component prefix = mm.deserialize((Object)this.main.getLangMessage("prefix"));
        Component noPermission = mm.deserialize((Object)this.main.getLangMessage("nopermission"));
        if (args.length == 0) {
            sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("help"))));
            return true;
        }
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("list")) {
                if (!sender.hasPermission("natwhitelist.list")) {
                    sender.sendMessage(prefix.append(noPermission));
                    return true;
                }
                try {
                    sender.sendMessage(prefix.append(mm.deserialize((Object)(this.main.getLangMessage("list") + this.whitelistListener.listWhitelistedPlayers()))));
                }
                catch (SQLException e) {
                    sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("sqlerror"))));
                    e.printStackTrace();
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("add")) {
                if (!sender.hasPermission("natwhitelist.add")) {
                    sender.sendMessage(prefix.append(noPermission));
                    return true;
                }
                sender.sendMessage(prefix.append(mm.deserialize((Object)"<#ffc369>/whitelist add <player>")));
                return true;
            }
            if (args[0].equalsIgnoreCase("remove")) {
                if (!sender.hasPermission("natwhitelist.remove")) {
                    sender.sendMessage(prefix.append(noPermission));
                    return true;
                }
                sender.sendMessage(prefix.append(mm.deserialize((Object)"<#ffc369>/whitelist remove <player>")));
                return true;
            }
            if (args[0].equalsIgnoreCase("on")) {
                if (!sender.hasPermission("natwhitelist.on")) {
                    sender.sendMessage(prefix.append(noPermission));
                    return true;
                }
                if (this.whitelistListener.isEnabled()) {
                    sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("whitelistalreadyon"))));
                } else {
                    if (this.main.getConfig().getBoolean("kicknowhitelisted")) {
                        this.whitelistListener.kickNoWhitelistedPlayers(this.main);
                    }
                    this.whitelistListener.setEnabled(true);
                    sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("whiteliston"))));
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("off")) {
                if (!sender.hasPermission("natwhitelist.off")) {
                    sender.sendMessage(prefix.append(noPermission));
                    return true;
                }
                if (!this.whitelistListener.isEnabled()) {
                    sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("whitelistalreadyoff"))));
                } else {
                    this.whitelistListener.setEnabled(false);
                    sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("whitelistoff"))));
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("natwhitelist.reload")) {
                    sender.sendMessage(prefix.append(noPermission));
                    return true;
                }
                this.main.reloadConfig();
                this.main.loadLang();
                sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("reload"))));
                return true;
            }
            if (args[0].equalsIgnoreCase("removeoffilne")) {
                if (!sender.hasPermission("natwhitelist.removeoffline")) {
                    sender.sendMessage(prefix.append(noPermission));
                }
                try {
                    this.whitelistListener.removeNoWhitelistedPlayers(this.main);
                    List<String> removed = this.whitelistListener.getRemovedPlayers();
                    String removedList = removed.isEmpty() ? "No players retired." : String.join((CharSequence)", ", removed);
                    sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("removeoffline").replace("{players}", removedList))));
                }
                catch (SQLException e) {
                    sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("sqlerror"))));
                    e.printStackTrace();
                }
                return true;
            }
        }
        if (args.length == 2) {
            UUID uuid;
            String playerName = args[1];
            if (playerName.length() > 16) {
                sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("playertoolong"))));
                return true;
            }
            String correctName = WhitelistListener.getCorrectUsernameFromMojang(playerName);
            if (correctName != null) {
                playerName = correctName;
                uuid = Bukkit.getOfflinePlayer((String)correctName).getUniqueId();
            } else {
                Player onlinePlayer = Bukkit.getPlayer((String)playerName);
                if (onlinePlayer != null) {
                    uuid = onlinePlayer.getUniqueId();
                    playerName = onlinePlayer.getName();
                } else {
                    sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("crackedneverconnected").replace("{player}", playerName))));
                    return true;
                }
            }
            if (args[0].equalsIgnoreCase("add")) {
                if (!sender.hasPermission("natwhitelist.add")) {
                    sender.sendMessage(prefix.append(noPermission));
                    return true;
                }
                try {
                    if (this.whitelistListener.isWhitelisted(uuid)) {
                        sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("alreadyinwhitelist").replace("{player}", playerName))));
                        return true;
                    }
                    boolean success = this.whitelistListener.add(uuid, playerName);
                    if (success) {
                        sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("addinwhitelist").replace("{player}", playerName))));
                    } else {
                        sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("erroraddingwhitelist").replace("{player}", playerName))));
                    }
                }
                catch (SQLException e) {
                    sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("sqlerror"))));
                    e.printStackTrace();
                }
                return true;
            }
            if (args[0].equalsIgnoreCase("remove")) {
                if (!sender.hasPermission("natwhitelist.remove")) {
                    sender.sendMessage(prefix.append(noPermission));
                    return true;
                }
                try {
                    if (!this.whitelistListener.isWhitelisted(uuid)) {
                        sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("notinwhitelist").replace("{player}", playerName))));
                        return true;
                    }
                    boolean success = this.whitelistListener.remove(uuid);
                    if (success) {
                        this.whitelistListener.kickNoWhitelistedPlayers(this.main);
                        sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("removeinwhoitelist").replace("{player}", playerName))));
                    } else {
                        sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("errorremovingwhitelist").replace("{player}", playerName))));
                    }
                }
                catch (SQLException e) {
                    sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("sqlerror"))));
                    e.printStackTrace();
                }
                return true;
            }
        }
        if (args.length >= 2 && (args[0].equalsIgnoreCase("add") || args[0].equalsIgnoreCase("remove"))) {
            for (int i = 1; i < args.length; ++i) {
                UUID uuid;
                String playerName = args[i];
                if (playerName.length() > 16) {
                    sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("playertoolong"))));
                    continue;
                }
                String correctName = WhitelistListener.getCorrectUsernameFromMojang(playerName);
                if (correctName != null) {
                    playerName = correctName;
                    uuid = Bukkit.getOfflinePlayer((String)correctName).getUniqueId();
                } else {
                    Player onlinePlayer = Bukkit.getPlayer((String)playerName);
                    if (onlinePlayer != null) {
                        uuid = onlinePlayer.getUniqueId();
                        playerName = onlinePlayer.getName();
                    } else {
                        sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("crackedneverconnected").replace("{player}", playerName))));
                        continue;
                    }
                }
                if (args[0].equalsIgnoreCase("add")) {
                    if (!sender.hasPermission("natwhitelist.add")) {
                        sender.sendMessage(prefix.append(noPermission));
                        continue;
                    }
                    try {
                        if (this.whitelistListener.isWhitelisted(uuid)) {
                            sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("alreadyinwhitelist").replace("{player}", playerName))));
                            continue;
                        }
                        boolean success = this.whitelistListener.add(uuid, playerName);
                        if (success) {
                            sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("addinwhitelist").replace("{player}", playerName))));
                            continue;
                        }
                        sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("erroraddingwhitelist").replace("{player}", playerName))));
                    }
                    catch (SQLException e) {
                        sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("sqlerror"))));
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!args[0].equalsIgnoreCase("remove")) continue;
                if (!sender.hasPermission("natwhitelist.remove")) {
                    sender.sendMessage(prefix.append(noPermission));
                    continue;
                }
                try {
                    if (!this.whitelistListener.isWhitelisted(uuid)) {
                        sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("notinwhitelist").replace("{player}", playerName))));
                        continue;
                    }
                    boolean success = this.whitelistListener.remove(uuid);
                    if (success) {
                        this.whitelistListener.kickNoWhitelistedPlayers(this.main);
                        sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("removeinwhoitelist").replace("{player}", playerName))));
                        continue;
                    }
                    sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("errorremovingwhitelist").replace("{player}", playerName))));
                    continue;
                }
                catch (SQLException e) {
                    sender.sendMessage(prefix.append(mm.deserialize((Object)this.main.getLangMessage("sqlerror"))));
                    e.printStackTrace();
                }
            }
            return true;
        }
        return false;
    }
}

