/*
 * Decompiled with CFR 0.152.
 */
package fr.Nat0uille.NATWhitelist;

import fr.Nat0uille.NATWhitelist.API.NATWhitelistAPI;
import fr.Nat0uille.NATWhitelist.API.NATWhitelistImpl;
import fr.Nat0uille.NATWhitelist.CheckVersion;
import fr.Nat0uille.NATWhitelist.Commands.WhitelistCommand;
import fr.Nat0uille.NATWhitelist.Listeners.PlayerListener;
import fr.Nat0uille.NATWhitelist.TabCompleter.WhitelistTabCompleter;
import fr.Nat0uille.NATWhitelist.Whitelist;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin {
    private Whitelist whitelist;
    private Connection sqlConnection;
    private CheckVersion checkVersion;
    private FileConfiguration langConfig;

    public void onEnable() {
        this.saveDefaultConfig();
        this.saveAllLangResources();
        this.loadLang();
        String type = this.getConfig().getString("database.type");
        String host = this.getConfig().getString("database.host");
        int port = this.getConfig().getInt("database.port");
        String dbName = this.getConfig().getString("database.database");
        String username = this.getConfig().getString("database.username");
        String password = this.getConfig().getString("database.password");
        try {
            if ("MySQL".equalsIgnoreCase(type)) {
                Class.forName("com.mysql.cj.jdbc.Driver");
                url = "jdbc:mysql://" + host + ":" + port + "/" + dbName;
                this.sqlConnection = DriverManager.getConnection(url, username, password);
                try {
                    stmt = this.sqlConnection.createStatement();
                    try {
                        stmt.executeUpdate("CREATE TABLE IF NOT EXISTS nat_whitelist (player_name VARCHAR(16) PRIMARY KEY, uuid VARCHAR(36))");
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                catch (SQLException e) {
                    this.getLogger().severe("Error creating table nat_whitelist: " + e.getMessage());
                }
            } else {
                Class.forName("org.sqlite.JDBC");
                if (!this.getDataFolder().exists()) {
                    this.getDataFolder().mkdirs();
                }
                url = "jdbc:sqlite:" + this.getDataFolder().getAbsolutePath() + "/database.db";
                this.sqlConnection = DriverManager.getConnection(url);
                try {
                    stmt = this.sqlConnection.createStatement();
                    try {
                        stmt.executeUpdate("CREATE TABLE IF NOT EXISTS nat_whitelist (player_name TEXT PRIMARY KEY, uuid TEXT)");
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                catch (SQLException e) {
                    this.getLogger().severe("Error creating table nat_whitelist: " + e.getMessage());
                }
            }
            this.whitelist = new Whitelist(this, this.sqlConnection);
        }
        catch (Exception e) {
            this.getLogger().severe("Unable to connect to the SQL database: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        WhitelistTabCompleter tabCompleter = new WhitelistTabCompleter(this.whitelist);
        this.getCommand("whitelist").setExecutor((CommandExecutor)new WhitelistCommand(this, this.whitelist));
        this.getCommand("whitelist").setTabCompleter((TabCompleter)tabCompleter);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, tabCompleter::updateCache, 0L, 20L);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this.whitelist, this), (Plugin)this);
        this.checkVersion = new CheckVersion();
        CheckVersion.startVersionCheck((Plugin)this, this.checkVersion);
        NATWhitelistImpl api = new NATWhitelistImpl(this);
        this.getServer().getServicesManager().register(NATWhitelistAPI.class, (Object)api, (Plugin)this, ServicePriority.Normal);
    }

    public void onDisable() {
        this.getServer().getServicesManager().unregister((Object)this);
    }

    public CheckVersion getCheckVersion() {
        return this.checkVersion;
    }

    public Whitelist getWhitelistListener() {
        return this.whitelist;
    }

    public void loadLang() {
        String lang = this.getConfig().getString("lang");
        File langFile = new File(this.getDataFolder(), "lang/" + lang + ".yml");
        if (!langFile.exists()) {
            this.saveResource("lang/" + lang + ".yml", false);
        }
        this.langConfig = YamlConfiguration.loadConfiguration((File)langFile);
    }

    public String getLangMessage(String key) {
        return this.langConfig.getString(key, "Message not found, please check your language file!");
    }

    private void saveAllLangResources() {
        String[] langs = new String[]{"en-us.yml", "fr-fr.yml"};
        File langDir = new File(this.getDataFolder(), "lang");
        if (!langDir.exists()) {
            langDir.mkdirs();
        }
        for (String langFile : langs) {
            File outFile = new File(langDir, langFile);
            if (outFile.exists()) continue;
            this.saveResource("lang/" + langFile, false);
        }
    }
}

