/*
 * Decompiled with CFR 0.152.
 */
package fr.Nat0uille.NATWhitelist.Listeners;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import fr.Nat0uille.NATWhitelist.Main;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class WhitelistListener {
    private final Connection conn;
    private Main main;
    private boolean enabled = false;
    private final List<String> removedPlayers = new ArrayList<String>();

    public WhitelistListener(Main main, Connection conn) {
        this.main = main;
        this.conn = conn;
    }

    public boolean add(String playerName) throws SQLException {
        UUID uuid = null;
        String correctName = WhitelistListener.getCorrectUsernameFromMojang(playerName);
        if (correctName != null) {
            OfflinePlayer player = Bukkit.getOfflinePlayer((String)correctName);
            uuid = player.getUniqueId();
            playerName = correctName;
        } else {
            Player onlinePlayer = Bukkit.getPlayer((String)playerName);
            if (onlinePlayer != null) {
                uuid = onlinePlayer.getUniqueId();
            } else {
                return false;
            }
        }
        String type = this.main.getConfig().getString("database.type");
        String sql = "MySQL".equalsIgnoreCase(type) ? "INSERT IGNORE INTO nat_whitelist (player_name, uuid) VALUES (?, ?)" : "INSERT OR IGNORE INTO nat_whitelist (player_name, uuid) VALUES (?, ?)";
        try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
            stmt.setString(1, playerName);
            stmt.setString(2, uuid.toString());
            boolean bl = stmt.executeUpdate() > 0;
            return bl;
        }
    }

    public boolean remove(String playerName) throws SQLException {
        String sql = "DELETE FROM nat_whitelist WHERE player_name = ?";
        try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
            stmt.setString(1, playerName);
            boolean bl = stmt.executeUpdate() > 0;
            return bl;
        }
    }

    public boolean isWhitelisted(String playerName) throws SQLException {
        String sql = "SELECT 1 FROM nat_whitelist WHERE player_name = ?";
        try (PreparedStatement stmt = this.conn.prepareStatement(sql);){
            boolean bl;
            block12: {
                stmt.setString(1, playerName);
                ResultSet rs = stmt.executeQuery();
                try {
                    bl = rs.next();
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return bl;
        }
    }

    public List<String> getWhitelistedPlayers() throws SQLException {
        ArrayList<String> players = new ArrayList<String>();
        String sql = "SELECT player_name FROM nat_whitelist";
        try (Statement stmt = this.conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                players.add(rs.getString("player_name"));
            }
        }
        return players;
    }

    public String listWhitelistedPlayers() throws SQLException {
        List<String> players = this.getWhitelistedPlayers();
        return String.join((CharSequence)", ", players);
    }

    public void setEnabled(boolean enabled) {
        this.main.getConfig().set("enabled", (Object)enabled);
        this.main.saveConfig();
    }

    public boolean isEnabled() {
        return this.main.getConfig().getBoolean("enabled", false);
    }

    public static String getCorrectUsernameFromMojang(String username) {
        try {
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + username);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            if (connection.getResponseCode() == 200) {
                JsonObject response = new JsonParser().parse((Reader)new InputStreamReader(connection.getInputStream())).getAsJsonObject();
                return response.get("name").getAsString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void kickNonWhitelistedPlayers(Main main) throws SQLException {
        MiniMessage mm = MiniMessage.miniMessage();
        Component prefix = mm.deserialize((Object)main.getConfig().getString("prefix"));
        Component kickmessage = mm.deserialize((Object)main.getConfig().getString("kickmessage"));
        boolean kicknonwhitelisted = main.getConfig().getBoolean("kicknonwhitelisted");
        if (!kicknonwhitelisted) {
            return;
        }
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.isWhitelisted(player.getName())) continue;
            player.kick(prefix.append(kickmessage));
        }
    }

    public void removeNonWhitelistedPlayers(Main main) throws SQLException {
        this.removedPlayers.clear();
        for (String playerName : this.getWhitelistedPlayers()) {
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player != null && player.isOnline()) continue;
            this.remove(playerName);
            this.removedPlayers.add(playerName);
        }
    }

    public List<String> getRemovedPlayers() {
        return this.removedPlayers;
    }
}

