/*
 * Decompiled with CFR 0.152.
 */
package fr.Nat0uille.NATWhitelist;

import fr.Nat0uille.NATWhitelist.CheckVersion;
import fr.Nat0uille.NATWhitelist.Commands.WhitelistCommand;
import fr.Nat0uille.NATWhitelist.Listeners.PlayerListener;
import fr.Nat0uille.NATWhitelist.Listeners.WhitelistListener;
import fr.Nat0uille.NATWhitelist.TabCompleter.WhitelistTabCompleter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin {
    private WhitelistListener whitelistListener;
    private WhitelistTabCompleter tabCompleter;
    private Connection sqlConnection;
    private CheckVersion checkVersion;

    public void onEnable() {
        this.saveDefaultConfig();
        String type = this.getConfig().getString("database.type");
        String host = this.getConfig().getString("database.host");
        int port = this.getConfig().getInt("database.port");
        String dbName = this.getConfig().getString("database.database");
        String username = this.getConfig().getString("database.username");
        String password = this.getConfig().getString("database.password");
        try {
            if ("MySQL".equalsIgnoreCase(type)) {
                Class.forName("com.mysql.cj.jdbc.Driver");
                String url = "jdbc:mysql://" + host + ":" + port + "/" + dbName;
                this.sqlConnection = DriverManager.getConnection(url, username, password);
                try (Statement stmt = this.sqlConnection.createStatement();){
                    stmt.executeUpdate("CREATE TABLE IF NOT EXISTS nat_whitelist (player_name VARCHAR(16) PRIMARY KEY, uuid VARCHAR(36))");
                }
                catch (SQLException e) {
                    this.getLogger().severe("Error creating table nat_whitelist: " + e.getMessage());
                }
            } else {
                Class.forName("org.sqlite.JDBC");
                if (!this.getDataFolder().exists()) {
                    this.getDataFolder().mkdirs();
                }
                String url = "jdbc:sqlite:" + this.getDataFolder().getAbsolutePath() + "/database.db";
                this.sqlConnection = DriverManager.getConnection(url);
                try (Statement stmt = this.sqlConnection.createStatement();){
                    stmt.executeUpdate("CREATE TABLE IF NOT EXISTS nat_whitelist (player_name TEXT PRIMARY KEY, uuid TEXT)");
                }
                catch (SQLException e) {
                    this.getLogger().severe("Error creating table nat_whitelist: " + e.getMessage());
                }
            }
            this.whitelistListener = new WhitelistListener(this, this.sqlConnection);
        }
        catch (Exception e) {
            this.getLogger().severe("Unable to connect to the SQL database: " + e.getMessage());
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.tabCompleter = new WhitelistTabCompleter(this.whitelistListener);
        this.getCommand("whitelist").setExecutor((CommandExecutor)new WhitelistCommand(this, this.whitelistListener));
        this.getCommand("whitelist").setTabCompleter((TabCompleter)this.tabCompleter);
        Bukkit.getScheduler().runTaskTimer((Plugin)this, this.tabCompleter::updateCache, 0L, 20L);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this.whitelistListener, this), (Plugin)this);
        this.checkVersion = new CheckVersion();
        CheckVersion.startVersionCheck((Plugin)this, this.checkVersion);
    }

    public void onDisable() {
        this.getLogger().info(this.getDescription().getName() + " d\u00e9sactiv\u00e9 !");
    }

    public Connection getSqlConnection() {
        return this.sqlConnection;
    }

    public CheckVersion getCheckVersion() {
        return this.checkVersion;
    }
}

