/*
 * Decompiled with CFR 0.152.
 */
package fr.Nat0uille.NATWhitelist.TabCompleter;

import fr.Nat0uille.NATWhitelist.Listeners.WhitelistListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class WhitelistTabCompleter
implements TabCompleter {
    private final WhitelistListener whitelistListener;
    private List<String> cachedPlayers = new ArrayList<String>();

    public WhitelistTabCompleter(WhitelistListener whitelistListener) {
        this.whitelistListener = whitelistListener;
        this.updateCache();
    }

    public void updateCache() {
        try {
            this.cachedPlayers = this.whitelistListener.getWhitelistedPlayers();
        }
        catch (SQLException e) {
            this.cachedPlayers = new ArrayList<String>();
            e.printStackTrace();
        }
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        this.updateCache();
        if (args.length == 1) {
            return Arrays.asList("add", "remove", "list", "on", "off", "removeoffilne");
        }
        if (args.length >= 2) {
            String prefix = args[args.length - 1].toLowerCase();
            List<String> alreadyTyped = Arrays.asList(Arrays.copyOfRange(args, 1, args.length - 1));
            ArrayList<String> result = new ArrayList<String>();
            if (args[0].equalsIgnoreCase("add")) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    String name = player.getName();
                    if (this.cachedPlayers.contains(name) || alreadyTyped.contains(name) || !prefix.isEmpty() && !name.toLowerCase().startsWith(prefix)) continue;
                    result.add(name);
                }
                return result;
            }
            if (args[0].equalsIgnoreCase("remove")) {
                for (String player : this.cachedPlayers) {
                    if (alreadyTyped.contains(player) || !prefix.isEmpty() && !player.toLowerCase().startsWith(prefix)) continue;
                    result.add(player);
                }
                return result;
            }
        }
        return Collections.emptyList();
    }
}

