/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.fastmap;

import net.minecraft.world.level.block.state.properties.Property;

public abstract class FastMapKey<T extends Comparable<T>> {
    private final Property<T> property;

    protected FastMapKey(Property<T> property) {
        this.property = property;
    }

    public abstract T getValue(int var1);

    public final int replaceIn(int mapIndex, Comparable<?> newValue) {
        int newPartialIndex = this.toPartialMapIndex(newValue);
        if (newPartialIndex < 0) {
            return -1;
        }
        return this.replaceIn(mapIndex, newPartialIndex);
    }

    public abstract int replaceIn(int var1, int var2);

    public final int toPartialMapIndex(Comparable<?> value) {
        int internalIndex = this.property.getInternalIndex(value);
        if (internalIndex < 0 || internalIndex >= this.numValues()) {
            return -1;
        }
        return this.toPartialMapIndex(internalIndex);
    }

    public abstract int toPartialMapIndex(int var1);

    abstract int getFactorToNext();

    public final int numValues() {
        return this.property.getPossibleValues().size();
    }

    public final Property<T> getProperty() {
        return this.property;
    }

    protected final T byInternalIndex(int internalIndex) {
        return (T)((Comparable)this.property.getPossibleValues().get(internalIndex));
    }
}

