/*
 * Decompiled with CFR 0.152.
 */
package malte0811.ferritecore.mixin.platform;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigSpec;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import malte0811.ferritecore.mixin.config.FerriteConfig;
import malte0811.ferritecore.mixin.config.IPlatformConfigHooks;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.fml.loading.moddiscovery.ModInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigFileHandler
implements IPlatformConfigHooks {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"ferritecore-overrides");

    @Override
    public void readAndUpdateConfig(List<FerriteConfig.Option> options) throws IOException {
        ConfigSpec spec = new ConfigSpec();
        for (FerriteConfig.Option o : options) {
            spec.define(o.getName(), (Object)o.getDefaultValue());
        }
        CommentedFileConfig configData = ConfigFileHandler.read(FMLPaths.CONFIGDIR.get().resolve("ferritecore-mixin.toml"));
        for (FerriteConfig.Option o : options) {
            configData.setComment(o.getName(), o.getComment());
        }
        spec.correct((Config)configData);
        configData.save();
        for (FerriteConfig.Option o : options) {
            o.set(arg_0 -> ((CommentedFileConfig)configData).get(arg_0));
        }
    }

    @Override
    public void collectDisabledOverrides(IPlatformConfigHooks.OverrideCallback disableOption) {
        for (ModInfo mod : FMLLoader.getCurrent().getLoadingModList().getMods()) {
            Optional maybeOverrides = mod.getConfigElement(new String[]{"ferritecore:disabled_options"});
            if (maybeOverrides.isEmpty()) continue;
            Object object = maybeOverrides.get();
            if (object instanceof List) {
                List overrides = (List)object;
                for (Object override : overrides) {
                    if (override instanceof String) {
                        String overrideName = (String)override;
                        disableOption.addOverride(overrideName, mod.getModId());
                        continue;
                    }
                    LOGGER.warn("Override list for {} contains non-string {}", (Object)mod.getModId(), override);
                }
                continue;
            }
            LOGGER.warn("Overrides for {} are not a list: {}", (Object)mod.getModId(), maybeOverrides.get());
        }
    }

    private static CommentedFileConfig read(Path configPath) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)configPath).sync().preserveInsertionOrder().build();
        configData.load();
        return configData;
    }
}

