/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.client.gui.config.ConfigImageButton;
import com.momosoftworks.coldsweat.client.gui.util.WidgetSprites;
import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.common.event.HearthSaveDataHandler;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.DisableHearthParticlesMessage;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.EffectRenderingInventoryScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public abstract class AbstractHearthScreen<T extends AbstractContainerMenu>
extends EffectRenderingInventoryScreen<T> {
    public static final WidgetSprites PARTICLES_BUTTON_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/sprites/hearth/particle_button_on.png"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/sprites/hearth/particle_button_off.png"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/sprites/hearth/particle_button_on_focus.png"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/sprites/hearth/particle_button_off_focus.png"));
    public static final WidgetSprites POWER_INDICATOR_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/sprites/hearth/power_indicator_off.png"), ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/sprites/hearth/power_indicator_on.png"));
    public static final ResourceLocation HOT_FUEL_GAUGE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/sprites/hearth/fuel_gauge_hot.png");
    public static final ResourceLocation HOT_FUEL_GAUGE_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/sprites/hearth/fuel_gauge_hot_empty.png");
    public static final ResourceLocation COLD_FUEL_GAUGE = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/sprites/hearth/fuel_gauge_cold.png");
    public static final ResourceLocation COLD_FUEL_GAUGE_EMPTY = ResourceLocation.fromNamespaceAndPath((String)"cold_sweat", (String)"textures/gui/sprites/hearth/fuel_gauge_cold_empty.png");
    ImageButton particleButton = null;
    Pair<BlockPos, ResourceLocation> levelPos = Pair.of((Object)this.getBlockEntity().m_58899_(), (Object)this.getBlockEntity().m_58904_().m_46472_().m_135782_());
    boolean hideParticles;
    boolean hideParticlesOld = this.hideParticles = HearthSaveDataHandler.DISABLED_HEARTHS.contains(this.levelPos);

    abstract HearthBlockEntity getBlockEntity();

    public AbstractHearthScreen(T screenContainer, Inventory inv, Component title) {
        super(screenContainer, inv, title);
    }

    public void m_7856_() {
        super.m_7856_();
        if (this.getBlockEntity().hasSmokestack()) {
            this.particleButton = (ImageButton)this.m_142416_((GuiEventListener)new ConfigImageButton(this.f_97735_ + 160, this.f_97736_ + 8, 8, 7, PARTICLES_BUTTON_SPRITES, 8, 7, button -> {
                boolean bl = this.hideParticles = !this.hideParticles;
                if (this.hideParticles) {
                    HearthSaveDataHandler.DISABLED_HEARTHS.add(this.levelPos);
                    if (HearthSaveDataHandler.DISABLED_HEARTHS.size() > 64) {
                        HearthSaveDataHandler.DISABLED_HEARTHS.remove(HearthSaveDataHandler.DISABLED_HEARTHS.iterator().next());
                    }
                } else {
                    HearthSaveDataHandler.DISABLED_HEARTHS.remove(this.levelPos);
                }
                Field imageX = ObfuscationReflectionHelper.findField(ImageButton.class, (String)"f_94224_");
                imageX.setAccessible(true);
                try {
                    imageX.set(button, 176 + (!this.hideParticles ? 0 : 8));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }){

                public boolean m_6375_(double mouseX, double mouseY, int button) {
                    if (this.f_93623_ && this.f_93624_ && this.m_7972_(button) && this.m_93680_(mouseX, mouseY)) {
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_12444_, (float)(!AbstractHearthScreen.this.hideParticles ? 1.5f : 1.9f), (float)0.75f));
                        this.m_5716_(mouseX, mouseY);
                        return true;
                    }
                    return false;
                }

                public void m_7428_(PoseStack poseStack, int mouseX, int mouseY) {
                    AbstractHearthScreen.this.renderComponentTooltip(poseStack, List.of(new TranslatableComponent("cold_sweat.screen.hearth.show_particles")), mouseX, mouseY, AbstractHearthScreen.this.f_96547_);
                }

                @Override
                protected boolean isEnabled() {
                    return !AbstractHearthScreen.this.hideParticles;
                }
            });
        }
    }

    public void m_6305_(PoseStack ps, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(ps);
        super.m_6305_(ps, mouseX, mouseY, partialTicks);
        this.m_7025_(ps, mouseX, mouseY);
    }

    public void m_7379_() {
        super.m_7379_();
        if (this.f_96541_.f_91074_ != null && this.hideParticlesOld != this.hideParticles) {
            ColdSweatPacketHandler.INSTANCE.sendToServer((Object)new DisableHearthParticlesMessage(HearthSaveDataHandler.serializeDisabledHearths()));
        }
    }

    protected void renderFuelGauge(HearthBlockEntity.FuelType fuelType, PoseStack poseStack, int x, int y, int fuel, int maxFuel) {
        ResourceLocation emptyTexture = fuelType == HearthBlockEntity.FuelType.HOT ? HOT_FUEL_GAUGE_EMPTY : COLD_FUEL_GAUGE_EMPTY;
        ResourceLocation fullTexture = fuelType == HearthBlockEntity.FuelType.HOT ? HOT_FUEL_GAUGE : COLD_FUEL_GAUGE;
        int maxGaugeHeight = 14;
        int gaugeHeight = fuel <= 0 ? 0 : Math.round(CSMath.blend(2.0f, 14.0f, fuel, 0.0f, maxFuel));
        RenderSystem.m_157456_((int)0, (ResourceLocation)emptyTexture);
        Screen.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)14, (int)14, (int)14, (int)14);
        RenderSystem.m_157456_((int)0, (ResourceLocation)fullTexture);
        Screen.m_93133_((PoseStack)poseStack, (int)x, (int)(y + (maxGaugeHeight - gaugeHeight)), (float)0.0f, (float)(maxGaugeHeight - gaugeHeight), (int)14, (int)gaugeHeight, (int)14, (int)14);
    }

    protected void renderPowerIndicator(PoseStack poseStack, int x, int y, boolean powered) {
        ResourceLocation sprite = POWER_INDICATOR_SPRITES.get(true, powered);
        RenderSystem.m_157456_((int)0, (ResourceLocation)sprite);
        Screen.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)13, (int)4, (int)13, (int)4);
    }
}

