/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.api.temperature.modifier.FoodTempModifier;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.event.TooltipHandler;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.common.capability.temperature.PlayerTempCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.math.Vec2i;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class Overlays {
    public static final ResourceLocation BODY_TEMP_GAUGE = new ResourceLocation("cold_sweat:textures/gui/overlay/body_temp_gauge.png");
    public static final ResourceLocation BODY_TEMP_GAUGE_HC = new ResourceLocation("cold_sweat:textures/gui/overlay/body_temp_gauge_hc.png");
    public static final ResourceLocation WORLD_TEMP_GAUGE = new ResourceLocation("cold_sweat:textures/gui/overlay/world_temp_gauge.png");
    public static final ResourceLocation WORLD_TEMP_GAUGE_HC = new ResourceLocation("cold_sweat:textures/gui/overlay/world_temp_gauge_hc.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE = new ResourceLocation("cold_sweat:textures/gui/overlay/vague_temp_gauge.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE_HC = new ResourceLocation("cold_sweat:textures/gui/overlay/vague_temp_gauge_hc.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE_STANDALONE = new ResourceLocation("cold_sweat:textures/gui/overlay/vague_temp_gauge_standalone.png");
    public static final ResourceLocation VAGUE_TEMP_GAUGE_STANDALONE_HC = new ResourceLocation("cold_sweat:textures/gui/overlay/vague_temp_gauge_standalone_hc.png");
    public static final ResourceLocation FOOD_EFFECT = new ResourceLocation("cold_sweat:textures/gui/overlay/food_effect_background.png");
    public static final Supplier<ResourceLocation> BODY_TEMP_GAUGE_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? BODY_TEMP_GAUGE_HC : BODY_TEMP_GAUGE;
    public static final Supplier<ResourceLocation> WORLD_TEMP_GAUGE_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? WORLD_TEMP_GAUGE_HC : WORLD_TEMP_GAUGE;
    public static final Supplier<ResourceLocation> VAGUE_TEMP_GAUGE_LOCATION = () -> ConfigSettings.BODY_ICON_ENABLED.get().booleanValue() ? (ConfigSettings.HIGH_CONTRAST.get().booleanValue() ? VAGUE_TEMP_GAUGE_HC : VAGUE_TEMP_GAUGE) : (ConfigSettings.HIGH_CONTRAST.get() != false ? VAGUE_TEMP_GAUGE_STANDALONE_HC : VAGUE_TEMP_GAUGE_STANDALONE);
    static boolean ADVANCED_WORLD_TEMP = false;
    public static double WORLD_TEMP = 0.0;
    static double PREV_WORLD_TEMP = 0.0;
    static double PLAYER_MAX_TEMP = 0.0;
    static double PLAYER_MIN_TEMP = 0.0;
    static double BODY_TEMP = 0.0;
    static double PREV_BODY_TEMP = 0.0;
    public static double BLEND_BODY_TEMP = 0.0;
    static int ICON_BOB = 0;
    static double BODY_TEMP_SEVERITY = 0.0;
    public static IIngameOverlay WORLD_TEMP_OVERLAY = (gui, poseStack, partialTick, width, height) -> {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && ADVANCED_WORLD_TEMP && Minecraft.m_91087_().f_91072_.m_105295_() != GameType.SPECTATOR && !Minecraft.m_91087_().f_91066_.f_92062_ && ConfigSettings.WORLD_GAUGE_ENABLED.get().booleanValue()) {
            gui.setupOverlayRenderState(true, false);
            double temp = Temperature.convert(WORLD_TEMP, ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F, Temperature.Units.MC, true);
            int severity = Overlays.getGaugeSeverity(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP);
            int color = Overlays.getWorldTempColor(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP);
            poseStack.m_85836_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WORLD_TEMP_GAUGE_LOCATION.get());
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(width / 2 + 93 + ConfigSettings.WORLD_GAUGE_POS.get().x()), (int)(height - 19 + ConfigSettings.WORLD_GAUGE_POS.get().y()), (float)0.0f, (float)(64 - severity * 16), (int)25, (int)16, (int)25, (int)144);
            RenderSystem.m_69461_();
            int bob = ConfigSettings.ICON_BOBBING.get() != false && !CSMath.betweenInclusive(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP) && player.f_19797_ % 2 == 0 ? 1 : 0;
            int blendedTemp = (int)CSMath.blend(PREV_WORLD_TEMP, WORLD_TEMP, (double)Minecraft.m_91087_().m_91296_(), 0.0, 1.0);
            Minecraft.m_91087_().f_91062_.m_92883_(poseStack, "" + (blendedTemp + ConfigSettings.TEMP_OFFSET.get()), (float)(width / 2 + 106 + Integer.toString(blendedTemp + ConfigSettings.TEMP_OFFSET.get()).length() * -3 + ConfigSettings.WORLD_GAUGE_POS.get().x()), (float)(height - 15 - bob + ConfigSettings.WORLD_GAUGE_POS.get().y()), color);
            poseStack.m_85849_();
        }
    };
    public static IIngameOverlay BODY_TEMP_OVERLAY = (gui, poseStack, partialTick, width, height) -> {
        gui.setupOverlayRenderState(true, false);
        Minecraft mc = Minecraft.m_91087_();
        BLEND_BODY_TEMP = CSMath.blend(PREV_BODY_TEMP, BODY_TEMP, (double)Minecraft.m_91087_().m_91296_(), 0.0, 1.0);
        double bodyTempInt = CSMath.roundNearest(BLEND_BODY_TEMP, 1.0);
        if (gui.shouldDrawSurvivalElements() && !Minecraft.m_91087_().f_91066_.f_92062_) {
            int color;
            int n = bodyTempInt > 0.0 ? 16744509 : (color = bodyTempInt < 0.0 ? 4233468 : 0xAFAFAF);
            int colorBG = bodyTempInt < 0.0 ? 1122643 : (bodyTempInt > 0.0 ? 5376516 : 0);
            int bobLevel = Math.min(Math.abs((int)BODY_TEMP_SEVERITY), 3);
            int threatOffset = ConfigSettings.ICON_BOBBING.get() == false ? 0 : (bobLevel == 2 ? ICON_BOB : (bobLevel == 3 ? Minecraft.m_91087_().f_91075_.f_19797_ % 2 : 0));
            RenderSystem.m_69453_();
            RenderSystem.m_157456_((int)0, (ResourceLocation)BODY_TEMP_GAUGE_LOCATION.get());
            if (ConfigSettings.BODY_ICON_ENABLED.get().booleanValue()) {
                int icon = Math.abs(bodyTempInt) < 100.0 ? CSMath.floor(BODY_TEMP_SEVERITY) : 4 * CSMath.sign(BODY_TEMP_SEVERITY);
                int iconX = width / 2 - 5 + ConfigSettings.BODY_ICON_POS.get().x();
                int iconYOffset = ADVANCED_WORLD_TEMP && ConfigSettings.MOVE_BODY_ICON_WHEN_ADVANCED.get() != false ? 54 : 47;
                int iconY = height - iconYOffset - threatOffset + ConfigSettings.BODY_ICON_POS.get().y();
                GuiComponent.m_93133_((PoseStack)poseStack, (int)iconX, (int)iconY, (float)0.0f, (float)(40 - icon * 10), (int)10, (int)10, (int)10, (int)90);
                if (CSMath.betweenExclusive(Math.abs(bodyTempInt), 0.0, 100.0)) {
                    double blend = CSMath.blend(1.0, 9.0, Math.abs(BODY_TEMP_SEVERITY), (double)Math.abs(CSMath.floor(BODY_TEMP_SEVERITY)), (double)Math.abs(CSMath.ceil(BODY_TEMP_SEVERITY)));
                    GuiComponent.m_93133_((PoseStack)poseStack, (int)iconX, (int)(iconY + 10 - CSMath.ceil(blend)), (float)0.0f, (float)(40 - CSMath.grow(icon, bodyTempInt > 0.0 ? 0 : 2) * 10 - CSMath.ceil(blend)), (int)10, (int)CSMath.ceil(blend), (int)10, (int)90);
                }
            }
            if (ConfigSettings.BODY_READOUT_ENABLED.get().booleanValue() && ADVANCED_WORLD_TEMP) {
                Font font = mc.f_91062_;
                int scaledWidth = mc.m_91268_().m_85445_();
                int scaledHeight = mc.m_91268_().m_85446_();
                String s = "" + (int)Math.min(Math.abs(bodyTempInt), 100.0);
                int x = (scaledWidth - font.m_92895_(s)) / 2 + ConfigSettings.BODY_READOUT_POS.get().x();
                int y = scaledHeight - 31 - 10 + ConfigSettings.BODY_READOUT_POS.get().y();
                font.m_92883_(poseStack, s, (float)(x + 1), (float)y, colorBG);
                font.m_92883_(poseStack, s, (float)(x - 1), (float)y, colorBG);
                font.m_92883_(poseStack, s, (float)x, (float)(y + 1), colorBG);
                font.m_92883_(poseStack, s, (float)x, (float)(y - 1), colorBG);
                font.m_92883_(poseStack, s, (float)x, (float)y, color);
                if (Math.abs(bodyTempInt) > 100.0) {
                    int textHeight = font.m_92920_(s, 100);
                    int overlayHeight = (int)CSMath.roundUpNearest(CSMath.blend(2.0, (double)textHeight, Math.abs(bodyTempInt), 100.0, 150.0), 1.0);
                    int overlayColor = overlayHeight > 3 ? (bodyTempInt > 0.0 ? 0xFFFFAC : 0xB0FFFF) : (bodyTempInt > 0.0 ? 16771975 : 0x84F4FF);
                    int overlayColor2 = bodyTempInt > 0.0 ? 16759634 : 7528447;
                    ClientOnlyHelper.renderVerticalCropText(s, x, y, Math.min(textHeight, overlayHeight + 1), overlayColor2, poseStack);
                    ClientOnlyHelper.renderVerticalCropText(s, x, y, overlayHeight, overlayColor, poseStack);
                }
            }
        }
    };
    public static IIngameOverlay VAGUE_TEMP_OVERLAY = (gui, poseStack, partialTick, width, height) -> {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && !ADVANCED_WORLD_TEMP && mc.f_91072_.m_105295_() != GameType.SPECTATOR && !mc.f_91066_.f_92062_ && ConfigSettings.WORLD_GAUGE_ENABLED.get().booleanValue() && gui.shouldDrawSurvivalElements()) {
            gui.setupOverlayRenderState(true, false);
            double temp = Temperature.convert(WORLD_TEMP, ConfigSettings.CELSIUS.get() != false ? Temperature.Units.C : Temperature.Units.F, Temperature.Units.MC, true);
            int severity = Overlays.getGaugeSeverity(temp, PLAYER_MIN_TEMP, PLAYER_MAX_TEMP);
            int renderOffset = CSMath.clamp(severity, -1, 1) * 2;
            poseStack.m_85836_();
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            int bobLevel = Math.min(Math.abs((int)BODY_TEMP_SEVERITY), 3);
            int threatOffset = ConfigSettings.ICON_BOBBING.get() == false ? 0 : (bobLevel == 2 ? ICON_BOB : (bobLevel == 3 ? Minecraft.m_91087_().f_91075_.f_19797_ % 2 : 0));
            RenderSystem.m_157456_((int)0, (ResourceLocation)VAGUE_TEMP_GAUGE_LOCATION.get());
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(width / 2 - 8 + ConfigSettings.BODY_ICON_POS.get().x()), (int)(height - 50 + ConfigSettings.BODY_ICON_POS.get().y() - renderOffset - threatOffset), (float)0.0f, (float)(64 - severity * 16), (int)16, (int)16, (int)16, (int)144);
            RenderSystem.m_69461_();
            poseStack.m_85849_();
        }
    };
    public static IIngameOverlay FOOD_EFFECTS_OVERLAY = (gui, poseStack, partialTick, width, height) -> {
        if (!ConfigSettings.FOOD_EFFECTS_ENABLED.get().booleanValue()) {
            return;
        }
        gui.setupOverlayRenderState(true, false);
        RenderSystem.m_69478_();
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        poseStack.m_85836_();
        Vec2i pos = ConfigSettings.FOOD_EFFECTS_POS.get();
        poseStack.m_85837_((double)pos.x, (double)pos.y, 0.0);
        int offset = 0;
        for (Map.Entry<Temperature.Trait, List<TempModifier>> entry : Temperature.getModifiers((LivingEntity)player).entrySet()) {
            Temperature.Trait trait = entry.getKey();
            ArrayList modifierList = new ArrayList(entry.getValue());
            List<FoodTempModifier> sortedModifiers = modifierList.stream().filter(mod -> mod instanceof FoodTempModifier).map(mod -> (FoodTempModifier)mod).sorted((m1, m2) -> {
                int sign2;
                int sign1 = CSMath.sign(m1.getNBT().m_128459_("temperature"));
                if (sign1 != (sign2 = CSMath.sign(m2.getNBT().m_128459_("temperature")))) {
                    return Integer.compare(sign1, sign2);
                }
                return Double.compare(Math.abs(m1.getNBT().m_128459_("temperature")), Math.abs(m2.getNBT().m_128459_("temperature")));
            }).toList();
            for (TempModifier tempModifier : sortedModifiers) {
                if (!(tempModifier instanceof FoodTempModifier)) continue;
                FoodTempModifier food = (FoodTempModifier)tempModifier;
                int x = width - 10;
                int y = height - 10 - offset;
                if (food.getNBT().m_128459_("duration") == 0.0) continue;
                int timeLeft = food.getExpireTime() - food.getTicksExisted();
                double temp = food.getNBT().m_128459_("temperature");
                boolean overridden = food.isOverridden(trait);
                RenderSystem.m_157456_((int)0, (ResourceLocation)FOOD_EFFECT);
                AbstractContainerScreen.m_93133_((PoseStack)poseStack, (int)(x - 76), (int)(y - 24), (float)0.0f, (float)0.0f, (int)76, (int)24, (int)76, (int)24);
                String sign = temp > 0.0 ? "\u2191" : "\u2193";
                Object tempString = CSMath.formatDoubleOrInt(CSMath.round(temp, 2));
                if (temp < 0.0) {
                    tempString = ((String)tempString).substring(1);
                }
                tempString = sign + (String)tempString;
                String timerString = StringUtil.m_14404_((int)timeLeft);
                int contentWidth = mc.f_91062_.m_92895_((String)tempString) + mc.f_91062_.m_92895_(timerString) + 20;
                int contentHeight = 16;
                x -= 76;
                poseStack.m_85836_();
                poseStack.m_85837_((double)(38 - contentWidth / 2), (double)(12 - contentHeight / 2), 0.0);
                float brightness = overridden ? 0.35f : 1.0f;
                RenderSystem.m_157429_((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                if (timeLeft < 200) {
                    float alpha = (float)CSMath.blend(1.0, Math.sin((double)((float)food.getTicksExisted() + partialTick) / 1.5) / 2.0 + 0.5, (double)timeLeft, 200.0, 0.0);
                    RenderSystem.m_157429_((float)brightness, (float)brightness, (float)brightness, (float)alpha);
                }
                Font font = mc.f_91062_;
                float f = x;
                Objects.requireNonNull(mc.f_91062_);
                font.m_92756_(poseStack, timerString, f, (float)(y - 9 - 11), ChatFormatting.WHITE.m_126665_().intValue(), true);
                RenderSystem.m_157429_((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(food.getNBT().m_128461_("item")));
                mc.m_91291_().m_115123_(item.m_7968_(), (x += mc.f_91062_.m_92895_(timerString) + 2) + 8, y - 20);
                int color = temp > 0.0 ? TooltipHandler.HOT.m_131135_().m_131265_() : (temp < 0.0 ? TooltipHandler.COLD.m_131135_().m_131265_() : ChatFormatting.WHITE.m_126665_().intValue());
                Font font2 = mc.f_91062_;
                float f2 = x += 18;
                Objects.requireNonNull(mc.f_91062_);
                font2.m_92756_(poseStack, (String)tempString, f2, (float)(y - 9 - 11), color, true);
                offset += 25;
                poseStack.m_85849_();
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        poseStack.m_85849_();
    };

    public static double getWorldSeverity(double temp, double playerMin, double playerMax) {
        double normalMax;
        if (temp < playerMin) {
            return -1.0;
        }
        if (temp > playerMax) {
            return 1.0;
        }
        double normalMin = ConfigSettings.Difficulty.NORMAL.getSetting(ConfigSettings.MIN_TEMP);
        double mid = Overlays.calculateMidpoint(playerMin, playerMax, normalMin, normalMax = ConfigSettings.Difficulty.NORMAL.getSetting(ConfigSettings.MAX_TEMP).doubleValue());
        return temp < mid ? CSMath.blend(-1.0, 0.0, temp, playerMin, mid) : CSMath.blend(0.0, 1.0, temp, mid, playerMax);
    }

    private static double calculateMidpoint(double playerMin, double playerMax, double normalMin, double normalMax) {
        boolean bothBelowNormal = playerMin < normalMin && playerMax < normalMax;
        boolean bothAboveNormal = playerMin > normalMin && playerMax > normalMax;
        return bothBelowNormal || bothAboveNormal ? (playerMin + playerMax) / 2.0 : (normalMin + normalMax) / 2.0;
    }

    public static int getGaugeSeverity(double temp, double playerMin, double playerMax) {
        return (int)(Overlays.getWorldSeverity(temp, playerMin, playerMax) * 4.0);
    }

    static double getBodySeverity(int temp) {
        int sign = CSMath.sign(temp);
        int absTemp = Math.abs(temp);
        return (absTemp < 100 ? CSMath.blend(0.0, 3.0, (double)absTemp, 0.0, 100.0) : CSMath.blend(3.0, 7.0, (double)absTemp, 100.0, 150.0)) * (double)sign;
    }

    public static void setBodyTempInstant(double temp) {
        BODY_TEMP = temp;
        PREV_BODY_TEMP = temp;
        BLEND_BODY_TEMP = (int)temp;
    }

    public static void setWorldTempInstant(double temp) {
        WORLD_TEMP = temp;
        PREV_WORLD_TEMP = temp;
    }

    public static int getWorldTempColor(double temp, double playerMin, double playerMax) {
        int severity = Overlays.getGaugeSeverity(temp, playerMin, playerMax);
        return switch (severity) {
            case 2, 3 -> 16297781;
            case 4 -> 16728089;
            case -3, -2 -> 8443135;
            case -4 -> 4236031;
            default -> 14737376;
        };
    }

    static {
        OverlayRegistry.registerOverlayBelow((IIngameOverlay)ForgeIngameGui.HOTBAR_ELEMENT, (String)"world_temp", (IIngameOverlay)WORLD_TEMP_OVERLAY);
        OverlayRegistry.registerOverlayBelow((IIngameOverlay)ForgeIngameGui.HOTBAR_ELEMENT, (String)"body_temp", (IIngameOverlay)BODY_TEMP_OVERLAY);
        OverlayRegistry.registerOverlayBelow((IIngameOverlay)ForgeIngameGui.HOTBAR_ELEMENT, (String)"vague_temp", (IIngameOverlay)VAGUE_TEMP_OVERLAY);
        OverlayRegistry.registerOverlayBelow((IIngameOverlay)ForgeIngameGui.HOTBAR_ELEMENT, (String)"food_effects", (IIngameOverlay)FOOD_EFFECTS_OVERLAY);
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static final class TickOverlays {
        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (event.phase == TickEvent.Phase.START && player != null && player.m_6084_()) {
                EntityTempManager.getTemperatureCap((Entity)player).ifPresent(arg_0 -> TickOverlays.lambda$onClientTick$0((Player)player, arg_0));
            }
        }

        private static /* synthetic */ void lambda$onClientTick$0(Player player, ITemperatureCap icap) {
            if (!(icap instanceof PlayerTempCap)) {
                return;
            }
            PlayerTempCap cap = (PlayerTempCap)icap;
            cap.calculateHudVisibility(player);
            ADVANCED_WORLD_TEMP = cap.showAdvancedWorldTemp();
            boolean celsius = ConfigSettings.CELSIUS.get();
            double worldTemp = cap.getTrait(Temperature.Trait.WORLD);
            double realTemp = Temperature.convert(worldTemp, Temperature.Units.MC, celsius ? Temperature.Units.C : Temperature.Units.F, true);
            double diff = realTemp - WORLD_TEMP;
            PREV_WORLD_TEMP = WORLD_TEMP;
            WORLD_TEMP += Math.abs(diff) <= 1.0 ? diff : CSMath.maxAbs(diff / ConfigSettings.TEMP_SMOOTHING.get(), 0.25 * (double)CSMath.sign(diff));
            PLAYER_MAX_TEMP = cap.getTrait(Temperature.Trait.BURNING_POINT);
            PLAYER_MIN_TEMP = cap.getTrait(Temperature.Trait.FREEZING_POINT);
            PREV_BODY_TEMP = BODY_TEMP;
            BODY_TEMP += (cap.getTrait(Temperature.Trait.BODY) - BODY_TEMP) / 2.0;
            ICON_BOB = player.f_19797_ % 3 == 0 && Math.random() < 0.3 ? 1 : 0;
            BODY_TEMP_SEVERITY = Overlays.getBodySeverity((int)BLEND_BODY_TEMP);
        }
    }
}

