/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.tooltip;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.momosoftworks.coldsweat.api.insulation.AdaptiveInsulation;
import com.momosoftworks.coldsweat.api.insulation.Insulation;
import com.momosoftworks.coldsweat.api.insulation.StaticInsulation;
import com.momosoftworks.coldsweat.common.capability.handler.ItemInsulationManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.InsulatorData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@OnlyIn(value=Dist.CLIENT)
public class ClientInsulationTooltip
implements ClientTooltipComponent {
    public static final ResourceLocation TOOLTIP = new ResourceLocation("cold_sweat:textures/gui/tooltip/insulation_bar.png");
    public static final ResourceLocation TOOLTIP_HC = new ResourceLocation("cold_sweat:textures/gui/tooltip/insulation_bar_hc.png");
    public static final Supplier<ResourceLocation> TOOLTIP_LOCATION = () -> ConfigSettings.HIGH_CONTRAST.get() != false ? TOOLTIP_HC : TOOLTIP;
    List<InsulatorData> insulation;
    Insulation.Slot slot;
    static int WIDTH = 0;
    ItemStack stack;
    boolean strikethrough;
    private static final Method INNER_BLIT = ObfuscationReflectionHelper.findMethod(GuiComponent.class, (String)"m_93187_", (Class[])new Class[]{PoseStack.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE});
    static boolean RECURSIVE;

    public static void innerBlit(PoseStack poseStack, int x1, int x2, int y1, int y2, int zOffset, int uWidth, int vHeight, float uOffset, float vOffset, int textureWidth, int textureHeight) {
        try {
            INNER_BLIT.invoke(null, poseStack, x1, x2, y1, y2, zOffset, uWidth, vHeight, Float.valueOf(uOffset), Float.valueOf(vOffset), textureWidth, textureHeight);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void blit(PoseStack poseStack, int x, int y, int zOffset, int width, int height, float uOffset, float vOffset, int uWidth, int vHeight, int textureWidth, int textureHeight) {
        ClientInsulationTooltip.innerBlit(poseStack, x, x + width, y, y + height, zOffset, uWidth, vHeight, uOffset, vOffset, textureWidth, textureHeight);
    }

    public ClientInsulationTooltip(List<InsulatorData> insulation, Insulation.Slot slot, ItemStack stack, boolean strikethrough) {
        this.insulation = insulation;
        this.slot = slot;
        this.stack = stack;
        this.strikethrough = strikethrough;
    }

    public int m_142103_() {
        return 10;
    }

    public int m_142069_(Font font) {
        return WIDTH;
    }

    public void m_183452_(Font font, int x, int y, PoseStack poseStack, ItemRenderer itemRenderer, int depth) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TOOLTIP_LOCATION.get());
        ArrayList<Insulation> posInsulation = new ArrayList<Insulation>();
        int extraInsulations = 0;
        ArrayList<Insulation> negInsulation = new ArrayList<Insulation>();
        for (InsulatorData data : this.insulation) {
            List<Insulation> insulations;
            List<Insulation> list = insulations = data.fillSlots() ? Insulation.splitList(data.insulation()) : data.insulation();
            if (!data.fillSlots() && data.slot() == Insulation.Slot.ARMOR) {
                extraInsulations += insulations.size();
            }
            for (Insulation ins : insulations) {
                if (ins instanceof StaticInsulation) {
                    StaticInsulation insul = (StaticInsulation)ins;
                    double cold = insul.getCold();
                    double heat = insul.getHeat();
                    if (CSMath.sign(cold) == CSMath.sign(heat)) {
                        switch (CSMath.sign(cold)) {
                            case -1: {
                                negInsulation.add(ins);
                                break;
                            }
                            case 1: {
                                posInsulation.add(ins);
                            }
                        }
                        continue;
                    }
                    switch (CSMath.sign(cold)) {
                        case -1: {
                            negInsulation.add(new StaticInsulation(-cold, 0.0));
                            break;
                        }
                        case 1: {
                            posInsulation.add(new StaticInsulation(cold, 0.0));
                        }
                    }
                    switch (CSMath.sign(heat)) {
                        case -1: {
                            negInsulation.add(new StaticInsulation(0.0, heat));
                            break;
                        }
                        case 1: {
                            posInsulation.add(new StaticInsulation(0.0, heat));
                        }
                    }
                    continue;
                }
                if (!(ins instanceof AdaptiveInsulation)) continue;
                AdaptiveInsulation adaptive = (AdaptiveInsulation)ins;
                double value = adaptive.getInsulation();
                if (value < 0.0) {
                    negInsulation.add(ins);
                    continue;
                }
                posInsulation.add(ins);
            }
        }
        poseStack.m_85836_();
        WIDTH = 0;
        if (!posInsulation.isEmpty() || ConfigSettings.INSULATION_VISIBILITY.get().showsIfEmpty()) {
            BarType barType = negInsulation.isEmpty() ? BarType.NONE : BarType.POSITIVE;
            WIDTH += ClientInsulationTooltip.renderBar(poseStack, x + WIDTH, y, posInsulation, extraInsulations, this.slot, this.stack, barType);
        }
        if (!negInsulation.isEmpty()) {
            if (!posInsulation.isEmpty()) {
                WIDTH += 4;
            }
            WIDTH += ClientInsulationTooltip.renderBar(poseStack, x + WIDTH, y, negInsulation, 0, this.slot, this.stack, BarType.NEGATIVE);
        }
        poseStack.m_85849_();
        if (this.strikethrough) {
            Screen.m_93172_((PoseStack)poseStack, (int)(x - 1), (int)(y + 2), (int)(x + 8), (int)(y + 3), (int)-642510);
            Screen.m_93172_((PoseStack)poseStack, (int)x, (int)(y + 3), (int)(x + 9), (int)(y + 4), (int)-642510);
        }
    }

    static void renderCell(PoseStack poseStack, int x, int y, Insulation insulation) {
        AdaptiveInsulation adaptive;
        RenderSystem.m_157456_((int)0, (ResourceLocation)TOOLTIP_LOCATION.get());
        double rounded = CSMath.roundNearest(Math.abs(insulation.getValue()), 0.25);
        int uvX = 0;
        if (insulation instanceof AdaptiveInsulation) {
            AdaptiveInsulation adaptive2 = (AdaptiveInsulation)insulation;
            uvX = !RECURSIVE ? 16 : (adaptive2.getFactor() < 0.0 ? 10 : (adaptive2.getFactor() == 0.0 ? 16 : 22));
        } else if (insulation instanceof StaticInsulation) {
            double heat;
            StaticInsulation stat = (StaticInsulation)insulation;
            double cold = Math.abs(stat.getCold());
            int n = cold > (heat = Math.abs(stat.getHeat())) ? 10 : (uvX = cold == heat ? 16 : 22);
        }
        int uvY = insulation instanceof AdaptiveInsulation ? (rounded >= 2.0 ? 16 : 20) : (rounded >= 2.0 ? 8 : 12);
        ClientInsulationTooltip.renderCellBackground(poseStack, x, y);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TOOLTIP_LOCATION.get());
        Screen.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)0, (float)uvX, (float)uvY, (int)6, (int)4, (int)36, (int)28);
        if (insulation instanceof AdaptiveInsulation && (adaptive = (AdaptiveInsulation)insulation).getFactor() != 0.0 && !RECURSIVE) {
            double blend = Math.abs(adaptive.getFactor());
            RenderSystem.m_69478_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)((float)blend));
            RECURSIVE = true;
            ClientInsulationTooltip.renderCell(poseStack, x, y, insulation);
            RenderSystem.m_69461_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        RECURSIVE = false;
    }

    static void renderCellBackground(PoseStack poseStack, int x, int y) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TOOLTIP_LOCATION.get());
        Screen.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)0, (float)0.0f, (float)0.0f, (int)6, (int)4, (int)36, (int)28);
    }

    static void renderIcon(PoseStack poseStack, int x, int y, Insulation.Slot slot, BarType type) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TOOLTIP_LOCATION.get());
        switch (slot) {
            case ITEM: {
                Screen.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)0, (float)28.0f, (float)0.0f, (int)8, (int)8, (int)36, (int)28);
                break;
            }
            case ARMOR: {
                Screen.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)0, (float)28.0f, (float)8.0f, (int)8, (int)8, (int)36, (int)28);
                break;
            }
            case CURIO: {
                Screen.m_93143_((PoseStack)poseStack, (int)x, (int)y, (int)0, (float)28.0f, (float)16.0f, (int)8, (int)8, (int)36, (int)28);
            }
        }
        switch (type) {
            case POSITIVE: {
                Screen.m_93143_((PoseStack)poseStack, (int)(x + 3), (int)(y + 3), (int)0, (float)18.0f, (float)0.0f, (int)5, (int)5, (int)36, (int)28);
                break;
            }
            case NEGATIVE: {
                Screen.m_93143_((PoseStack)poseStack, (int)(x + 3), (int)(y + 3), (int)0, (float)23.0f, (float)0.0f, (int)5, (int)5, (int)36, (int)28);
            }
        }
    }

    static int renderBar(PoseStack poseStack, int x, int y, List<Insulation> insulations, int extraSlots, Insulation.Slot slot, ItemStack stack, BarType type) {
        extraSlots = Math.min(ItemInsulationManager.getInsulationSlots(stack), extraSlots);
        RenderSystem.m_157456_((int)0, (ResourceLocation)TOOLTIP_LOCATION.get());
        List<Insulation> sortedInsulation = Insulation.sort(insulations);
        ClientInsulationTooltip.setAdaptations(sortedInsulation, stack);
        Mode mode = Screen.m_96637_() || sortedInsulation.stream().map(Insulation::split).mapToInt(List::size).sum() > 10 ? Mode.OVERFLOW : (insulations.stream().anyMatch(insul -> insul.split().size() > 1) ? Mode.COMPOUND : Mode.NORMAL);
        int armorSlots = slot == Insulation.Slot.ARMOR && type != BarType.NEGATIVE && ItemInsulationManager.isInsulatable(stack) ? ItemInsulationManager.getInsulationSlots(stack) : 0;
        int slots = Math.max(armorSlots, insulations.size());
        poseStack.m_85836_();
        int finalWidth = mode == Mode.OVERFLOW ? ClientInsulationTooltip.renderOverflowBar(poseStack, x + 8, y, sortedInsulation, slots) : (mode == Mode.COMPOUND ? ClientInsulationTooltip.renderCompoundBar(poseStack, x + 7, y, sortedInsulation, extraSlots, slots) : ClientInsulationTooltip.renderNormalBar(poseStack, x + 7, y, sortedInsulation, slots + extraSlots));
        poseStack.m_85849_();
        ClientInsulationTooltip.renderIcon(poseStack, x, y, slot, type);
        if (mode != Mode.OVERFLOW) {
            finalWidth += 2;
        }
        return finalWidth + 6;
    }

    static int renderNormalBar(PoseStack poseStack, int x, int y, List<Insulation> insulations, int slots) {
        int i;
        for (i = 0; i < insulations.size(); ++i) {
            Insulation insulation = insulations.get(i);
            ClientInsulationTooltip.renderCell(poseStack, x + i * 6, y + 2, insulation);
        }
        for (i = insulations.size(); i < slots; ++i) {
            ClientInsulationTooltip.renderCellBackground(poseStack, x + i * 6, y + 2);
        }
        for (i = 0; i < slots; ++i) {
            BorderSegment segment = ClientInsulationTooltip.getBorderSegment(slots, i);
            if (segment == BorderSegment.SINGLE) {
                segment = BorderSegment.TAIL;
            }
            if (segment == BorderSegment.HEAD) {
                segment = BorderSegment.BODY;
            }
            ClientInsulationTooltip.renderCellBorder(poseStack, x + i * 6, y + 2, segment, BorderType.NORMAL);
        }
        return Math.max(insulations.size(), slots) * 6;
    }

    static int renderCompoundBar(PoseStack poseStack, int x, int y, List<Insulation> insulations, int extraSlots, int slots) {
        int cellX = 0;
        int compoundCount = 0;
        for (int i = 0; i < insulations.size(); ++i) {
            Insulation insulation = insulations.get(i);
            List<Insulation> subInsulations = Insulation.sort(insulation.split());
            if (subInsulations.size() > 1) {
                ++compoundCount;
                for (int j = 0; j < subInsulations.size(); ++j) {
                    Insulation subInsul = subInsulations.get(j);
                    BorderSegment segment = ClientInsulationTooltip.getBorderSegment(subInsulations.size(), j);
                    ClientInsulationTooltip.renderCell(poseStack, x + cellX, y + 2, subInsul);
                    ClientInsulationTooltip.renderCellBorder(poseStack, x + cellX, y + 2, segment, BorderType.COMPOUND);
                    cellX += 6;
                }
                if (i >= slots - 1) continue;
                cellX += 3;
                continue;
            }
            int normalCount = insulations.size() - compoundCount;
            ClientInsulationTooltip.renderCell(poseStack, x + cellX, y + 2, insulation);
            BorderSegment segment = ClientInsulationTooltip.getBorderSegment(normalCount, i - compoundCount);
            if (segment == BorderSegment.TAIL && i < slots - 1) {
                segment = BorderSegment.BODY;
            }
            BorderType borderType = segment == BorderSegment.TAIL ? BorderType.NORMAL : BorderType.SEGMENT;
            ClientInsulationTooltip.renderCellBorder(poseStack, x + cellX, y + 2, segment, borderType);
            cellX += 6;
            if (i >= slots - 1) continue;
            ClientInsulationTooltip.renderCellBorder(poseStack, x + cellX, y + 2, BorderSegment.BODY, BorderType.DIVIDER);
            ++cellX;
        }
        int emptySlots = slots - insulations.size() + extraSlots;
        for (int i = 0; i < emptySlots; ++i) {
            BorderSegment segment = ClientInsulationTooltip.getBorderSegment(emptySlots, i);
            if (segment == BorderSegment.SINGLE) {
                segment = BorderSegment.TAIL;
            }
            BorderType borderType = segment == BorderSegment.TAIL ? BorderType.NORMAL : BorderType.SEGMENT;
            ClientInsulationTooltip.renderCellBackground(poseStack, x + cellX, y + 2);
            ClientInsulationTooltip.renderCellBorder(poseStack, x + cellX, y + 2, segment, borderType);
            if (emptySlots == 1 && segment == BorderSegment.TAIL) {
                ClientInsulationTooltip.renderCellBorder(poseStack, x + cellX - 1, y + 2, BorderSegment.TAIL, BorderType.DIVIDER);
            }
            cellX += 6;
        }
        return cellX;
    }

    static int renderOverflowBar(PoseStack poseStack, int x, int y, List<Insulation> insulations, int slots) {
        int width = 0;
        Font font = Minecraft.m_91087_().f_91062_;
        double cold = 0.0;
        double heat = 0.0;
        double neutral = 0.0;
        double adaptive = 0.0;
        for (Insulation insulation : insulations) {
            if (insulation instanceof StaticInsulation) {
                double thisHeat;
                StaticInsulation staticInsulation = (StaticInsulation)insulation;
                double thisCold = Math.abs(staticInsulation.getCold());
                if (thisCold == (thisHeat = Math.abs(staticInsulation.getHeat()))) {
                    neutral += thisCold;
                    continue;
                }
                cold += thisCold;
                heat += thisHeat;
                continue;
            }
            if (!(insulation instanceof AdaptiveInsulation)) continue;
            AdaptiveInsulation adaptiveInsulation = (AdaptiveInsulation)insulation;
            double thisAdaptive = Math.abs(adaptiveInsulation.getInsulation());
            adaptive += thisAdaptive;
        }
        int textColor = 0xA0A0A0;
        poseStack.m_85836_();
        if (insulations.size() < slots) {
            int xOffs = ClientInsulationTooltip.renderEmptyBar(poseStack, x, y + 2, slots - insulations.size());
            width += xOffs;
            poseStack.m_85837_((double)xOffs, 0.0, 0.0);
        }
        if (cold > 0.0) {
            int xOffs = ClientInsulationTooltip.renderOverflowCell(poseStack, font, x + 1, y + 2, new StaticInsulation(cold, 0.0), textColor);
            width += xOffs;
            poseStack.m_85837_((double)xOffs, 0.0, 0.0);
        }
        if (heat > 0.0) {
            int xOffs = ClientInsulationTooltip.renderOverflowCell(poseStack, font, x + 1, y + 2, new StaticInsulation(0.0, heat), textColor);
            width += xOffs;
            poseStack.m_85837_((double)xOffs, 0.0, 0.0);
        }
        if (neutral > 0.0) {
            int xOffs = ClientInsulationTooltip.renderOverflowCell(poseStack, font, x + 1, y + 2, new StaticInsulation(neutral, neutral), textColor);
            width += xOffs;
            poseStack.m_85837_((double)xOffs, 0.0, 0.0);
        }
        if (adaptive > 0.0) {
            int xOffs = ClientInsulationTooltip.renderOverflowCell(poseStack, font, x + 1, y + 2, new AdaptiveInsulation(adaptive, 0.0), textColor);
            width += xOffs;
            poseStack.m_85837_((double)xOffs, 0.0, 0.0);
        }
        poseStack.m_85849_();
        return width;
    }

    static int renderOverflowCell(PoseStack poseStack, Font font, int x, int y, Insulation insulation, int textColor) {
        Number insul = CSMath.truncate(insulation.getValue() / 2.0, 2);
        if (CSMath.isInteger(insul)) {
            insul = ((Number)insul).intValue();
        }
        String text = "x" + insul;
        ClientInsulationTooltip.renderCell(poseStack, x, y, insulation);
        ClientInsulationTooltip.renderCellBorder(poseStack, x, y, BorderSegment.HEAD, BorderType.OVERFLOW);
        ClientInsulationTooltip.renderCellBorder(poseStack, x, y, BorderSegment.BODY, BorderType.OVERFLOW);
        ClientInsulationTooltip.renderCellBorder(poseStack, x, y, BorderSegment.TAIL, BorderType.OVERFLOW);
        Screen.m_93236_((PoseStack)poseStack, (Font)font, (String)text, (int)(x + 8), (int)(y - 2), (int)textColor);
        return 12 + font.m_92895_(text);
    }

    static int renderEmptyBar(PoseStack poseStack, int x, int y, int size) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TOOLTIP_LOCATION.get());
        for (int i = 0; i < size; ++i) {
            BorderSegment segment = ClientInsulationTooltip.getBorderSegment(size, i);
            Screen.m_93143_((PoseStack)poseStack, (int)(x + 7 + i * 6), (int)(y + 1), (int)0, (float)0.0f, (float)0.0f, (int)6, (int)4, (int)36, (int)28);
            ClientInsulationTooltip.renderCellBorder(poseStack, x + i * 6, y, segment, BorderType.OVERFLOW);
        }
        poseStack.m_85836_();
        poseStack.m_85849_();
        return size * 6 + 4;
    }

    static void renderCellBorder(PoseStack poseStack, int x, int y, BorderSegment segment, BorderType type) {
        RenderSystem.m_157456_((int)1, (ResourceLocation)TOOLTIP_LOCATION.get());
        block0 : switch (type) {
            case DIVIDER: {
                Screen.m_93143_((PoseStack)poseStack, (int)x, (int)(y - 1), (int)0, (float)10.0f, (float)0.0f, (int)1, (int)6, (int)36, (int)28);
                break;
            }
            case EMPTY_DIVIDER: {
                Screen.m_93143_((PoseStack)poseStack, (int)x, (int)(y - 1), (int)0, (float)11.0f, (float)0.0f, (int)1, (int)6, (int)36, (int)28);
                break;
            }
            default: {
                int vOffset = switch (type) {
                    case BorderType.NORMAL -> 4;
                    case BorderType.OVERFLOW -> 10;
                    case BorderType.SEGMENT -> 16;
                    case BorderType.COMPOUND -> 22;
                    default -> 0;
                };
                switch (segment) {
                    case SINGLE: {
                        if (RECURSIVE) break block0;
                        RECURSIVE = true;
                        ClientInsulationTooltip.renderCellBorder(poseStack, x, y, BorderSegment.HEAD, type);
                        ClientInsulationTooltip.renderCellBorder(poseStack, x, y, BorderSegment.TAIL, type);
                        ClientInsulationTooltip.renderCellBorder(poseStack, x, y, BorderSegment.BODY, type);
                        RECURSIVE = false;
                        break block0;
                    }
                    case HEAD: {
                        Screen.m_93143_((PoseStack)poseStack, (int)(x - 1), (int)(y - 1), (int)0, (float)0.0f, (float)vOffset, (int)7, (int)6, (int)36, (int)28);
                        break block0;
                    }
                    case BODY: {
                        Screen.m_93143_((PoseStack)poseStack, (int)(x + 0), (int)(y - 1), (int)0, (float)2.0f, (float)vOffset, (int)6, (int)6, (int)36, (int)28);
                        break block0;
                    }
                    case TAIL: {
                        Screen.m_93143_((PoseStack)poseStack, (int)(x + 0), (int)(y - 1), (int)0, (float)3.0f, (float)vOffset, (int)7, (int)6, (int)36, (int)28);
                    }
                }
            }
        }
    }

    static BorderSegment getBorderSegment(int collectionSize, int index) {
        if (collectionSize == 1) {
            return BorderSegment.SINGLE;
        }
        if (index == collectionSize - 1) {
            return BorderSegment.TAIL;
        }
        if (index == 0) {
            return BorderSegment.HEAD;
        }
        return BorderSegment.BODY;
    }

    static void setAdaptations(List<Insulation> insulations, ItemStack stack) {
        for (int i = 0; i < insulations.size(); ++i) {
            Object insul = insulations.get(i).copy();
            if (insul instanceof AdaptiveInsulation) {
                AdaptiveInsulation adaptive = (AdaptiveInsulation)insul;
                AdaptiveInsulation.readFactorFromArmor(adaptive, stack);
            }
            insulations.set(i, (Insulation)insul);
        }
    }

    static {
        INNER_BLIT.setAccessible(true);
        RECURSIVE = false;
    }

    private static enum BarType {
        POSITIVE,
        NEGATIVE,
        NONE;

    }

    private static enum Mode {
        NORMAL,
        COMPOUND,
        OVERFLOW;

    }

    private static enum BorderSegment {
        HEAD,
        BODY,
        TAIL,
        SINGLE;

    }

    private static enum BorderType {
        NORMAL,
        OVERFLOW,
        SEGMENT,
        COMPOUND,
        DIVIDER,
        EMPTY_DIVIDER;

    }
}

