/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.model.entity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.momosoftworks.coldsweat.client.renderer.ChameleonAnimations;
import com.momosoftworks.coldsweat.client.renderer.animation.AnimationManager;
import com.momosoftworks.coldsweat.client.renderer.entity.ChameleonEntityRenderer;
import com.momosoftworks.coldsweat.common.entity.Chameleon;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModEntities;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ChameleonModel<T extends Chameleon>
extends AgeableListModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("cold_sweat", "chameleon"), "main");
    final Map<String, ModelPart> modelParts;
    final ModelPart body;
    final ModelPart head;
    Chameleon chameleon;
    boolean tongueVisible = false;

    public ChameleonModel(ModelPart root) {
        super(RenderType::m_110473_, true, 4.75f, 0.75f, 1.8f, 1.6f, 14.0f);
        this.body = root.m_171324_("Body");
        this.head = root.m_171324_("Head");
        this.head.f_104201_ = 19.2f;
        this.body.f_104201_ -= 0.8f;
        this.modelParts = AnimationManager.getChildrenMap(root);
        AnimationManager.storeDefaultPoses(ModEntities.CHAMELEON, this.modelParts);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(1, 16).m_171488_(-2.0f, -8.0f, -3.0f, 4.0f, 7.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition Head = partdefinition.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -2.0f, -7.0f, 4.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-5.0f, (float)-3.0f));
        PartDefinition TopFrill = Head.m_171599_("TopFrill", CubeListBuilder.m_171558_().m_171514_(30, 0).m_171488_(-1.0f, 1.4f, 0.05f, 2.0f, 4.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-5.0f, (float)0.7418f, (float)0.0f, (float)0.0f));
        PartDefinition Jaw = Head.m_171599_("Jaw", CubeListBuilder.m_171558_().m_171514_(15, 7).m_171488_(-2.0f, 0.0f, -7.0f, 4.0f, 1.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(18, 15).m_171488_(0.0f, 1.0f, -6.0f, 0.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition RightEye = Head.m_171599_("RightEye", CubeListBuilder.m_171558_().m_171514_(15, 1).m_171488_(-1.5f, -1.5f, -1.5f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)0.0f, (float)-3.5f));
        PartDefinition LeftEye = Head.m_171599_("LeftEye", CubeListBuilder.m_171558_().m_171514_(15, 1).m_171480_().m_171488_(-5.0E-4f, -1.4782f, -1.634f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)1.0005f, (float)-0.0218f, (float)-3.366f));
        PartDefinition Tongue1 = Head.m_171599_("Tongue1", CubeListBuilder.m_171558_().m_171514_(27, 25).m_171488_(-1.0f, 0.0f, -7.0f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition Tongue2 = Tongue1.m_171599_("Tongue2", CubeListBuilder.m_171558_().m_171514_(27, 25).m_171488_(-1.0f, -3.0f, -10.0f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)3.0f));
        PartDefinition Tongue3 = Tongue2.m_171599_("Tongue3", CubeListBuilder.m_171558_().m_171514_(27, 25).m_171488_(-1.0f, -3.0f, -10.0f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightFrontLeg = Body.m_171599_("RightFrontLeg", CubeListBuilder.m_171558_().m_171514_(38, 25).m_171480_().m_171488_(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition RightFrontLeg2 = RightFrontLeg.m_171599_("RightFrontLeg2", CubeListBuilder.m_171558_().m_171514_(38, 29).m_171480_().m_171488_(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightFrontFoot1 = RightFrontLeg2.m_171599_("RightFrontFoot1", CubeListBuilder.m_171558_().m_171514_(28, 27).m_171480_().m_171488_(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightFrontFoot2 = RightFrontLeg2.m_171599_("RightFrontFoot2", CubeListBuilder.m_171558_().m_171514_(28, 24).m_171480_().m_171488_(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFrontLeg = Body.m_171599_("LeftFrontLeg", CubeListBuilder.m_171558_().m_171514_(38, 25).m_171488_(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-3.0f, (float)-1.0f));
        PartDefinition LeftFrontLeg2 = LeftFrontLeg.m_171599_("LeftFrontLeg2", CubeListBuilder.m_171558_().m_171514_(38, 29).m_171488_(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFrontFoot1 = LeftFrontLeg2.m_171599_("LeftFrontFoot1", CubeListBuilder.m_171558_().m_171514_(28, 27).m_171488_(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftFrontFoot2 = LeftFrontLeg2.m_171599_("LeftFrontFoot2", CubeListBuilder.m_171558_().m_171514_(28, 24).m_171488_(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightBackLeg = Body.m_171599_("RightBackLeg", CubeListBuilder.m_171558_().m_171514_(38, 25).m_171480_().m_171488_(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)-3.0f, (float)4.0f));
        PartDefinition RightBackLeg2 = RightBackLeg.m_171599_("RightBackLeg2", CubeListBuilder.m_171558_().m_171514_(38, 29).m_171480_().m_171488_(-4.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightBackFoot1 = RightBackLeg2.m_171599_("RightBackFoot1", CubeListBuilder.m_171558_().m_171514_(28, 27).m_171480_().m_171488_(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition RightBackFoot2 = RightBackLeg2.m_171599_("RightBackFoot2", CubeListBuilder.m_171558_().m_171514_(28, 24).m_171480_().m_171488_(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftBackLeg = Body.m_171599_("LeftBackLeg", CubeListBuilder.m_171558_().m_171514_(38, 25).m_171488_(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-3.0f, (float)4.0f));
        PartDefinition LeftBackLeg2 = LeftBackLeg.m_171599_("LeftBackLeg2", CubeListBuilder.m_171558_().m_171514_(38, 29).m_171488_(0.0f, -1.0f, -1.0f, 4.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftBackFoot1 = LeftBackLeg2.m_171599_("LeftBackFoot1", CubeListBuilder.m_171558_().m_171514_(28, 27).m_171488_(0.0f, -3.0f, -1.0f, 0.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftBackFoot2 = LeftBackLeg2.m_171599_("LeftBackFoot2", CubeListBuilder.m_171558_().m_171514_(27, 24).m_171488_(0.0f, 0.0f, -1.0f, 0.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)0.0f, (float)0.0f));
        PartDefinition Tail = Body.m_171599_("Tail", CubeListBuilder.m_171558_().m_171514_(34, 18).m_171488_(-1.5f, -1.5f, 0.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.5f, (float)6.0f));
        PartDefinition Tail2 = Tail.m_171599_("Tail2", CubeListBuilder.m_171558_().m_171514_(38, 13).m_171488_(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.0f));
        PartDefinition Tail3 = Tail2.m_171599_("Tail3", CubeListBuilder.m_171558_().m_171514_(0, 17).m_171488_(-0.5f, -1.0f, 0.0f, 1.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)3.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)48, (int)32);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean hasLookTarget;
        this.chameleon = entity;
        AnimationManager.loadAnimationStates(entity, this.modelParts);
        float tickDelta = Minecraft.m_91087_().m_91297_();
        float partialTick = Minecraft.m_91087_().m_91296_();
        ModelPart head = this.modelParts.get("Head");
        ModelPart rightEye = this.modelParts.get("RightEye");
        ModelPart leftEye = this.modelParts.get("LeftEye");
        float desiredXHead = CSMath.toRadians(headPitch);
        boolean bl = hasLookTarget = ((Chameleon)((Object)entity)).isWalking() || ((Chameleon)((Object)entity)).getEatTimer() > 0.0f;
        if (Double.isNaN(((Chameleon)((Object)entity)).xRotHead)) {
            ((Chameleon)((Object)entity)).xRotHead = 0.0f;
        }
        ((Chameleon)((Object)entity)).xRotHead = ((Chameleon)((Object)entity)).xRotHead + ((hasLookTarget ? desiredXHead : CSMath.clamp(((Chameleon)((Object)entity)).xRotHead, desiredXHead - 0.4f, desiredXHead + 0.4f)) - ((Chameleon)((Object)entity)).xRotHead) * tickDelta;
        float desiredYHead = CSMath.toRadians(netHeadYaw);
        if (Double.isNaN(((Chameleon)((Object)entity)).yRotHead)) {
            ((Chameleon)((Object)entity)).yRotHead = 0.0f;
        }
        ((Chameleon)((Object)entity)).yRotHead = ((Chameleon)((Object)entity)).yRotHead + ((hasLookTarget ? desiredYHead : CSMath.clamp(((Chameleon)((Object)entity)).yRotHead, desiredYHead - 0.6f, desiredYHead + 0.6f)) - ((Chameleon)((Object)entity)).yRotHead) * tickDelta;
        if (head.f_104204_ < desiredYHead) {
            ((Chameleon)((Object)entity)).yRotRightEye += (-CSMath.clamp(desiredYHead - head.f_104204_, -0.5f, 0.5f) - ((Chameleon)((Object)entity)).yRotRightEye) * tickDelta;
            ((Chameleon)((Object)entity)).xRotRightEye += (-CSMath.clamp(desiredXHead - head.f_104203_, -0.5f, 0.5f) - ((Chameleon)((Object)entity)).xRotRightEye) * tickDelta;
        } else {
            ((Chameleon)((Object)entity)).yRotRightEye += (0.0f - ((Chameleon)((Object)entity)).yRotRightEye) * tickDelta;
            ((Chameleon)((Object)entity)).xRotRightEye += (0.0f - ((Chameleon)((Object)entity)).xRotRightEye) * tickDelta;
        }
        if (head.f_104204_ > desiredYHead) {
            ((Chameleon)((Object)entity)).yRotLeftEye += (CSMath.clamp(head.f_104204_ - desiredYHead, -0.5f, 0.5f) - ((Chameleon)((Object)entity)).yRotLeftEye) * tickDelta;
            ((Chameleon)((Object)entity)).xRotLeftEye += (CSMath.clamp(desiredXHead - head.f_104203_, -0.5f, 0.5f) - ((Chameleon)((Object)entity)).xRotLeftEye) * tickDelta;
        } else {
            T t = entity;
            ((Chameleon)((Object)t)).yRotLeftEye = ((Chameleon)((Object)t)).yRotLeftEye + -((Chameleon)((Object)entity)).yRotLeftEye * tickDelta;
            t = entity;
            ((Chameleon)((Object)t)).xRotLeftEye = ((Chameleon)((Object)t)).xRotLeftEye + -((Chameleon)((Object)entity)).xRotLeftEye * tickDelta;
        }
        head.f_104203_ = ((Chameleon)((Object)entity)).xRotHead;
        head.f_104204_ = ((Chameleon)((Object)entity)).yRotHead;
        rightEye.f_104204_ = ((Chameleon)((Object)entity)).yRotRightEye;
        rightEye.f_104205_ = ((Chameleon)((Object)entity)).xRotRightEye;
        leftEye.f_104204_ = ((Chameleon)((Object)entity)).yRotLeftEye;
        leftEye.f_104205_ = ((Chameleon)((Object)entity)).xRotLeftEye;
        AnimationManager.saveAnimationStates(entity, this.modelParts);
        AnimationManager.animateEntity(entity, (animTime, frameTime) -> {
            Vec3 velocity;
            Entity patt12712$temp;
            float prevAnimTime = animTime.floatValue();
            HashMap<String, ModelPart> animatedParts = new HashMap<String, ModelPart>(this.modelParts);
            animatedParts.remove("Head");
            animatedParts.remove("LeftEye");
            animatedParts.remove("RightEye");
            ModelPart tail = (ModelPart)animatedParts.remove("Tail");
            ModelPart tail2 = (ModelPart)animatedParts.remove("Tail2");
            ModelPart tail3 = (ModelPart)animatedParts.remove("Tail3");
            if (this.f_102609_ && (patt12712$temp = entity.m_20202_()) instanceof Player) {
                Player player = (Player)patt12712$temp;
                float playerYaw = CSMath.blend(player.f_20886_, player.f_20885_, partialTick, 0.0f, 1.0f);
                animTime = Float.valueOf(animTime.floatValue() + frameTime.floatValue());
                ChameleonAnimations.RIDE.animateAll(animatedParts, animTime.floatValue(), false);
                if (!this.chameleon.isTracking()) {
                    ChameleonAnimations.RIDE.animate("Tail", tail, 0.0f, false);
                    ChameleonAnimations.RIDE.animate("Tail2", tail2, 0.0f, false);
                    ChameleonAnimations.RIDE.animate("Tail3", tail3, 0.0f, false);
                }
                if (this.f_102610_) {
                    this.body.f_104201_ -= 14.0f;
                    head.f_104201_ -= 4.0f;
                }
                this.body.f_104201_ -= player.m_20206_() / 2.0f * 16.0f - 4.0f;
                head.f_104201_ -= player.m_20206_() / 2.0f * 16.0f + 11.0f;
                this.body.f_104204_ = CSMath.toRadians(playerYaw) - CSMath.toRadians(CSMath.blend(player.f_20884_, player.f_20883_, partialTick, 0.0f, 1.0f));
                head.f_104204_ = CSMath.toRadians(entity.m_5675_(partialTick) - player.m_5675_(partialTick)) + 0.2f;
                head.f_104203_ = CSMath.clamp(CSMath.toRadians(entity.m_5686_(partialTick) - player.m_5686_(partialTick)) + 0.2f, -1.0f, 1.0f);
            } else if (entity.isWalking()) {
                float walkSpeed = Math.min(0.15f, new Vec2((float)entity.m_20184_().f_82479_, (float)entity.m_20184_().f_82481_).m_165907_());
                animTime = Float.valueOf(animTime.floatValue() + frameTime.floatValue() * walkSpeed * (float)(this.f_102610_ ? 50 : 30));
                ChameleonAnimations.WALK.animateAll(animatedParts, animTime.floatValue(), true);
                if (!this.chameleon.isTracking()) {
                    ChameleonAnimations.WALK.animate("Tail", tail, animTime.floatValue(), true);
                    ChameleonAnimations.WALK.animate("Tail2", tail2, animTime.floatValue(), true);
                    ChameleonAnimations.WALK.animate("Tail3", tail3, animTime.floatValue(), true);
                }
            } else {
                animTime = Float.valueOf(animTime.floatValue() + frameTime.floatValue());
                ChameleonAnimations.IDLE.animateAll(animatedParts, animTime.floatValue(), true);
                if (!this.chameleon.isTracking()) {
                    ChameleonAnimations.WALK.animate("Tail", tail, 0.0f, true);
                    ChameleonAnimations.WALK.animate("Tail2", tail2, 0.0f, true);
                    ChameleonAnimations.WALK.animate("Tail3", tail3, 0.0f, true);
                }
            }
            if (this.chameleon.isTracking()) {
                float rotY;
                BlockPos trackingPos = this.chameleon.getTrackingPos();
                Vec3 entityPos = entity.m_20318_(partialTick);
                Vec3 trackingDirection = new Vec3((double)trackingPos.m_123341_() - entityPos.f_82479_, 0.0, (double)trackingPos.m_123343_() - entityPos.f_82481_);
                float playerRotX = 0.0f;
                Entity patt15220$temp = entity.m_20202_();
                if (patt15220$temp instanceof Player) {
                    Player player = (Player)patt15220$temp;
                    playerRotX = player.m_5686_(partialTick);
                    rotY = CSMath.blend(player.f_20886_, player.f_20885_, partialTick, 0.0f, 1.0f);
                } else {
                    rotY = CSMath.blend(entity.f_20884_, entity.f_20883_, partialTick, 0.0f, 1.0f);
                }
                float angle = (float)Math.atan2(trackingDirection.f_82481_, trackingDirection.f_82479_) - CSMath.toRadians(Mth.m_14177_((float)rotY));
                float desiredTailRot = angle + CSMath.toRadians(90.0f);
                tail.f_104204_ = tail2.f_104204_ = (float)Math.sin(desiredTailRot) / 1.3f;
                tail3.f_104204_ = tail2.f_104204_;
                tail2.f_104203_ = Math.max(0.0f, (float)Math.sin((double)desiredTailRot - 1.5707963267948966) + 0.2f);
                tail3.f_104203_ = tail2.f_104203_ / 1.5f;
                tail.f_104203_ = tail3.f_104203_ - CSMath.toRadians(playerRotX) / 1.25f + 0.1f;
            }
            if (entity.getEatTimer() > 0.0f) {
                this.tongueVisible = true;
                ChameleonAnimations.EAT.animateAll(this.modelParts, CSMath.blend(0.5f, 0.0f, entity.getEatTimer() - Minecraft.m_91087_().m_91296_(), 0.0f, entity.getEatAnimLength()), true);
            } else {
                this.tongueVisible = false;
            }
            if (Minecraft.m_91087_().m_91104_()) {
                return Float.valueOf(prevAnimTime);
            }
            float playerXHead = 0.0f;
            Entity patt16646$temp = entity.m_20202_();
            if (patt16646$temp instanceof Player) {
                Player player = (Player)patt16646$temp;
                playerXHead = CSMath.toRadians(player.m_5686_(partialTick));
            }
            Vec3 vec3 = velocity = playerXHead != 0.0f ? entity.m_20202_().m_20184_() : entity.m_20184_();
            if (!this.chameleon.isTracking()) {
                float speed = (float)Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_);
                float tailSpeed = Math.min(0.1f, speed / 2.0f) + 0.01f;
                float deltaTime = Minecraft.m_91087_().m_91297_();
                this.chameleon.tailPhase = (float)((double)this.chameleon.tailPhase + Math.PI * 2 * (double)deltaTime * (double)tailSpeed);
                float speedStraightFactor = 3.0f + speed * 100.0f;
                float tailRot1 = (float)Math.sin(this.chameleon.tailPhase - 0.0f) / speedStraightFactor;
                float tailRot2 = (float)Math.sin(this.chameleon.tailPhase - 1.0f) / speedStraightFactor;
                float tailRot3 = (float)Math.sin(this.chameleon.tailPhase - 2.0f) / speedStraightFactor;
                float tailRotation = 1.0f + Math.abs(tail.f_104203_ - 0.2f) * 1.0f;
                tail.f_104204_ = tailRot1 / tailRotation;
                tail2.f_104204_ = tailRot2 / tailRotation;
                tail3.f_104204_ = tailRot3 / tailRotation;
            }
            float playerYVel = (float)velocity.f_82480_;
            if (Double.isNaN(entity.xRotTail)) {
                entity.xRotTail = 0.0f;
            }
            float tailRot = entity.xRotTail = (float)((double)entity.xRotTail + (CSMath.clamp((double)playerYVel, -0.5, 0.5) - (double)entity.xRotTail) * (double)frameTime.floatValue() * 8.0);
            tailRot = (float)((double)tailRot * CSMath.clamp((double)Math.abs(tail.f_104203_ + tail2.f_104203_ + tail3.f_104203_ + playerXHead) - 2.3, -1.0, 1.0));
            tail.f_104203_ += tailRot;
            tail2.f_104203_ += tailRot;
            tail3.f_104203_ += tailRot;
            return animTime;
        });
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.renderToBuffer(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha, false);
    }

    protected Iterable<ModelPart> m_5607_() {
        return List.of(this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return List.of(this.body);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha, boolean isOverlay) {
        if (this.chameleon == null) {
            return;
        }
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        float partialTick = Minecraft.m_91087_().m_91296_();
        long tickCount = this.chameleon.f_19797_;
        long hurtTime = this.chameleon.getHurtTimestamp();
        if (!isOverlay && this.chameleon.m_6084_()) {
            if (CSMath.betweenInclusive(tickCount - hurtTime, 0.0, 40.0) && hurtTime != 0L) {
                this.chameleon.opacity = CSMath.blend(alpha, alpha * 0.15f, (float)tickCount + partialTick - (float)hurtTime, 0.0f, 40.0f);
            } else if (this.chameleon.opacity < alpha) {
                this.chameleon.opacity = CSMath.blend(alpha * 0.15f, alpha, (float)tickCount + partialTick - (float)hurtTime, 120.0f, 180.0f);
            }
        }
        ModelPart tongue1 = this.modelParts.get("Tongue1");
        tongue1.f_104207_ = false;
        super.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, isOverlay ? alpha : this.chameleon.opacity);
        if (this.tongueVisible && !isOverlay) {
            poseStack.m_85836_();
            ModelPart jaw = this.modelParts.get("Jaw");
            VertexConsumer tongueConsumer = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110452_((ResourceLocation)ChameleonEntityRenderer.CHAMELEON_GREEN));
            tongue1.f_104207_ = true;
            poseStack.m_85837_(0.0, 1.1555, -0.18755);
            tongue1.f_104203_ = this.head.f_104203_ + jaw.f_104203_ / 2.0f;
            tongue1.f_104204_ = this.head.f_104204_;
            tongue1.m_104306_(poseStack, tongueConsumer, packedLight, packedOverlay, red, green, blue, this.chameleon.opacity);
            poseStack.m_85849_();
        }
        RenderSystem.m_69461_();
    }
}

