/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity;

import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.renderer.animation.AnimationManager;
import com.momosoftworks.coldsweat.common.entity.data.edible.ChameleonEdibles;
import com.momosoftworks.coldsweat.common.entity.data.edible.Edible;
import com.momosoftworks.coldsweat.common.entity.goals.EatObjectsGoal;
import com.momosoftworks.coldsweat.common.entity.goals.LazyLookGoal;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.EntityInit;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.ChameleonEatMessage;
import com.momosoftworks.coldsweat.core.network.message.EntityMountMessage;
import com.momosoftworks.coldsweat.data.loot.ModLootTables;
import com.momosoftworks.coldsweat.data.tag.ModEntityTags;
import com.momosoftworks.coldsweat.data.tag.ModItemTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModItems;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class Chameleon
extends Animal {
    static Method GET_DATA_ITEM = ObfuscationReflectionHelper.findMethod(SynchedEntityData.class, (String)"m_135379_", (Class[])new Class[]{EntityDataAccessor.class});
    static final EntityDataAccessor<Integer> SHED_TIME;
    static final EntityDataAccessor<Integer> LAST_SHED;
    static final EntityDataAccessor<Integer> HURT_TIMESTAMP;
    static final EntityDataAccessor<CompoundTag> TRUSTED_PLAYERS;
    static final EntityDataAccessor<BlockPos> TRACKING_POS;
    static final EntityDataAccessor<Integer> EAT_TIMESTAMP;
    static final EntityDataAccessor<Float> TEMPERATURE;
    static final EntityDataAccessor<CompoundTag> EDIBLE_COOLDOWNS;
    static final EntityDataAccessor<Boolean> SEARCHING;
    static final EntityDataAccessor<Integer> AGE_SECS;
    public float xRotHead = 0.0f;
    public float yRotHead = 0.0f;
    public float xRotLeftEye = 0.0f;
    public float yRotLeftEye = 0.0f;
    public float xRotRightEye = 0.0f;
    public float yRotRightEye = 0.0f;
    public float xRotTail = 0.0f;
    public float tailPhase = 0.0f;
    float eatAnimationTimer = 0.0f;
    private int feedCooldown = 0;
    public float opacity = 1.0f;
    float desiredTemp = 1.0f;
    boolean mountSneaking = false;
    int mountSneakCount = 0;
    int lastMountSneak = 0;

    public Chameleon(EntityType<Chameleon> type, Level Level2) {
        super(type, Level2);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.6));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new EatObjectsGoal(this, ModEntityTags.CHAMELEON_EATS));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43938_(ChameleonEdibles.EDIBLES.stream().map(edible -> new Ingredient.TagValue(edible.associatedItems())).filter(ing -> ing.m_6223_().stream().noneMatch(ItemStack::m_41619_))), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new LazyLookGoal((Mob)this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TamableAnimal.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.16).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHED_TIME, (Object)0);
        this.f_19804_.m_135372_(LAST_SHED, (Object)0);
        this.f_19804_.m_135372_(HURT_TIMESTAMP, (Object)0);
        this.f_19804_.m_135372_(TRUSTED_PLAYERS, (Object)new CompoundTag());
        this.f_19804_.m_135372_(TRACKING_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(EAT_TIMESTAMP, (Object)0);
        this.f_19804_.m_135372_(TEMPERATURE, (Object)Float.valueOf((float)CSMath.average(ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get())));
        this.f_19804_.m_135372_(EDIBLE_COOLDOWNS, (Object)new CompoundTag());
        this.f_19804_.m_135372_(SEARCHING, (Object)false);
        this.f_19804_.m_135372_(AGE_SECS, (Object)0);
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        Entity entity = this.m_20202_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (source.equals(DamageSource.f_19310_) || source.equals(DamageSource.f_19315_)) {
                return true;
            }
            return player.m_7500_() || player.m_6673_(source);
        }
        return super.m_6673_(source);
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (this.f_20890_) {
            this.m_21231_().m_19289_(source, this.m_21223_(), 1.0f);
            Component deathMessage = this.m_21231_().m_19293_();
            ListTag trustedPlayers = this.getTrustedPlayers().m_128437_("Players", 8);
            if (!this.f_19853_.f_46443_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46142_)) {
                trustedPlayers.forEach(string -> {
                    Player player = this.f_19853_.m_46003_(UUID.fromString(string.m_7916_()));
                    if (player != null) {
                        player.m_6352_(deathMessage, Util.f_137441_);
                    }
                });
            }
        }
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (!ConfigSettings.CHAMELEON_SHED_AUTOMATICALLY.get().booleanValue() && Chameleon.makeShed((LivingEntity)this)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        Edible edible = ChameleonEdibles.getEdible(stack).orElse(null);
        if (edible != null) {
            if (this.feedCooldown <= 0 && this.isPlayerTrusted(player) ^ this.isTamingItem(stack) && this.getCooldown(edible) <= 0 || this.m_5957_() && this.m_6898_(stack)) {
                if (!player.f_19853_.f_46443_) {
                    ItemStack dropStack = stack.m_41777_();
                    dropStack.m_41764_(1);
                    ItemEntity dropped = player.m_36176_(dropStack, true);
                    if (dropped != null) {
                        dropped.getPersistentData().m_128362_("Recipient", this.m_142081_());
                    }
                    player.m_5810_();
                    this.m_142075_(player, hand, stack);
                }
                this.feedCooldown = 10;
                return InteractionResult.SUCCESS;
            }
            player.m_6674_(hand);
            return InteractionResult.CONSUME;
        }
        if (this.isPlayerTrusted(player) && player.m_20197_().isEmpty() && !this.f_19853_.f_46443_) {
            if (this.m_20329_((Entity)player) && player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new EntityMountMessage(this.m_142049_(), player.m_142049_(), EntityMountMessage.Action.MOUNT));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static boolean makeShed(LivingEntity entity) {
        Chameleon chameleon;
        if (entity instanceof Chameleon && (chameleon = (Chameleon)entity).isShedding() && chameleon.canShed()) {
            chameleon.shedItems();
            chameleon.setLastShed(chameleon.getAgeTicks());
            chameleon.setShedTime(-1);
            return true;
        }
        return false;
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_204117_(ModItemTags.CHAMELEON_TAMING);
    }

    public boolean m_5957_() {
        return super.m_5957_() && !this.m_6162_() && !this.m_27593_() && !this.getPersistentData().m_128471_("HasBred");
    }

    protected void m_142669_() {
        super.m_142669_();
        if (!this.m_6162_()) {
            this.shedItems();
        }
    }

    private void shedItems() {
        for (ItemStack stack : ModLootTables.getEntityDropsLootTable((Entity)this, null, ModLootTables.CHAMELEON_SHEDDING)) {
            WorldHelper.entityDropItem((Entity)this, stack, 40000);
        }
        WorldHelper.playEntitySound(ModSounds.CHAMELEON_SHED, (Entity)this, this.m_5720_(), 1.0f, this.m_6100_());
    }

    protected float m_6431_(Pose pPose, EntityDimensions pDimensions) {
        return this.m_6162_() ? 0.25f : 0.3f;
    }

    @SubscribeEvent
    public static void setHeight(EntityEvent.Size event) {
        Chameleon chameleon;
        Entity entity;
        if (event.getEntity().isAddedToWorld() && (entity = event.getEntity()) instanceof Chameleon && (chameleon = (Chameleon)entity).m_6162_()) {
            event.setNewSize(EntityDimensions.m_20398_((float)0.65f, (float)0.5f));
        }
    }

    @SubscribeEvent
    public static void onHitFromOwner(LivingHurtEvent event) {
        Chameleon chameleon;
        Entity entity = event.getEntity();
        if (entity instanceof Chameleon && (chameleon = (Chameleon)entity).m_20202_() != null && chameleon.m_20202_() == event.getSource().m_7639_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void cancelProjectileHit(ProjectileImpactEvent event) {
        Chameleon chameleon;
        HitResult hitResult = event.getRayTraceResult();
        if (!(hitResult instanceof EntityHitResult)) {
            return;
        }
        EntityHitResult hitResult2 = (EntityHitResult)hitResult;
        Entity entity = hitResult2.m_82443_();
        if (entity instanceof Chameleon && (chameleon = (Chameleon)entity).m_20202_() instanceof Player) {
            event.setCanceled(true);
            chameleon.setHurtTimestamp(chameleon.f_19797_ - 20);
        }
    }

    public int getTimeToShed() {
        return 600;
    }

    public int getEatAnimLength() {
        return 6;
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob parent) {
        return (AgeableMob)((EntityType)EntityInit.CHAMELEON.get()).m_20615_((Level)level);
    }

    public void m_27563_(ServerLevel level, Animal mate) {
        super.m_27563_(level, mate);
        this.getPersistentData().m_128379_("HasBred", true);
        mate.getPersistentData().m_128379_("HasBred", true);
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return ModSounds.CHAMELEON_AMBIENT;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return ModSounds.CHAMELEON_HURT;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return ModSounds.CHAMELEON_DEATH;
    }

    public void m_8032_() {
        SoundEvent soundevent = this.m_7515_();
        if (!this.f_19853_.f_46443_ && soundevent != null && !this.isSearching()) {
            WorldHelper.playEntitySound(soundevent, (Entity)this, this.m_5720_(), this.m_6121_(), this.m_6100_());
        }
    }

    protected void m_6677_(@NotNull DamageSource damageSource) {
        SoundEvent soundevent = this.m_7975_(damageSource);
        if (soundevent != null) {
            WorldHelper.playEntitySound(soundevent, (Entity)this, this.m_5720_(), this.m_6121_(), this.m_6100_());
        }
    }

    public boolean isWalking() {
        return (double)new Vec2((float)this.m_20184_().f_82479_, (float)this.m_20184_().f_82481_).m_165907_() > 0.005;
    }

    public int m_21529_() {
        return 20;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.eatAnimationTimer > 0.0f) {
            this.eatAnimationTimer -= 1.0f;
        }
        if (this.feedCooldown > 0) {
            --this.feedCooldown;
        }
        if (!this.f_19853_.f_46443_ && this.f_19797_ % 20 == 0) {
            this.setAgeSecs(this.getAgeSecs() + 1);
        }
        if (!this.f_19853_.f_46443_) {
            int shedCheckInterval = ConfigSettings.SHED_TIMINGS.get().interval();
            int shedCooldown = ConfigSettings.SHED_TIMINGS.get().cooldown();
            double shedChance = ConfigSettings.SHED_TIMINGS.get().chance();
            int shedTime = this.getShedTime();
            if (this.f_19797_ % shedCheckInterval == 0 && shedTime < 0 && this.f_19796_.nextDouble() < shedChance && this.getAgeTicks() - this.getLastShed() > shedCooldown) {
                this.setShedTime(0);
            }
            if (shedTime > -1 && shedTime < this.getTimeToShed()) {
                this.setShedTime(shedTime + 1);
            }
            if (ConfigSettings.CHAMELEON_SHED_AUTOMATICALLY.get().booleanValue() && this.canShed()) {
                Chameleon.makeShed((LivingEntity)this);
            }
        } else if (this.f_19796_.nextDouble() < 0.2 && this.canShed()) {
            WorldHelper.spawnParticle(this.f_19853_, (ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, ModItems.CHAMELEON_MOLT.m_7968_()), this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), this.m_20186_() + this.f_19796_.nextDouble() * (double)this.m_20206_(), this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), 0.01, 0.05, 0.01);
        }
        Entity shedCooldown = this.m_20202_();
        if (shedCooldown instanceof Player) {
            Player player = (Player)shedCooldown;
            float playerHeadYaw = player.f_20885_;
            this.f_20885_ = CSMath.clamp(this.f_20885_, playerHeadYaw - 50.0f, playerHeadYaw + 50.0f);
            this.f_20883_ = playerHeadYaw;
        }
        if (this.f_19797_ % 20 == 0 || this.f_19797_ == 1) {
            this.desiredTemp = (float)CSMath.clamp(Temperature.get((LivingEntity)this, Temperature.Trait.WORLD), ConfigSettings.MIN_TEMP.get(), ConfigSettings.MAX_TEMP.get());
        }
        this.setTemperature(this.getTemperature() + (this.desiredTemp - this.getTemperature()) * 0.03f);
        Entity playerHeadYaw = this.m_20202_();
        if (playerHeadYaw instanceof Player) {
            Player player = (Player)playerHeadYaw;
            if (!this.f_19853_.f_46443_) {
                if (player.m_6047_()) {
                    if (!this.mountSneaking) {
                        this.mountSneakCount = player.f_19797_ - this.lastMountSneak < 8 || this.mountSneakCount == 0 ? ++this.mountSneakCount : 0;
                        this.lastMountSneak = player.f_19797_;
                        this.mountSneaking = true;
                        if (this.mountSneakCount >= 2) {
                            this.m_8127_();
                            if (player instanceof ServerPlayer) {
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new EntityMountMessage(this.m_142049_(), player.m_142049_(), EntityMountMessage.Action.DISMOUNT));
                            }
                            this.f_19851_ = 10;
                            this.mountSneakCount = 0;
                        }
                    }
                } else {
                    this.mountSneaking = false;
                }
            }
        }
        if (this.f_19797_ % 5 == 0 && this.isTracking()) {
            if (this.f_19796_.nextDouble() < 0.3) {
                WorldHelper.spawnParticle(this.f_19853_, (ParticleOptions)ParticleTypes.f_123748_, this.m_20185_() + Math.random() - 0.5, this.m_20186_() + Math.random() - 0.5 + (double)(this.m_20206_() / 2.0f), this.m_20189_() + Math.random() - 0.5, 0.01, 0.01, 0.01);
            }
            if (this.f_19797_ % 20 == 0) {
                if ((long)this.getAgeTicks() - this.getEatTimestamp() > 6000L) {
                    this.clearTrackingPos();
                }
                if ((Math.sqrt(Math.pow(this.m_20185_() - (double)this.getTrackingPos().m_123341_(), 2.0) + Math.pow(this.m_20189_() - (double)this.getTrackingPos().m_123343_(), 2.0)) < 20.0 || this.getTrackingPos().equals((Object)BlockPos.f_121853_)) && this.m_20194_() != null) {
                    Advancement advancement = this.m_20194_().m_129889_().m_136041_(new ResourceLocation("cold_sweat", "chameleon_find_biome"));
                    for (ServerPlayer player : this.f_19853_.m_45976_(ServerPlayer.class, this.m_142469_().m_82400_(20.0))) {
                        if (advancement == null || player.m_8960_().m_135996_(advancement).m_8193_()) continue;
                        player.m_8960_().m_135988_(advancement, "requirement");
                    }
                    this.clearTrackingPos();
                }
            }
        }
        if (this.m_27593_() && this.f_19796_.nextDouble() < 0.8 && this.f_19797_ % 8 == 0) {
            WorldHelper.spawnParticleBatch(this.f_19853_, (ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), (double)this.m_20205_() / 1.5, (double)this.m_20206_() / 1.5, (double)this.m_20205_() / 1.5, 1.0, 0.0);
        }
        if (!this.f_19853_.f_46443_) {
            CompoundTag cooldowns = this.getCooldowns();
            for (String tag : cooldowns.m_128431_()) {
                int time = cooldowns.m_128451_(tag);
                if (time <= 0) continue;
                cooldowns.m_128405_(tag, time - 1);
            }
            this.f_19804_.m_135381_(EDIBLE_COOLDOWNS, (Object)cooldowns);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null && !this.m_6673_(source)) {
            this.setHurtTimestamp(this.f_19797_);
        }
        return super.m_6469_(source, amount);
    }

    @Nullable
    public Entity changeDimension(ServerLevel p_20118_, ITeleporter teleporter) {
        this.clearTrackingPos();
        return super.changeDimension(p_20118_, teleporter);
    }

    public void onEatEntity(Entity entity) {
        if (!this.f_19853_.f_46443_) {
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                ItemStack item = itemEntity.m_32055_();
                if (this.isTamingItem(item)) {
                    Player player;
                    Player player2 = player = itemEntity.m_32057_() != null ? this.f_19853_.m_46003_(itemEntity.m_32057_()) : null;
                    if (player != null) {
                        if (!this.isPlayerTrusted(player)) {
                            if (player.m_7500_() || Math.random() < 0.3) {
                                this.m_21530_();
                                this.addTrustedPlayer(itemEntity.m_32057_());
                                WorldHelper.spawnParticleBatch(this.f_19853_, (ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1.0, 1.0, 1.0, 6.0, 0.01);
                            } else {
                                WorldHelper.spawnParticleBatch(this.f_19853_, (ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), 1.0, 1.0, 1.0, 6.0, 0.01);
                            }
                        } else if (this.m_5957_()) {
                            this.m_27595_(player);
                        }
                    }
                }
                ChameleonEdibles.getEdible(item).ifPresent(edible -> {
                    if (edible.onEaten(this, itemEntity) == Edible.Result.SUCCESS) {
                        this.setCooldown((Edible)edible, edible.getCooldown());
                    } else {
                        this.setCooldown((Edible)edible, edible.getCooldown() / 4);
                    }
                });
            }
            this.setEatTimestamp(this.getAgeTicks());
        }
    }

    public double m_6049_() {
        Player player;
        Entity entity = this.m_20202_();
        return entity instanceof Player ? ((player = (Player)entity).m_6844_(EquipmentSlot.HEAD).m_150930_(ModItems.HOGLIN_HELMET) ? 0.65 : 0.5) : 0.0;
    }

    public int m_8085_() {
        return 60;
    }

    public void eatAnimation() {
        if (this.eatAnimationTimer <= 0.0f) {
            if (!this.f_19853_.f_46443_) {
                ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> this), (Object)new ChameleonEatMessage(this.m_142049_()));
            } else {
                AnimationManager.ANIMATION_TIMERS.put((Entity)this, Float.valueOf(0.0f));
            }
            this.eatAnimationTimer = this.getEatAnimLength();
        }
    }

    public void manualSync(EntityDataAccessor<?> accessor) {
        try {
            ((SynchedEntityData.DataItem)GET_DATA_ITEM.invoke((Object)this.f_19804_, accessor)).m_135401_(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public float getEatTimer() {
        return this.eatAnimationTimer;
    }

    public int getShedTime() {
        return (Integer)this.f_19804_.m_135370_(SHED_TIME);
    }

    public void setShedTime(int shedTime) {
        this.f_19804_.m_135381_(SHED_TIME, (Object)shedTime);
    }

    public boolean isShedding() {
        return this.getShedTime() >= 0;
    }

    public boolean canShed() {
        return this.getShedTime() >= this.getTimeToShed();
    }

    public CompoundTag getTrustedPlayers() {
        return (CompoundTag)this.f_19804_.m_135370_(TRUSTED_PLAYERS);
    }

    public void addTrustedPlayer(UUID player) {
        StringTag uuid;
        CompoundTag trustedPlayers = this.getTrustedPlayers();
        ListTag players = trustedPlayers.m_128437_("Players", 8);
        if (!players.contains((Object)(uuid = StringTag.m_129297_((String)player.toString())))) {
            players.add((Object)uuid);
        }
        trustedPlayers.m_128365_("Players", (Tag)players);
        this.f_19804_.m_135381_(TRUSTED_PLAYERS, (Object)trustedPlayers);
        this.manualSync(TRUSTED_PLAYERS);
    }

    public void removeTrustedPlayer(UUID player) {
        CompoundTag trustedPlayers = this.getTrustedPlayers();
        trustedPlayers.m_128437_("Players", 8).removeIf(tag -> tag.m_7916_().equals(player.toString()));
        this.f_19804_.m_135381_(TRUSTED_PLAYERS, (Object)trustedPlayers);
    }

    public boolean isPlayerTrusted(Player player) {
        return this.isPlayerTrusted(player.m_142081_());
    }

    public boolean isPlayerTrusted(UUID player) {
        return this.getTrustedPlayers().m_128437_("Players", 8).contains((Object)StringTag.m_129297_((String)player.toString()));
    }

    public int getLastShed() {
        return (Integer)this.f_19804_.m_135370_(LAST_SHED);
    }

    public void setLastShed(int lastShed) {
        this.f_19804_.m_135381_(LAST_SHED, (Object)lastShed);
    }

    public float getTemperature() {
        return ((Float)this.f_19804_.m_135370_(TEMPERATURE)).floatValue();
    }

    public void setTemperature(float temperature) {
        this.f_19804_.m_135381_(TEMPERATURE, (Object)Float.valueOf(temperature));
    }

    public void setSearching(boolean searching) {
        this.f_19804_.m_135381_(SEARCHING, (Object)searching);
    }

    public boolean isSearching() {
        return (Boolean)this.f_19804_.m_135370_(SEARCHING);
    }

    public int getHurtTimestamp() {
        return (Integer)this.f_19804_.m_135370_(HURT_TIMESTAMP);
    }

    public void setHurtTimestamp(int hurtTimestamp) {
        this.f_19804_.m_135381_(HURT_TIMESTAMP, (Object)hurtTimestamp);
    }

    public void setTrackingPos(BlockPos pos) {
        this.f_19804_.m_135381_(TRACKING_POS, (Object)pos);
    }

    public void clearTrackingPos() {
        this.f_19804_.m_135381_(TRACKING_POS, (Object)BlockPos.f_121853_);
    }

    public BlockPos getTrackingPos() {
        return (BlockPos)this.f_19804_.m_135370_(TRACKING_POS);
    }

    public boolean isTracking() {
        return !((BlockPos)this.f_19804_.m_135370_(TRACKING_POS)).equals((Object)BlockPos.f_121853_);
    }

    public long getEatTimestamp() {
        return ((Integer)this.f_19804_.m_135370_(EAT_TIMESTAMP)).intValue();
    }

    public void setEatTimestamp(int eatTimestamp) {
        this.f_19804_.m_135381_(EAT_TIMESTAMP, (Object)eatTimestamp);
    }

    public void setCooldown(Edible edible, Integer time) {
        CompoundTag map = (CompoundTag)this.f_19804_.m_135370_(EDIBLE_COOLDOWNS);
        map.m_128405_(edible.associatedItems().f_203868_().toString(), time.intValue());
        this.f_19804_.m_135381_(EDIBLE_COOLDOWNS, (Object)map);
    }

    public Integer getCooldown(Edible edible) {
        return ((CompoundTag)this.f_19804_.m_135370_(EDIBLE_COOLDOWNS)).m_128451_(edible.getName());
    }

    public CompoundTag getCooldowns() {
        return (CompoundTag)this.f_19804_.m_135370_(EDIBLE_COOLDOWNS);
    }

    public int getAgeSecs() {
        return (Integer)this.f_19804_.m_135370_(AGE_SECS);
    }

    public int getAgeTicks() {
        return this.getAgeSecs() * 20;
    }

    public void setAgeSecs(int ageSecs) {
        this.f_19804_.m_135381_(AGE_SECS, (Object)ageSecs);
    }

    public boolean isTamingItem(ItemStack item) {
        return item.m_204117_(ModItemTags.CHAMELEON_TAMING);
    }

    public CompoundTag m_20240_(CompoundTag tag) {
        super.m_20240_(tag);
        tag.m_128365_("TrustedPlayers", Objects.requireNonNullElseGet(this.getTrustedPlayers().m_128423_("Players"), ListTag::new));
        tag.m_128405_("LastShed", this.getLastShed());
        tag.m_128405_("ShedTime", this.getShedTime());
        tag.m_128405_("HurtTimestamp", this.getHurtTimestamp());
        tag.m_128405_("AgeInSeconds", this.getAgeSecs());
        tag.m_128356_("EatTimestamp", this.getEatTimestamp());
        if (this.isTracking()) {
            tag.m_128356_("TrackingPos", this.getTrackingPos().m_121878_());
        } else {
            tag.m_128473_("TrackingPos");
        }
        ListTag edibleCooldowns = new ListTag();
        for (String key : this.getCooldowns().m_128431_()) {
            CompoundTag cooldownTag = new CompoundTag();
            cooldownTag.m_128359_("Edible", key);
            cooldownTag.m_128405_("Cooldown", this.getCooldowns().m_128451_(key));
            edibleCooldowns.add((Object)cooldownTag);
        }
        tag.m_128365_("EdibleCooldowns", (Tag)edibleCooldowns);
        tag.m_128350_("Temperature", this.getTemperature());
        return tag;
    }

    public void m_20258_(CompoundTag nbt) {
        super.m_20258_(nbt);
        CompoundTag players = new CompoundTag();
        players.m_128365_("Players", Objects.requireNonNullElseGet(nbt.m_128423_("TrustedPlayers"), ListTag::new));
        this.f_19804_.m_135381_(TRUSTED_PLAYERS, (Object)players);
        this.setLastShed(nbt.m_128451_("LastShed"));
        this.setShedTime(nbt.m_128451_("ShedTime"));
        this.setHurtTimestamp(nbt.m_128451_("HurtTimestamp"));
        this.setAgeSecs(nbt.m_128451_("AgeInSeconds"));
        this.setEatTimestamp(nbt.m_128451_("EatTimestamp"));
        if (nbt.m_128441_("TrackingPos")) {
            this.setTrackingPos(BlockPos.m_122022_((long)nbt.m_128454_("TrackingPos")));
        }
        ListTag edibleCooldowns = nbt.m_128437_("EdibleCooldowns", 10);
        for (int i = 0; i < edibleCooldowns.size(); ++i) {
            CompoundTag cooldownTag = edibleCooldowns.m_128728_(i);
            ChameleonEdibles.EDIBLES.stream().filter(ed -> ed.getName().equals(cooldownTag.m_128461_("Item"))).findFirst().ifPresent(edible -> this.setCooldown((Edible)edible, cooldownTag.m_128451_("Cooldown")));
        }
        this.setTemperature(nbt.m_128457_("Temperature"));
        this.desiredTemp = this.getTemperature();
    }

    static {
        GET_DATA_ITEM.setAccessible(true);
        SHED_TIME = SynchedEntityData.m_135353_(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        LAST_SHED = SynchedEntityData.m_135353_(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        HURT_TIMESTAMP = SynchedEntityData.m_135353_(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        TRUSTED_PLAYERS = SynchedEntityData.m_135353_(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
        TRACKING_POS = SynchedEntityData.m_135353_(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
        EAT_TIMESTAMP = SynchedEntityData.m_135353_(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        TEMPERATURE = SynchedEntityData.m_135353_(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
        EDIBLE_COOLDOWNS = SynchedEntityData.m_135353_(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
        SEARCHING = SynchedEntityData.m_135353_(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        AGE_SECS = SynchedEntityData.m_135353_(Chameleon.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }
}

