/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.loot.ModLootTables;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class IceBreakingEvents {
    @SubscribeEvent
    public static void onIceBreak(BlockEvent.BreakEvent event) {
        if (!ConfigSettings.USE_CUSTOM_ICE_DROPS.get().booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
        BlockState state = event.getState();
        LevelAccessor ilevel = event.getWorld();
        BlockPos pos = event.getPos();
        Material belowMaterial = ilevel.m_8055_(pos.m_7495_()).m_60767_();
        if (state.m_60713_(Blocks.f_50126_) && !ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player) && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)stack) == 0 && !player.m_150110_().f_35937_ && (belowMaterial.m_76334_() || belowMaterial.m_76332_()) && !ilevel.m_6042_().m_63951_()) {
            ilevel.m_7731_(pos, Blocks.f_49990_.m_49966_(), 3);
        }
    }

    @SubscribeEvent
    public static void onIceMining(PlayerEvent.BreakSpeed event) {
        if (!ConfigSettings.USE_CUSTOM_ICE_DROPS.get().booleanValue()) {
            return;
        }
        BlockState state = event.getState();
        Player player = event.getPlayer();
        ItemStack tool = player.m_21205_();
        float speed = event.getNewSpeed();
        if (IceBreakingEvents.isModifiableIceBlock(state) && !ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player)) {
            if (tool.canPerformAction(ToolActions.PICKAXE_DIG)) {
                event.setNewSpeed(speed * 2.0f);
            } else {
                event.setNewSpeed(speed * 3.0f);
            }
        }
        if (state.m_60713_(Blocks.f_50354_)) {
            event.setNewSpeed(event.getNewSpeed() / 3.0f);
        }
    }

    @SubscribeEvent
    public static void iceHarvestCheck(PlayerEvent.HarvestCheck event) {
        if (!ConfigSettings.USE_CUSTOM_ICE_DROPS.get().booleanValue()) {
            return;
        }
        BlockState state = event.getTargetBlock();
        Player player = event.getPlayer();
        ItemStack tool = player.m_21120_(InteractionHand.MAIN_HAND);
        if (IceBreakingEvents.isModifiableIceBlock(state)) {
            event.setCanHarvest(tool.canPerformAction(ToolActions.PICKAXE_DIG) && event.getPlayer().m_21205_().m_41735_(state));
        }
    }

    public static boolean isModifiableIceBlock(BlockState state) {
        return state.m_60713_(Blocks.f_50126_) || state.m_60713_(Blocks.f_50354_) || state.m_60713_(Blocks.f_50568_);
    }

    public static ResourceLocation getLootTableForIce(BlockState state) {
        if (state.m_60713_(Blocks.f_50126_)) {
            return ModLootTables.CUSTOM_ICE_DROP;
        }
        if (state.m_60713_(Blocks.f_50354_)) {
            return ModLootTables.CUSTOM_PACKED_ICE_DROP;
        }
        if (state.m_60713_(Blocks.f_50568_)) {
            return ModLootTables.CUSTOM_BLUE_ICE_DROP;
        }
        return null;
    }
}

