/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.world.feature;

import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.common.block.SoulStalkBlock;
import com.momosoftworks.coldsweat.common.world.feature.SoulStalkFeatureConfig;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class SoulStalkFeature
extends Feature<SoulStalkFeatureConfig> {
    public SoulStalkFeature(Codec<SoulStalkFeatureConfig> config) {
        super(config);
    }

    public boolean isAirOrLeaves(WorldGenLevel level, BlockPos pos) {
        return level.m_8055_(pos).m_60795_() || level.m_8055_(pos).m_204336_(BlockTags.f_13035_);
    }

    public boolean m_142674_(FeaturePlaceContext<SoulStalkFeatureConfig> context) {
        SoulStalkFeatureConfig config = (SoulStalkFeatureConfig)context.m_159778_();
        WorldGenLevel level = context.m_159774_();
        BlockPos.MutableBlockPos pos = context.m_159777_().m_122032_();
        int successes = 0;
        for (int t = 0; t < config.tries(); ++t) {
            pos.m_122190_((Vec3i)context.m_159777_()).m_122184_(context.m_159776_().nextInt(config.spreadXZ()) - config.spreadXZ() / 2, context.m_159776_().nextInt(config.spreadY()) - config.spreadY() / 2, context.m_159776_().nextInt(config.spreadXZ()) - config.spreadXZ() / 2);
            int startY = pos.m_123342_();
            int minHeight = level.m_141937_();
            int maxHeight = level.m_151558_();
            for (int i = -10; i < 10; ++i) {
                pos.m_142448_(startY + i);
                if (pos.m_123342_() >= minHeight && (pos.m_123342_() > maxHeight || level.m_8055_((BlockPos)pos).m_60795_() && level.m_8055_(pos.m_7495_()).m_60838_((BlockGetter)level, pos.m_7495_()))) break;
            }
            if (!level.m_8055_(pos.m_7495_()).m_204336_(ModBlockTags.SOUL_STALK_PLACEABLE_ON)) {
                SoulStalkFeature.placeDisk(level, (BlockPos)pos, config);
            }
            if (!level.m_8055_(pos.m_7494_()).m_60795_()) continue;
            level.m_7731_((BlockPos)pos, (BlockState)ModBlocks.SOUL_STALK.m_49966_().m_61124_(SoulStalkBlock.SECTION, (Comparable)((Object)SoulStalkBlock.Section.BASE)), 2);
            int height = new Random().nextInt(5) + 2;
            for (int i = 0; i < height && this.isAirOrLeaves(level, pos.m_7494_()); ++i) {
                pos.m_122184_(0, 1, 0);
                level.m_7731_((BlockPos)pos, (BlockState)ModBlocks.SOUL_STALK.m_49966_().m_61124_(SoulStalkBlock.SECTION, (Comparable)((Object)SoulStalkBlock.getRandomMidsection())), 2);
            }
            level.m_7731_((BlockPos)pos, (BlockState)ModBlocks.SOUL_STALK.m_49966_().m_61124_(SoulStalkBlock.SECTION, (Comparable)((Object)SoulStalkBlock.Section.TOP)), 2);
            int minCount = config.minCount();
            int maxCount = config.maxCount();
            if (++successes >= maxCount || successes >= minCount && context.m_159776_().nextInt(0, maxCount - minCount) == 0) break;
        }
        return successes > 0;
    }

    private static void placeDisk(WorldGenLevel level, BlockPos pos, SoulStalkFeatureConfig config) {
        int diskWidth = config.diskWidth();
        int diskHeight = config.diskHeight();
        double diskDecay = config.diskDecay();
        BlockStateProvider diskProvider = config.diskStateProvider();
        BlockPredicate diskReplacer = config.replaceBlocks();
        if (diskWidth <= 0 || diskHeight <= 0 || diskProvider == null || diskReplacer == null) {
            return;
        }
        for (int x = -diskWidth; x <= diskWidth; ++x) {
            for (int y = -diskHeight; y <= diskHeight; ++y) {
                for (int z = -diskWidth; z <= diskWidth; ++z) {
                    if (!(Math.pow((double)x / (double)diskWidth, 2.0) + Math.pow((double)y / (double)diskHeight, 2.0) + Math.pow((double)z / (double)diskWidth, 2.0) < 1.0)) continue;
                    BlockPos diskPos = pos.m_142082_(x, y, z);
                    double distance = Math.sqrt(diskPos.m_123331_((Vec3i)pos));
                    double distFactor = CSMath.blend(level.m_5822_().nextDouble(), 0.0, distance, 0.0, (double)diskWidth);
                    if (!diskPos.equals((Object)pos.m_7495_()) && (!(diskDecay > 0.0) || !(distFactor > diskDecay)) || !diskReplacer.test((Object)level, (Object)diskPos)) continue;
                    level.m_7731_(diskPos, diskProvider.m_7112_(level.m_5822_(), diskPos), 2);
                }
            }
        }
    }
}

