/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.configuration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.data.codec.impl.ConfigData;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.OptionalHolder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

public class DimensionTempData
extends ConfigData
implements IForgeRegistryEntry<DimensionTempData> {
    final NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>> dimensions;
    final double temperature;
    final Temperature.Units units;
    final boolean isOffset;
    public static final Codec<DimensionTempData> CODEC = DimensionTempData.createCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)NegatableList.listCodec(ConfigHelper.tagOrHolderCodec(Registry.f_122818_)).fieldOf("dimensions").forGetter(DimensionTempData::dimensions), (App)Codec.DOUBLE.fieldOf("temperature").forGetter(DimensionTempData::temperature), (App)Temperature.Units.CODEC.optionalFieldOf("units", (Object)Temperature.Units.MC).forGetter(DimensionTempData::units), (App)Codec.BOOL.optionalFieldOf("is_offset", (Object)false).forGetter(DimensionTempData::isOffset)).apply((Applicative)instance, DimensionTempData::new)));

    public DimensionTempData(NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>> dimensions, double temperature, Temperature.Units units, boolean isOffset, NegatableList<String> requiredMods) {
        super(requiredMods);
        this.dimensions = dimensions;
        this.temperature = temperature;
        this.units = units;
        this.isOffset = isOffset;
    }

    public DimensionTempData(NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>> dimensions, double temperature, Temperature.Units units, boolean isOffset) {
        this(dimensions, temperature, units, isOffset, new NegatableList<String>());
    }

    public DimensionTempData(Holder<DimensionType> dimension, double temperature, Temperature.Units units, boolean isOffset) {
        this(new NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>>(Either.right(OptionalHolder.ofHolder(dimension))), temperature, units, isOffset);
    }

    public NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>> dimensions() {
        return this.dimensions;
    }

    public double temperature() {
        return this.temperature;
    }

    public Temperature.Units units() {
        return this.units;
    }

    public boolean isOffset() {
        return this.isOffset;
    }

    public double getTemperature() {
        return Temperature.convert(this.temperature, this.units, Temperature.Units.MC, !this.isOffset);
    }

    @Nullable
    public static DimensionTempData fromToml(List<?> entry, boolean isOffset, RegistryAccess registryAccess) {
        if (entry.size() < 2) {
            ColdSweat.LOGGER.error("Error parsing dimension config: not enough arguments");
            return null;
        }
        NegatableList<Either<TagKey<DimensionType>, OptionalHolder<DimensionType>>> dimensions = ConfigHelper.parseRegistryItems(Registry.f_122818_, registryAccess, (String)entry.get(0));
        if (dimensions.isEmpty()) {
            return null;
        }
        double temp = ((Number)entry.get(1)).doubleValue();
        Temperature.Units units = entry.size() == 3 ? Temperature.Units.valueOf(((String)entry.get(2)).toUpperCase()) : Temperature.Units.MC;
        return new DimensionTempData(dimensions, temp, units, isOffset);
    }

    public Codec<DimensionTempData> getCodec() {
        return CODEC;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DimensionTempData that = (DimensionTempData)obj;
        return super.equals(obj) && Double.compare(that.temperature, this.temperature) == 0 && this.isOffset == that.isOffset && this.dimensions.equals(that.dimensions) && this.units == that.units;
    }

    public DimensionTempData setRegistryName(ResourceLocation name) {
        return null;
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return null;
    }

    public Class<DimensionTempData> getRegistryType() {
        return null;
    }
}

