/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.EnchantmentRequirement;
import com.momosoftworks.coldsweat.data.codec.requirement.NbtRequirement;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Registry;
import net.minecraft.nbt.ListTag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public record ItemRequirement(NegatableList<Either<TagKey<Item>, Item>> items, IntegerBounds count, IntegerBounds durability, NegatableList<EnchantmentRequirement> enchantments, Optional<Potion> potion, NbtRequirement nbt, Optional<Predicate<ItemStack>> predicate) {
    public static final Item WILDCARD_ITEM = null;
    private static final Codec<Either<TagKey<Item>, Item>> ITEM_CODEC = Codec.either(ConfigHelper.tagOrBuiltinCodec(Registry.f_122904_, ForgeRegistries.ITEMS), (Codec)Codec.STRING).xmap(itemOrString -> {
        if (itemOrString.left().isPresent()) {
            return (Either)itemOrString.left().get();
        }
        String itemName = (String)itemOrString.right().get();
        if (itemName.equals("*")) {
            return Either.right((Object)WILDCARD_ITEM);
        }
        throw new IllegalArgumentException("Could not find item: " + itemName);
    }, tagOrItem -> (Either)tagOrItem.map(left -> Either.left((Object)Either.left((Object)left)), right -> right == WILDCARD_ITEM ? Either.right((Object)"*") : Either.left((Object)Either.right((Object)right))));
    public static final Codec<ItemRequirement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)NegatableList.listCodec(ITEM_CODEC).fieldOf("items").forGetter(predicate -> predicate.items), (App)IntegerBounds.CODEC.optionalFieldOf("count", (Object)IntegerBounds.NONE).forGetter(predicate -> predicate.count), (App)IntegerBounds.CODEC.optionalFieldOf("durability", (Object)IntegerBounds.NONE).forGetter(predicate -> predicate.durability), (App)NegatableList.listCodec(EnchantmentRequirement.CODEC).optionalFieldOf("enchantments", new NegatableList()).forGetter(predicate -> predicate.enchantments), (App)ForgeRegistries.POTIONS.getCodec().optionalFieldOf("potion").forGetter(predicate -> predicate.potion), (App)NbtRequirement.CODEC.optionalFieldOf("nbt", (Object)new NbtRequirement()).forGetter(predicate -> predicate.nbt)).apply((Applicative)instance, ItemRequirement::new));
    public static final ItemRequirement NONE = new ItemRequirement(new NegatableList<Either<TagKey<Item>, Item>>(), IntegerBounds.NONE, IntegerBounds.NONE, new NegatableList<EnchantmentRequirement>(), Optional.empty(), new NbtRequirement());

    public ItemRequirement(NegatableList<Either<TagKey<Item>, Item>> items, IntegerBounds count, IntegerBounds durability, NegatableList<EnchantmentRequirement> enchantments, Optional<Potion> potion, NbtRequirement nbt) {
        this(items, count, durability, enchantments, potion, nbt, Optional.empty());
    }

    public ItemRequirement(NegatableList<Either<TagKey<Item>, Item>> items, NbtRequirement nbt) {
        this(items, IntegerBounds.NONE, IntegerBounds.NONE, new NegatableList<EnchantmentRequirement>(), Optional.empty(), nbt);
    }

    public ItemRequirement(Collection<Item> items, @Nullable Predicate<ItemStack> predicate) {
        this(new NegatableList<Either<TagKey<Item>, Item>>(items.stream().map(Either::right).toList()), IntegerBounds.NONE, IntegerBounds.NONE, new NegatableList<EnchantmentRequirement>(), Optional.empty(), new NbtRequirement(), Optional.ofNullable(predicate));
    }

    public ItemRequirement(Predicate<ItemStack> predicate) {
        this(new NegatableList<Either<TagKey<Item>, Item>>(), IntegerBounds.NONE, IntegerBounds.NONE, new NegatableList<EnchantmentRequirement>(), Optional.empty(), new NbtRequirement(), Optional.of(predicate));
    }

    public boolean test(ItemStack stack, boolean ignoreCount) {
        if (stack.m_41619_() && !this.items.isEmpty()) {
            return false;
        }
        if (!this.items.test(either -> (Boolean)either.map(arg_0 -> ((ItemStack)stack).m_204117_(arg_0), right -> right == WILDCARD_ITEM || stack.m_150930_(right)))) {
            return false;
        }
        if (this.predicate.isPresent()) {
            return this.predicate.get().test(stack);
        }
        if (!this.nbt.test(stack.m_41783_())) {
            return false;
        }
        if (!ignoreCount && !this.count.test(stack.m_41613_())) {
            return false;
        }
        if (!this.durability.test(stack.m_41776_() - stack.m_41773_())) {
            return false;
        }
        if (this.potion.isPresent() && !this.potion.get().m_43488_().equals(PotionUtils.m_43579_((ItemStack)stack).m_43488_())) {
            return false;
        }
        if (!this.nbt.test(stack.m_41783_())) {
            return false;
        }
        if (!this.enchantments.isEmpty()) {
            Map stackEnchantments = EnchantmentHelper.m_44882_((ListTag)stack.m_41785_());
            stackEnchantments.putAll(EnchantmentHelper.m_44882_((ListTag)EnchantedBookItem.m_41163_((ItemStack)stack)));
            if (!this.enchantments.test(enchantment -> enchantment.test(stackEnchantments))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this).result().map(Object::toString).orElse("serialize_failed");
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ItemRequirement that = (ItemRequirement)obj;
        return this.items.equals(that.items) && this.count.equals(that.count) && this.durability.equals(that.durability) && this.enchantments.equals(that.enchantments) && this.potion.equals(that.potion) && this.nbt.equals(that.nbt) && this.predicate.equals(that.predicate);
    }
}

