/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.loot_modifier;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AddDropsModifier
extends LootModifier {
    private final Item addition;
    private final Pair<Integer, Integer> count;

    protected AddDropsModifier(LootItemCondition[] conditionsIn, Item addition, Pair<Integer, Integer> count) {
        super(conditionsIn);
        this.addition = addition;
        this.count = count;
    }

    @NotNull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        int countMin = (Integer)this.count.getFirst();
        int countMax = (Integer)this.count.getSecond();
        int countRange = countMax - countMin + 1;
        generatedLoot.add(new ItemStack((ItemLike)this.addition, context.m_78933_().nextInt(countMin, countMax + 1) + context.m_78933_().nextInt(countRange * context.getLootingModifier() + 1)));
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddDropsModifier> {
        public AddDropsModifier read(@Nonnull ResourceLocation location, JsonObject object, LootItemCondition[] conditionsIn) {
            JsonObject countTable = GsonHelper.m_13930_((JsonObject)object, (String)"count");
            return new AddDropsModifier(conditionsIn, (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"addition"))), (Pair<Integer, Integer>)Pair.of((Object)GsonHelper.m_13927_((JsonObject)countTable, (String)"min"), (Object)GsonHelper.m_13927_((JsonObject)countTable, (String)"max")));
        }

        public JsonObject write(AddDropsModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("addition", instance.addition.getRegistryName().toString());
            return json;
        }
    }
}

