/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.TempEffectInit;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.level.GameRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FoodData.class})
public class MixinLimitFoodRegen {
    private static Player STORED_PLAYER;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void storePlayer(Player player, CallbackInfo ci) {
        STORED_PLAYER = player;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/GameRules;getBoolean(Lnet/minecraft/world/level/GameRules$Key;)Z"))
    private boolean limitRegenIfFreezing(GameRules gameRules, GameRules.Key<GameRules.BooleanValue> key) {
        Map tempEffects;
        TempEffect freezeHealingEffect;
        if (key == GameRules.f_46139_ && (freezeHealingEffect = (TempEffect)(tempEffects = (Map)EntityTempManager.getTemperatureCap((Entity)STORED_PLAYER).map(ITemperatureCap::getTempEffects).orElse(new HashMap())).get(TempEffectInit.FREEZE_HEALING.get())) != null) {
            double effect = freezeHealingEffect.getEffectFactor();
            double heartsFreezePercentage = ConfigSettings.HEARTS_FREEZING_PERCENTAGE.get();
            if (heartsFreezePercentage != 0.0) {
                float maxHealth = STORED_PLAYER.m_21233_();
                float maxFrozenHealth = (float)((double)maxHealth * heartsFreezePercentage);
                float frozenHealth = Math.round(CSMath.blend(0.0, (double)maxFrozenHealth, effect, 0.0, 1.0));
                float unfrozenHealth = maxHealth - frozenHealth;
                if (STORED_PLAYER.m_21223_() >= unfrozenHealth) {
                    return false;
                }
            }
        }
        return gameRules.m_46207_(key);
    }
}

