/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.mixin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.data.codec.util.NegatableList;
import com.momosoftworks.coldsweat.mixin_public.PublicMixinRegistration;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={RegistryOps.class})
public class MixinRegistration {
    @Inject(method={"createAndLoad(Lcom/mojang/serialization/DynamicOps;Lnet/minecraft/core/RegistryAccess$Writable;Lnet/minecraft/server/packs/resources/ResourceManager;)Lnet/minecraft/resources/RegistryOps;"}, at={@At(value="HEAD")})
    private static <T> void captureResourceManager(DynamicOps<T> ops, RegistryAccess.Writable registryAccess, ResourceManager resourceManager, CallbackInfoReturnable<RegistryOps<T>> cir) {
        PublicMixinRegistration.RESOURCE_MANAGER = resourceManager;
    }

    @Mixin(targets={"net.minecraft.resources.RegistryResourceAccess$1"})
    public static final class Inner {
        @Inject(method={"listResources"}, at={@At(value="RETURN")}, cancellable=true)
        private <E> void listResources(ResourceKey<? extends Registry<E>> registryKey, CallbackInfoReturnable<Collection<ResourceKey<E>>> cir) {
            if (registryKey.m_135782_().m_135827_().equals("cold_sweat")) {
                Collection map = (Collection)cir.getReturnValue();
                map.removeIf(entry -> {
                    ResourceLocation location = entry.m_135782_();
                    String absoluteLocation = String.format("%s/%s/%s.json", "cold_sweat", registryKey.m_135782_().m_135815_(), location.m_135815_());
                    try (Resource resource = PublicMixinRegistration.RESOURCE_MANAGER.m_142591_(new ResourceLocation(registryKey.m_135782_().m_135827_(), absoluteLocation));
                         InputStreamReader reader = new InputStreamReader(resource.m_6679_(), StandardCharsets.UTF_8);){
                        JsonObject json = GsonHelper.m_13859_((Reader)reader);
                        if (!json.has("required_mods")) return false;
                        JsonElement requiredModsField = json.get("required_mods");
                        NegatableList<String> requiredMods = NegatableList.listCodec(Codec.STRING).parse((DynamicOps)JsonOps.INSTANCE, (Object)requiredModsField).result().orElse(new NegatableList());
                        if (requiredMods.test(CompatManager::modLoaded)) return false;
                        ColdSweat.LOGGER.info("Skipping registration of {} {}: required mods not met", (Object)registryKey.m_135782_(), (Object)location);
                        boolean bl = true;
                        return bl;
                    }
                    catch (Exception e) {
                        return false;
                    }
                });
                cir.setReturnValue((Object)map);
            }
        }
    }
}

