/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.registry;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.temperature.block_temp.ConfiguredBlockTemp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BlockTempRegistry {
    public static final List<BlockTemp> BLOCK_TEMPS = new ArrayList<BlockTemp>();
    public static final Multimap<Block, BlockTemp> MAPPED_BLOCKS = MultimapBuilder.hashKeys().linkedHashSetValues().build();
    public static final BlockTemp DEFAULT_BLOCK_TEMP = new BlockTemp(new Block[0]){

        @Override
        public double getTemperature(Level level, LivingEntity entity, BlockState state, BlockPos pos, double distance) {
            return 0.0;
        }
    };

    public static synchronized void register(BlockTemp blockTemp) {
        BlockTempRegistry.register(blockTemp, false);
    }

    public static synchronized void registerFirst(BlockTemp blockTemp) {
        BlockTempRegistry.register(blockTemp, true);
    }

    private static synchronized void register(BlockTemp blockTemp, boolean front) {
        blockTemp.getAffectedBlocks().forEach(block -> {
            Collection blockTemps = MAPPED_BLOCKS.get(block);
            if (!blockTemps.isEmpty() && blockTemp instanceof ConfiguredBlockTemp) {
                ConfiguredBlockTemp cfg = (ConfiguredBlockTemp)blockTemp;
                for (BlockTemp temp : blockTemps) {
                    ConfiguredBlockTemp cfg2;
                    if (!(temp instanceof ConfiguredBlockTemp) || !cfg.equals(cfg2 = (ConfiguredBlockTemp)temp)) continue;
                    ColdSweat.LOGGER.error("Skipping duplicate BlockTemp for \"{}\" as an identical one is already registered", block);
                    ColdSweat.LOGGER.debug("{}", (Object)cfg);
                    return;
                }
            }
            if (front) {
                ArrayList<BlockTemp> blockTempList = new ArrayList<BlockTemp>(blockTemps);
                blockTempList.add(0, blockTemp);
                blockTemps.clear();
                blockTemps.addAll(blockTempList);
            } else {
                blockTemps.add(blockTemp);
            }
        });
        if (front) {
            BLOCK_TEMPS.add(0, blockTemp);
        } else {
            BLOCK_TEMPS.add(blockTemp);
        }
    }

    public static synchronized void flush() {
        MAPPED_BLOCKS.clear();
        BLOCK_TEMPS.clear();
    }

    public static Collection<BlockTemp> getBlockTempsFor(BlockState blockstate) {
        if (blockstate.m_60795_()) {
            return List.of(DEFAULT_BLOCK_TEMP);
        }
        Block block = blockstate.m_60734_();
        ArrayList<BlockTemp> blockTemps = MAPPED_BLOCKS.get((Object)block);
        if (blockTemps.isEmpty()) {
            blockTemps = new ArrayList<BlockTemp>(BLOCK_TEMPS.stream().filter(bt -> bt.hasBlock(block)).toList());
            if (blockTemps.isEmpty()) {
                blockTemps.add(DEFAULT_BLOCK_TEMP);
            }
            MAPPED_BLOCKS.putAll((Object)block, blockTemps);
            return blockTemps;
        }
        return blockTemps;
    }
}

