/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.handler;

import com.momosoftworks.coldsweat.common.capability.ModCapabilities;
import com.momosoftworks.coldsweat.common.capability.SidedCapabilityCache;
import com.momosoftworks.coldsweat.common.capability.shearing.IShearableCap;
import com.momosoftworks.coldsweat.common.capability.shearing.ShearableFurCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.SyncShearableDataMessage;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityDropData;
import com.momosoftworks.coldsweat.data.loot.ModLootTables;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;

@Mod.EventBusSubscriber
public class ShearableFurManager {
    public static SidedCapabilityCache<IShearableCap, Entity> CAP_CACHE = new SidedCapabilityCache<IShearableCap, Entity>(ModCapabilities.SHEARABLE_FUR, Entity::m_213877_);

    public static boolean isShearable(Entity entity) {
        return entity instanceof Goat;
    }

    @SubscribeEvent
    public static void attachCapabilityToEntityHandler(AttachCapabilitiesEvent<Entity> event) {
        if (ShearableFurManager.isShearable((Entity)event.getObject())) {
            final ShearableFurCap cap = new ShearableFurCap();
            final LazyOptional capOptional = LazyOptional.of(() -> cap);
            final Capability<IShearableCap> capability = ModCapabilities.SHEARABLE_FUR;
            ICapabilitySerializable<CompoundTag> provider = new ICapabilitySerializable<CompoundTag>(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap2, @Nullable Direction direction) {
                    if (cap2 == capability) {
                        return capOptional.cast();
                    }
                    return LazyOptional.empty();
                }

                public CompoundTag serializeNBT() {
                    return cap.serializeNBT();
                }

                public void deserializeNBT(CompoundTag nbt) {
                    cap.deserializeNBT(nbt);
                }
            };
            event.addCapability(new ResourceLocation("cold_sweat", "fur"), (ICapabilityProvider)provider);
        }
    }

    public static LazyOptional<IShearableCap> getFurCap(Entity entity) {
        return ShearableFurManager.isShearable(entity) ? CAP_CACHE.get(entity) : LazyOptional.empty();
    }

    @SubscribeEvent
    public static void onShearGoat(PlayerInteractEvent.EntityInteract event) {
        AgeableMob ageable;
        LivingEntity living;
        Entity entity = event.getTarget();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (!(!(entity instanceof LivingEntity) || (living = (LivingEntity)entity) instanceof AgeableMob && (ageable = (AgeableMob)living).m_6162_() || entity.m_9236_().f_46443_ || !stack.m_204117_(Tags.Items.SHEARS))) {
            ShearableFurManager.getFurCap((Entity)living).ifPresent(cap -> {
                if (cap.isSheared()) {
                    event.setResult(Event.Result.DENY);
                    return;
                }
                player.m_21011_(event.getHand(), true);
                ShearableFurManager.shear(living, player);
                if (!player.m_150110_().f_35937_) {
                    stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                }
                if (living instanceof Goat) {
                    Goat goat = (Goat)living;
                    if (!player.m_150110_().f_35937_ && goat.m_9236_().m_46791_() != Difficulty.PEACEFUL && !goat.m_9236_().f_46443_ && goat.m_217043_().m_188500_() < 0.4) {
                        goat.m_6274_().m_21879_(MemoryModuleType.f_148202_, (Object)30);
                        for (WrappedGoal goal : goat.f_21345_.m_148105_()) {
                            if (!goal.m_6767_()) continue;
                            goal.m_8041_();
                        }
                        TaskScheduler.scheduleServer(() -> {
                            ClientboundEntityEventPacket packet = new ClientboundEntityEventPacket((Entity)goat, 58);
                            ((ServerChunkCache)goat.m_9236_().m_7726_()).m_8394_((Entity)goat, (Packet)packet);
                        }, 5);
                        BehaviorUtils.m_22595_((LivingEntity)goat, (LivingEntity)player);
                        goat.m_6274_().m_21936_(MemoryModuleType.f_26370_);
                        goat.m_6274_().m_21879_(MemoryModuleType.f_148203_, (Object)player.m_20182_());
                        TaskScheduler.scheduleServer(() -> {
                            if (player.m_20270_((Entity)goat) <= 10.0f) {
                                goat.m_5496_(goat.m_149397_() ? SoundEvents.f_144149_ : SoundEvents.f_144169_, 1.0f, 1.0f);
                                goat.m_6274_().m_21879_(MemoryModuleType.f_148203_, (Object)player.m_20182_());
                            }
                        }, 30);
                        goat.m_6274_().m_21889_(Activity.f_150240_);
                    }
                }
                event.setResult(Event.Result.ALLOW);
            });
        }
    }

    @SubscribeEvent
    public static void onGoatTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        ShearableFurManager.getFurCap((Entity)entity).ifPresent(cap -> {
            EntityDropData furConfig = ConfigSettings.FUR_TIMINGS.get();
            if (cap.furGrowthCooldown() > 0) {
                cap.setFurGrowthCooldown(Math.min(cap.furGrowthCooldown() - 1, furConfig.cooldown()));
            }
            cap.setAge(cap.age() + 1);
            if (!entity.m_9236_().f_46443_ && cap.isSheared() && cap.age() % Math.max(1, furConfig.interval()) == 0 && cap.furGrowthCooldown() == 0 && entity.m_217043_().m_188500_() < furConfig.chance()) {
                WorldHelper.playEntitySound(SoundEvents.f_12641_, (Entity)entity, entity.m_5720_(), 0.5f, 0.6f);
                WorldHelper.playEntitySound(SoundEvents.f_12100_, (Entity)entity, entity.m_5720_(), 0.5f, 0.8f);
                WorldHelper.spawnParticleBatch(entity.m_9236_(), (ParticleOptions)ParticleTypes.f_123764_, entity.m_20185_(), entity.m_20186_() + (double)(entity.m_20206_() / 2.0f), entity.m_20189_(), 0.5, 0.5, 0.5, 10.0, 0.05f);
                cap.setSheared(false);
                ShearableFurManager.syncData(entity, null);
            }
        });
    }

    @SubscribeEvent
    public static void onEntityLoaded(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (ShearableFurManager.getFurCap(event.getTarget()).isPresent()) {
                ShearableFurManager.syncData((LivingEntity)event.getTarget(), player2);
            }
        }
    }

    public static boolean shear(LivingEntity entity, @Nullable Player player) {
        AtomicBoolean success = new AtomicBoolean(false);
        ShearableFurManager.getFurCap((Entity)entity).ifPresent(cap -> {
            if (!cap.isSheared()) {
                success.set(true);
                cap.setSheared(true);
                cap.setFurGrowthCooldown(ConfigSettings.FUR_TIMINGS.get().cooldown());
                for (ItemStack item : ModLootTables.getEntityDropsLootTable((Entity)entity, player, ModLootTables.GOAT_SHEARING)) {
                    WorldHelper.entityDropItem((Entity)entity, item);
                }
                entity.m_9236_().m_6269_(null, (Entity)entity, SoundEvents.f_12344_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                ShearableFurManager.syncData(entity, null);
            }
        });
        return success.get();
    }

    public static void syncData(LivingEntity entity, ServerPlayer player) {
        if (!entity.m_9236_().f_46443_) {
            ShearableFurManager.getFurCap((Entity)entity).ifPresent(cap -> ColdSweatPacketHandler.INSTANCE.send(player != null ? PacketDistributor.PLAYER.with(() -> player) : PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new SyncShearableDataMessage(entity.m_19879_(), cap.serializeNBT())));
        }
    }
}

