/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.container;

import com.momosoftworks.coldsweat.common.blockentity.HearthBlockEntity;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.init.MenuInit;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class HearthContainer
extends AbstractContainerMenu {
    public final HearthBlockEntity te;

    public HearthContainer(int windowId, Inventory playerInv, final HearthBlockEntity te) {
        super((MenuType)MenuInit.HEARTH_CONTAINER_TYPE.get(), windowId);
        this.te = te;
        this.m_38897_(new Slot((Container)te, 0, 80, 48){

            public boolean m_5857_(ItemStack stack) {
                if (te.getItemFuel(stack) != 0 || stack.m_150930_(Items.f_42455_)) {
                    return true;
                }
                List effects = PotionUtils.m_43547_((ItemStack)stack);
                return !effects.isEmpty() && effects.stream().noneMatch(eff -> ConfigSettings.HEARTH_POTION_BLACKLIST.get().contains(eff.m_19544_()));
            }
        });
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + 9 * row + 9, 8 + col * 18, 166 - (4 - row) * 18 - 10));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, 142));
        }
    }

    public HearthContainer(int windowId, Inventory playerInv, FriendlyByteBuf data) {
        this(windowId, playerInv, HearthContainer.getTileEntity(playerInv, data));
    }

    public int getHotFuel() {
        return this.te.getHotFuel();
    }

    public int getColdFuel() {
        return this.te.getColdFuel();
    }

    private static HearthBlockEntity getTileEntity(Inventory playerInv, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInv, "Player inventory cannot be null");
        Objects.requireNonNull(data, "PacketBuffer inventory cannot be null");
        BlockEntity te = playerInv.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (te instanceof HearthBlockEntity) {
            HearthBlockEntity hearth = (HearthBlockEntity)te;
            return hearth;
        }
        throw new IllegalStateException("Tile Entity is not correct");
    }

    public boolean m_6875_(Player playerIn) {
        return playerIn.m_20238_(Vec3.m_82512_((Vec3i)this.te.m_58899_())) <= 64.0;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(itemstack1, 1, 37, true)) {
                    return ItemStack.f_41583_;
                }
            } else {
                if (this.m_38853_(0).m_5857_(itemstack)) {
                    if (!this.m_38903_(itemstack1, 0, 1, false)) {
                        return ItemStack.f_41583_;
                    }
                } else if (CSMath.betweenInclusive(index, this.f_38839_.size() - 9, this.f_38839_.size() - 1)) {
                    if (!this.m_38903_(itemstack1, 1, this.f_38839_.size() - 10, false)) {
                        slot.m_40234_(itemstack1, itemstack);
                        return ItemStack.f_41583_;
                    }
                } else if (CSMath.betweenInclusive(index, 1.0, this.f_38839_.size() - 10) && !this.m_38903_(itemstack1, this.f_38839_.size() - 9, this.f_38839_.size(), false)) {
                    slot.m_40234_(itemstack1, itemstack);
                    return ItemStack.f_41583_;
                }
                return ItemStack.f_41583_;
            }
            slot.m_40234_(itemstack1, itemstack);
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemstack1);
        }
        return itemstack;
    }
}

