/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.config.spec;

import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.spec.CSConfigSpec;
import com.momosoftworks.coldsweat.util.serialization.ListBuilder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;

public class EntitySettingsConfig {
    private static final CSConfigSpec SPEC;
    private static final CSConfigSpec.Builder BUILDER;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> INSULATED_MOUNTS;
    public static final CSConfigSpec.ConfigValue<List<?>> GOAT_FUR_GROWTH_STATS;
    public static final CSConfigSpec.ConfigValue<List<?>> CHAMELEON_SHED_STATS;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> CHAMELEON_SPAWN_BIOMES;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> GOAT_SPAWN_BIOMES;
    public static final CSConfigSpec.BooleanValue CHAMELEON_SHED_AUTOMATICALLY;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> ENTITY_TEMPERATURES;
    public static final CSConfigSpec.ConfigValue<List<? extends List<?>>> ENTITY_CLIMATES;
    public static final CSConfigSpec.BooleanValue ENABLE_ENTITY_CLIMATES;
    public static final CSConfigSpec.BooleanValue ADVANCED_ENTITY_TEMPERATURE;

    public static void setup() {
        Path configPath = FMLPaths.CONFIGDIR.get();
        Path csConfigPath = Paths.get(configPath.toAbsolutePath().toString(), "coldsweat");
        try {
            Files.createDirectory(csConfigPath, new FileAttribute[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)SPEC, "coldsweat/entity.toml");
    }

    public static void save() {
        SPEC.save();
    }

    static {
        BUILDER = new CSConfigSpec.Builder();
        BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Anywhere that uses entity IDs also supports:", " \u2022 Tags (e.g. \"#minecraft:skeletons\")", " \u2022 Comma-separated lists (e.g. \"minecraft:zombie,#minecraft:skeletons\")", "     Applies the setting to all listed IDs. Can use tags, regular IDs, and negation interchangeably", " \u2022 Negation (e.g. \"!minecraft:evoker\")", "     Useful with lists/tags. Excludes the listed IDs from the setting", "     i.e. \"#minecraft:raiders,!minecraft:evoker\" (all raid mobs EXCEPT evokers)", " Settings with \"//v\" will list elements vertically. Removing \"//v\" will list elements in one line", "\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500");
        BUILDER.push("Entity Temperature");
        INSULATED_MOUNTS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " List of entities that will insulate the player when riding them", " A value of 0 provides no insulation; 1 provides full insulation", " \u2514\u2500\u2500 Format: [[\"entity_id\", coldResistance, heatResistance], [\"entity_id\", coldResistance, heatResistance], etc...]", " \u2304 ").defineListAllowEmpty(List.of("Insulated Mounts"), () -> Arrays.asList(new List[0]), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 3 && list.get(0) instanceof String && list.get(1) instanceof Number && list.get(2) instanceof Number;
        });
        ENTITY_TEMPERATURES = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines temperature-emitting properties for entities", " \u251c\u2500\u2500 Format: [[\"entity_id\", temperature, range, *units], [\"entity_id\", temperature, range, *units], etc...]", " \u2514\u2500\u2500 [* = optional]", " \u2022 temperature: The temperature emitted by the entity", " \u2022 range: The range of the effect, in blocks", " \u2022 units: (Optional) The units of the temperature value (MC, F, or C). Defaults to MC", " \u2304 ").defineListAllowEmpty(List.of("Entity Temperatures"), () -> Arrays.asList(new List[0]), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() >= 3 && list.get(0) instanceof String && list.get(1) instanceof Number && list.get(2) instanceof Number && (list.size() < 4 || list.get(3) instanceof String);
        });
        ENTITY_CLIMATES = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines entities that are affected by temperature and the climates they can live in", " \u251c\u2500\u2500 Format: [[\"entity_id\", minTemp, maxTemp, *rate, *units], [\"entity_id\", minTemp, maxTemp, *rate, *units], etc...]", " \u2514\u2500\u2500 [* = optional]", " \u2022 min_temp: The minimum livable temperature, as an offset to the minimum temperature for players", " \u2022 max_temp: The maximum livable temperature, as an offset to the maximum temperature for players", " \u2022 *rate: A multiplier to the rate at which the entity overheats or freezes, based on players' rate", " \u2022 *units: The units used for the min/max temperature values (MC, F, or C). Defaults to MC", " \u2304 ").defineListAllowEmpty(List.of("Entity Climate Settings"), () -> Arrays.asList(List.of("minecraft:chicken", Integer.valueOf(10), Integer.valueOf(10), Double.valueOf(0.6), "F"), List.of("minecraft:pig", Integer.valueOf(0), Integer.valueOf(0), Double.valueOf(0.5), "F"), List.of("minecraft:cow", Integer.valueOf(0), Integer.valueOf(20), Double.valueOf(0.2), "F"), List.of("minecraft:mooshroom", Integer.valueOf(0), Integer.valueOf(20), Double.valueOf(0.2), "F"), List.of("minecraft:sheep", Integer.valueOf(-20), Integer.valueOf(-10), Double.valueOf(0.3), "F"), List.of("minecraft:goat", Integer.valueOf(-40), Integer.valueOf(-15), Double.valueOf(0.4), "F"), List.of("minecraft:horse", Integer.valueOf(-5), Integer.valueOf(10), Double.valueOf(0.3), "F"), List.of("minecraft:donkey", Integer.valueOf(-5), Integer.valueOf(10), Double.valueOf(0.3), "F"), List.of("minecraft:mule", Integer.valueOf(-5), Integer.valueOf(10), Double.valueOf(0.3), "F"), List.of("minecraft:llama", Integer.valueOf(-10), Integer.valueOf(0), Double.valueOf(0.4), "F")), it -> {
            List list;
            return !(!(it instanceof List) || (list = (List)it).size() < 3 || !(list.get(0) instanceof String) || !(list.get(1) instanceof Number) || !(list.get(2) instanceof Number) || list.size() >= 4 && !(list.get(3) instanceof Number) || list.size() >= 5 && !(list.get(4) instanceof String));
        });
        ENABLE_ENTITY_CLIMATES = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Enables the temperature system for entities", " If disabled, entities will not be harmed by temperature", " \u2304 ").define("Enable Entity Climates", false);
        ADVANCED_ENTITY_TEMPERATURE = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Enables more precise temperature calculations for entities", " This option might cause performance issues for large amounts of entities", " \u2304 ").define("Use Advanced Entity Climates", false);
        BUILDER.pop();
        BUILDER.push("Fur Growth & Shedding");
        GOAT_FUR_GROWTH_STATS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines how often a goat will try to grow its fur, the growth cooldown after shearing, and the chance of it succeeding", " \u2514\u2500\u2500 Format: [interval, cooldown, chance]", " \u2304 ").defineList("Goat Fur Growth Timings", List.of(Integer.valueOf(1200), Integer.valueOf(2400), Double.valueOf(0.2)), it -> it instanceof Number);
        CHAMELEON_SHED_STATS = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " Defines how often a chameleon will try to shed its skin, the cooldown after shedding, and the chance of it succeeding", " Format: [interval, cooldown, chance]", " \u2304 ").defineList("Chameleon Shedding Timings", List.of(Integer.valueOf(400), Integer.valueOf(36000), Double.valueOf(0.1)), it -> it instanceof Number);
        CHAMELEON_SHED_AUTOMATICALLY = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", " If true, chameleons will automatically shed their skin over time", " If false, chameleons will only shed when a player interacts with them", " \u2304 ").define("Chameleons Shed Automatically", false);
        BUILDER.pop();
        BUILDER.push("Mob Spawning");
        CHAMELEON_SPAWN_BIOMES = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines the biomes that Chameleons can spawn in", " \u2514\u2500\u2500 Format: [[\"biome_id\", weight], [\"biome_id\", weight], etc...]", " \u2022 biome_id: The ID of the biome, e.g. \"minecraft:jungle\"", " \u2022 weight: The likelihood for the entity to spawn compared to other entities, higher values mean more common spawns", " \u2304 ").defineListAllowEmpty(List.of("Chameleon Spawn Biomes"), () -> ListBuilder.begin(new List[]{List.of("minecraft:bamboo_jungle", Integer.valueOf(80)), List.of("minecraft:jungle", Integer.valueOf(80)), List.of("minecraft:sparse_jungle", Integer.valueOf(35)), List.of("minecraft:desert", Integer.valueOf(1))}).addIf(CompatManager.isBiomesOPlentyLoaded(), () -> List.of("biomesoplenty:lush_desert", Integer.valueOf(3)), () -> List.of("biomesoplenty:rainforest", Integer.valueOf(20)), () -> List.of("biomesoplenty:rocky_rainforest", Integer.valueOf(15)), () -> List.of("biomesoplenty:fungal_jungle", Integer.valueOf(10)), () -> List.of("biomesoplenty:tropics", Integer.valueOf(8)), () -> List.of("biomesoplenty:outback", Integer.valueOf(2))).addIf(CompatManager.isBiomesYoullGoLoaded(), () -> List.of("byg:tropical_rainforest", Integer.valueOf(60)), () -> List.of("byg:jacaranda_forest", Integer.valueOf(3)), () -> List.of("byg:guiana_shield", Integer.valueOf(3)), () -> List.of("byg:crag_gardens", Integer.valueOf(4)), () -> List.of("byg:atacama_desert", Integer.valueOf(1)), () -> List.of("byg:cypress_swamplands", Integer.valueOf(3)), () -> List.of("byg:mojave_desert", Integer.valueOf(1)), () -> List.of("byg:windswept_desert", Integer.valueOf(2))).addIf(CompatManager.isBiomesWeveGoneLoaded(), () -> List.of("biomeswevegone:atacama_outback", Integer.valueOf(2)), () -> List.of("biomeswevegone:lush_stacks", Integer.valueOf(8)), () -> List.of("biomeswevegone:crag_gardens", Integer.valueOf(40)), () -> List.of("biomeswevegone:jacaranda_jungle", Integer.valueOf(30)), () -> List.of("biomeswevegone:fragment_jungle", Integer.valueOf(60)), () -> List.of("biomeswevegone:tropical_rainforest", Integer.valueOf(60)), () -> List.of("biomeswevegone:mojave_desert", Integer.valueOf(3)), () -> List.of("biomeswevegone:windswept_desert", Integer.valueOf(2)), () -> List.of("biomeswevegone:red_rock_valley", Integer.valueOf(1)), () -> List.of("biomeswevegone:ironwood_gour", Integer.valueOf(1)), () -> List.of("biomeswevegone:rugged_badlands", Integer.valueOf(1)), () -> List.of("biomeswevegone:sierra_badlands", Integer.valueOf(2)), () -> List.of("biomeswevegone:sierra_badlands", Integer.valueOf(2))).addIf(CompatManager.isAtmosphericLoaded(), () -> List.of("atmospheric:dunes", Double.valueOf(0.75)), () -> List.of("atmospheric:flourishing_dunes", Double.valueOf(1.5)), () -> List.of("atmospheric:rocky_dunes", Double.valueOf(0.75)), () -> List.of("atmospheric:petrified_dunes", Double.valueOf(0.5)), () -> List.of("atmospheric:rainforest", Integer.valueOf(50)), () -> List.of("atmospheric:sparse_rainforest", Integer.valueOf(40)), () -> List.of("atmospheric:rainforest_basin", Integer.valueOf(50)), () -> List.of("atmospheric:sparse_rainforest_basin", Integer.valueOf(30))).addIf(CompatManager.isTerralithLoaded(), () -> List.of("terralith:red_oasis", Integer.valueOf(3)), () -> List.of("terralith:desert_oasis", Integer.valueOf(3)), () -> List.of("terralith:tropical_jungle", Integer.valueOf(80)), () -> List.of("terralith:arid_highlands", Double.valueOf(1.5)), () -> List.of("terralith:rocky_jungle", Integer.valueOf(80)), () -> List.of("terralith:brushland", Double.valueOf(1.5))).addIf(CompatManager.isWythersLoaded(), () -> List.of("wythers:cactus_desert", Integer.valueOf(1)), () -> List.of("wythers:tropical_forest", Integer.valueOf(10)), () -> List.of("wythers:tropical_rainforest", Integer.valueOf(80))).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        GOAT_SPAWN_BIOMES = BUILDER.comment("\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500//v", " Defines the biomes that Chameleons can spawn in", " \u2514\u2500\u2500 Format: [[\"biome_id\", weight], [\"biome_id\", weight], etc...]", " \u2022 biome_id: The ID of the biome, e.g. \"minecraft:jungle\"", " \u2022 weight: The likelihood for the entity to spawn compared to other entities, higher values mean more common spawns", " \u2304 ").defineListAllowEmpty(List.of("Goat Spawn Biomes"), () -> ListBuilder.begin(new List[]{List.of("minecraft:frozen_peaks", Integer.valueOf(8)), List.of("minecraft:jagged_peaks", Integer.valueOf(8)), List.of("minecraft:snowy_slopes", Integer.valueOf(8)), List.of("minecraft:meadow", Integer.valueOf(3)), List.of("minecraft:windswept_hills", Integer.valueOf(6)), List.of("minecraft:windswept_forest", Integer.valueOf(6)), List.of("minecraft:windswept_gravelly_hills", Integer.valueOf(4)), List.of("minecraft:grove", Integer.valueOf(5)), List.of("minecraft:stony_peaks", Integer.valueOf(8))}).addIf(CompatManager.isBiomesOPlentyLoaded(), () -> List.of("biomesoplenty:boreal_forest", Integer.valueOf(5)), () -> List.of("biomesoplenty:jade_cliffs", Integer.valueOf(4)), () -> List.of("biomesoplenty:crag", Integer.valueOf(3))).addIf(CompatManager.isBiomesYoullGoLoaded(), () -> List.of("byg:canadian_shield", Integer.valueOf(3)), () -> List.of("byg:guiana_shield", Integer.valueOf(3)), () -> List.of("byg:fragment_forest", Integer.valueOf(128)), () -> List.of("byg:howling_peaks", Integer.valueOf(6)), () -> List.of("byg:shattered_glacier", Integer.valueOf(6)), () -> List.of("byg:dacite_ridges", Integer.valueOf(5))).addIf(CompatManager.isBiomesWeveGoneLoaded(), () -> List.of("biomeswevegone:howling_peaks", Integer.valueOf(6)), () -> List.of("biomeswevegone:canadian_shield", Integer.valueOf(3)), () -> List.of("biomeswevegone:shattered_glacier", Integer.valueOf(2)), () -> List.of("biomeswevegone:dacite_ridges", Integer.valueOf(5)), () -> List.of("biomeswevegone:zelkova_forest", Integer.valueOf(3)), () -> List.of("biomeswevegone:frosted_coniferous_forest", Integer.valueOf(3)), () -> List.of("biomeswevegone:skyrise_vale", Integer.valueOf(5)), () -> List.of("biomeswevegone:coconino_meadow", Integer.valueOf(3))).addIf(CompatManager.isTerralithLoaded(), () -> List.of("terralith:blooming_plateau", Integer.valueOf(5)), () -> List.of("terralith:rocky_mountains", Integer.valueOf(6)), () -> List.of("terralith:alpine_grove", Integer.valueOf(6)), () -> List.of("terralith:scarlet_mountains", Integer.valueOf(4)), () -> List.of("terralith:windswept_spires", Integer.valueOf(16)), () -> List.of("terralith:cloud_forest", Integer.valueOf(4)), () -> List.of("terralith:haze_mountain", Integer.valueOf(4))).build(), it -> {
            List list;
            return it instanceof List && (list = (List)it).size() == 2 && list.get(0) instanceof String && list.get(1) instanceof Number;
        });
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

