/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.requirement.sub_type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.data.codec.requirement.sub_type.EntitySubRequirement;
import com.momosoftworks.coldsweat.data.codec.util.DoubleBounds;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public record RaiderRequirement(Optional<Boolean> hasRaid, Optional<Boolean> isCaptain, Optional<RaidData> raid) implements EntitySubRequirement
{
    public static final MapCodec<RaiderRequirement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("has_raid").forGetter(RaiderRequirement::hasRaid), (App)Codec.BOOL.optionalFieldOf("is_captain").forGetter(RaiderRequirement::isCaptain), (App)RaidData.CODEC.optionalFieldOf("raid").forGetter(RaiderRequirement::raid)).apply((Applicative)instance, RaiderRequirement::new));

    @Override
    public MapCodec<? extends EntitySubRequirement> getCodec() {
        return CODEC;
    }

    @Override
    public boolean test(Entity entity, Level level, @Nullable Vec3 position) {
        Raider raider;
        return entity instanceof Raider && this.hasRaid.map(arg_0 -> RaiderRequirement.lambda$test$1(raider = (Raider)entity, arg_0)).orElse(true) != false && this.isCaptain.map(bool -> bool == RaiderRequirement.isCaptain(raider)).orElse(true) != false && this.raid.map(raidData -> raidData.test(raider.m_37885_())).orElse(true) != false;
    }

    private static boolean isCaptain(Raider raider) {
        ItemStack itemstack = raider.m_6844_(EquipmentSlot.HEAD);
        boolean wearingBanner = !itemstack.m_41619_() && ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)Raid.m_37779_());
        return wearingBanner && raider.m_33067_();
    }

    private static /* synthetic */ Boolean lambda$test$1(Raider raider, Boolean bool) {
        return bool.booleanValue() == raider.m_37886_();
    }

    public record RaidData(Optional<Boolean> isOver, Optional<Boolean> isBetweenWaves, Optional<Boolean> isFirstWaveSpawned, Optional<Boolean> isVictory, Optional<Boolean> isLoss, Optional<Boolean> isStarted, Optional<Boolean> isStopped, Optional<DoubleBounds> totalHealth, Optional<DoubleBounds> badOmenLevel, Optional<IntegerBounds> currentWave) {
        public static final Codec<RaidData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("is_over").forGetter(RaidData::isOver), (App)Codec.BOOL.optionalFieldOf("between_waves").forGetter(RaidData::isBetweenWaves), (App)Codec.BOOL.optionalFieldOf("first_wave_spawned").forGetter(RaidData::isFirstWaveSpawned), (App)Codec.BOOL.optionalFieldOf("is_victory").forGetter(RaidData::isVictory), (App)Codec.BOOL.optionalFieldOf("is_loss").forGetter(RaidData::isLoss), (App)Codec.BOOL.optionalFieldOf("is_started").forGetter(RaidData::isStarted), (App)Codec.BOOL.optionalFieldOf("is_stopped").forGetter(RaidData::isStopped), (App)DoubleBounds.CODEC.optionalFieldOf("total_health").forGetter(RaidData::totalHealth), (App)DoubleBounds.CODEC.optionalFieldOf("bad_omen_level").forGetter(RaidData::badOmenLevel), (App)IntegerBounds.CODEC.optionalFieldOf("current_wave").forGetter(RaidData::currentWave)).apply((Applicative)instance, RaidData::new));

        public boolean test(Raid raid) {
            return this.isOver.map(bool -> bool.booleanValue() == raid.m_37706_()).orElse(true) != false && this.isBetweenWaves.map(bool -> bool.booleanValue() == raid.m_37749_()).orElse(true) != false && this.isFirstWaveSpawned.map(bool -> bool.booleanValue() == raid.m_37757_()).orElse(true) != false && this.isVictory.map(bool -> bool.booleanValue() == raid.m_37767_()).orElse(true) != false && this.isLoss.map(bool -> bool.booleanValue() == raid.m_37768_()).orElse(true) != false && this.isStarted.map(bool -> bool.booleanValue() == raid.m_37770_()).orElse(true) != false && this.isStopped.map(bool -> bool.booleanValue() == raid.m_37762_()).orElse(true) != false && this.totalHealth.map(val -> val.test(raid.m_150220_())).orElse(true) != false && this.badOmenLevel.map(val -> val.test(raid.m_37773_())).orElse(true) != false && this.currentWave.map(val -> val.test(raid.m_37771_())).orElse(true) != false;
        }
    }
}

