package com.momosoftworks.coldsweat.api.temperature.block_temp.compat;

import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class CreateFluidTankTemp extends BlockTemp
{
    public CreateFluidTankTemp()
    {
        super(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 7, true, AllBlocks.FLUID_TANK.get(), AllBlocks.CREATIVE_FLUID_TANK.get());
    }

    @Override
    public double getTemperature(World level, @Nullable LivingEntity entity, BlockState state, BlockPos pos, double distance)
    {
        FluidTankTileEntity tank = (FluidTankTileEntity) level.getBlockEntity(pos);
        if (tank != null)
        {
            FluidStack fluid;
            if (tank.isController())
            {
                fluid = tank.getTankInventory().getFluid();
            }
            // Not controller; check controller for fluid
            else
            {
                FluidTankTileEntity controller = tank.getControllerTE();
                if (controller == null) return 0;
                fluid = controller.getTankInventory().getFluid();
                // Check if combined tank has enough fluid to reach this block
                double distToController = CSMath.getDistance(pos, controller.getBlockPos());
                double fluidHeight = (double) fluid.getAmount() / tank.getTotalTankSize();
                if (distToController > fluidHeight) return 0;
            }
            if (!fluid.isEmpty())
            {
                BlockState fluidState = fluid.getFluid().defaultFluidState().createLegacyBlock();
                return BlockTempRegistry.getFirstBlockTempFor(fluidState, level, pos).map(blockTemp ->
                       {   return blockTemp.getTemperature(level, entity, fluidState, pos, distance);
                       }).orElse(0.0);
            }
        }
        return 0;
    }
}
