/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.block_temp.compat;

import com.momosoftworks.coldsweat.api.registry.BlockTempRegistry;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.contraptions.fluids.tank.FluidTankTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class CreateFluidTankTemp
extends BlockTemp {
    public CreateFluidTankTemp() {
        super(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, 7.0, true, (Block)AllBlocks.FLUID_TANK.get(), (Block)AllBlocks.CREATIVE_FLUID_TANK.get());
    }

    @Override
    public double getTemperature(World level, @Nullable LivingEntity entity, BlockState state, BlockPos pos, double distance) {
        FluidTankTileEntity tank = (FluidTankTileEntity)level.func_175625_s(pos);
        if (tank != null) {
            FluidStack fluid;
            if (tank.isController()) {
                fluid = tank.getTankInventory().getFluid();
            } else {
                double fluidHeight;
                FluidTankTileEntity controller = tank.getControllerTE();
                if (controller == null) {
                    return 0.0;
                }
                fluid = controller.getTankInventory().getFluid();
                double distToController = CSMath.getDistance((Vector3i)pos, (Vector3i)controller.func_174877_v());
                if (distToController > (fluidHeight = (double)fluid.getAmount() / (double)tank.getTotalTankSize())) {
                    return 0.0;
                }
            }
            if (!fluid.isEmpty()) {
                BlockState fluidState = fluid.getFluid().func_207188_f().func_206883_i();
                return BlockTempRegistry.getFirstBlockTempFor(fluidState, level, pos).map(blockTemp -> blockTemp.getTemperature(level, entity, fluidState, pos, distance)).orElse(0.0);
            }
        }
        return 0.0;
    }
}

