/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.effect.player;

import com.momosoftworks.coldsweat.api.event.vanilla.RenderLevelEvent;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.client.renderer.PostProcessShaderManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.util.IntegerBounds;
import com.momosoftworks.coldsweat.util.math.CSMath;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class HeatBlurEffect
extends TempEffect {
    public HeatBlurEffect(TempEffectType<?> type, LivingEntity entity, IntegerBounds bounds) {
        super(type, entity, bounds);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderBlur(RenderLevelEvent.Post event) {
        if (!this.test((Entity)Minecraft.func_71410_x().field_71439_g)) {
            return;
        }
        double effect = this.getEffectFactor();
        float blurMultiplier = ConfigSettings.HEATSTROKE_BLUR_AMOUNT.get().floatValue();
        if (blurMultiplier == 0.0f) {
            return;
        }
        PostProcessShaderManager shaderManager = PostProcessShaderManager.getInstance();
        if (ConfigSettings.DISTORTION_EFFECTS.get().booleanValue()) {
            ShaderUniform blurRadius;
            float blur = (float)CSMath.blend(0.0, 12.0, effect, 0.0, 1.0) * blurMultiplier;
            if (!shaderManager.hasEffect("heat_blur")) {
                shaderManager.loadEffect("heat_blur", PostProcessShaderManager.BLOBS);
            }
            if ((blurRadius = shaderManager.getPostPasses("heat_blur").get(0).func_217624_b().func_216539_a("Radius")) != null) {
                blurRadius.func_148090_a(blur);
            }
        } else if (shaderManager.hasEffect("heat_blur")) {
            shaderManager.closeEffect("heat_blur");
        }
        shaderManager.process(event.getPartialTick());
    }

    @Override
    public TempEffect.Side getSide() {
        return TempEffect.Side.CLIENT;
    }
}

