/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.gui.config.pages;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.client.gui.config.ConfigScreen;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ConfigPageDifficulty
extends Screen {
    private static final String BLUE = TextFormatting.BLUE.toString();
    private static final String RED = TextFormatting.RED.toString();
    private static final String YEL = TextFormatting.YELLOW.toString();
    private static final String CLEAR = TextFormatting.RESET.toString();
    private static final String BOLD = TextFormatting.BOLD.toString();
    private static final String U_LINE = TextFormatting.UNDERLINE.toString();
    private static final List<TextComponent> SUPER_EASY_DESCRIPTION = ConfigPageDifficulty.generateDescription(ConfigSettings.Difficulty.SUPER_EASY);
    private static final List<TextComponent> EASY_DESCRIPTION = ConfigPageDifficulty.generateDescription(ConfigSettings.Difficulty.EASY);
    private static final List<TextComponent> NORMAL_DESCRIPTION = ConfigPageDifficulty.generateDescription(ConfigSettings.Difficulty.NORMAL);
    private static final List<TextComponent> HARD_DESCRIPTION = ConfigPageDifficulty.generateDescription(ConfigSettings.Difficulty.HARD);
    private static final List<TextComponent> CUSTOM_DESCRIPTION = Collections.singletonList(new TranslationTextComponent("cold_sweat.config.difficulty.description.custom"));
    static final ResourceLocation CONFIG_BUTTONS_LOCATION = new ResourceLocation("cold_sweat:textures/gui/screen/config_gui.png");
    private final Screen parentScreen;

    public ConfigPageDifficulty(Screen parentScreen) {
        super((ITextComponent)new TranslationTextComponent("cold_sweat.config.section.difficulty"));
        this.parentScreen = parentScreen;
    }

    public static List<TextComponent> getListFor(ConfigSettings.Difficulty difficulty) {
        switch (difficulty) {
            case SUPER_EASY: {
                return SUPER_EASY_DESCRIPTION;
            }
            case EASY: {
                return EASY_DESCRIPTION;
            }
            case NORMAL: {
                return NORMAL_DESCRIPTION;
            }
            case HARD: {
                return HARD_DESCRIPTION;
            }
        }
        return CUSTOM_DESCRIPTION;
    }

    private static List<TextComponent> generateDescription(ConfigSettings.Difficulty difficulty) {
        return Arrays.asList(new TranslationTextComponent("cold_sweat.config.difficulty.description.min_temp", new Object[]{ConfigPageDifficulty.getTemperatureString((Double)difficulty.getSetting(ColdSweat.createKey("min_temp")), BLUE)}), new TranslationTextComponent("cold_sweat.config.difficulty.description.max_temp", new Object[]{ConfigPageDifficulty.getTemperatureString((Double)difficulty.getSetting(ColdSweat.createKey("max_temp")), RED)}), new StringTextComponent(ConfigPageDifficulty.getRateComponent(difficulty).getString()), new StringTextComponent(new TranslationTextComponent("cold_sweat.config.difficulty.description.world_temp_" + ((Boolean)difficulty.getSetting(ColdSweat.createKey("require_thermometer")) != false ? "off" : "on"), new Object[]{BOLD + U_LINE, CLEAR}).getString()), new StringTextComponent(new TranslationTextComponent("cold_sweat.config.difficulty.description.potions_" + ((Boolean)difficulty.getSetting(ColdSweat.createKey("ice_resistance_enabled")) != false ? "on" : "off"), new Object[]{BOLD + U_LINE, CLEAR}).getString()));
    }

    private static String getTemperatureString(double temp, String color) {
        DecimalFormat df = new DecimalFormat("#.##");
        return color + df.format(Temperature.convert(temp, Temperature.Units.MC, Temperature.Units.F, true)) + CLEAR + " \u00b0F / " + color + df.format(Temperature.convert(temp, Temperature.Units.MC, Temperature.Units.C, true)) + CLEAR + " \u00b0C";
    }

    private static TextComponent getRateComponent(ConfigSettings.Difficulty difficulty) {
        double rate = (Double)difficulty.getSetting(ColdSweat.createKey("temp_rate"));
        String key = rate < 1.0 ? "cold_sweat.config.difficulty.description.rate.decrease" : (rate == 1.0 ? "cold_sweat.config.difficulty.description.rate.normal" : "cold_sweat.config.difficulty.description.rate.increase");
        return rate == 1.0 ? new TranslationTextComponent(key) : new TranslationTextComponent(key, new Object[]{YEL + Math.abs(1.0 - rate) * 100.0 + "%" + CLEAR});
    }

    public static int getDifficultyColor(ConfigSettings.Difficulty difficulty) {
        switch (difficulty) {
            case SUPER_EASY: {
                return 0xFFFFFF;
            }
            case EASY: {
                return 16768882;
            }
            case NORMAL: {
                return 16755024;
            }
            case HARD: {
                return 16731202;
            }
        }
        return 10631158;
    }

    public int index() {
        return -1;
    }

    protected void func_231160_c_() {
        this.func_230481_d_((IGuiEventListener)new Button(this.field_230708_k_ / 2 - 75, this.field_230709_l_ - 26, 150, 20, DialogTexts.field_240632_c_, button -> this.func_231175_as__()));
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230706_i_.field_71441_e != null) {
            this.func_238468_a_(matrixStack, 0, 0, this.field_230708_k_, this.field_230709_l_, -1072689136, -804253680);
        } else {
            this.func_231165_f_(0);
        }
        ConfigSettings.Difficulty difficulty = ConfigSettings.DIFFICULTY.get();
        ArrayList<Object> descLines = new ArrayList<Object>();
        descLines.add(new StringTextComponent(""));
        int longestLine = 0;
        for (TextComponent text : ConfigPageDifficulty.getListFor(difficulty)) {
            IFormattableTextComponent descLine = new StringTextComponent(" \u2022 ").func_230529_a_((ITextComponent)text).func_240702_b_(" ");
            descLines.add(descLine);
            descLines.add(new StringTextComponent(""));
            int lineWidth = this.field_230712_o_.func_238414_a_((ITextProperties)descLine);
            if (lineWidth <= longestLine) continue;
            longestLine = lineWidth;
        }
        int middleX = this.field_230708_k_ / 2;
        int middleY = this.field_230709_l_ / 2;
        this.renderWrappedToolTip(matrixStack, descLines, middleX - longestLine / 2 - 10, middleY - 16, this.field_230712_o_);
        ConfigScreen.MOUSE_X = mouseX;
        ConfigScreen.MOUSE_Y = mouseY;
        ConfigPageDifficulty.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)this.field_230704_d_.getString(), (int)(this.field_230708_k_ / 2), (int)16, (int)0xFFFFFF);
        this.field_230706_i_.field_71446_o.func_110577_a(CONFIG_BUTTONS_LOCATION);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 76, this.field_230709_l_ / 2 - 53, 12, this.isMouseOverSlider(mouseX, mouseY) ? 134 : 128, 152, 6);
        this.func_238474_b_(matrixStack, this.field_230708_k_ / 2 - 78 + difficulty.ordinal() * 37, this.field_230709_l_ / 2 - 58, this.isMouseOverSlider(mouseX, mouseY) ? 0 : 6, 128, 6, 16);
        IFormattableTextComponent difficultyName = ConfigSettings.Difficulty.getFormattedName(difficulty);
        this.field_230712_o_.func_243246_a(matrixStack, (ITextComponent)difficultyName, (float)this.field_230708_k_ / 2.0f - (float)this.field_230712_o_.func_238414_a_((ITextProperties)difficultyName) / 2.0f, (float)this.field_230709_l_ / 2.0f - 84.0f, ConfigPageDifficulty.getDifficultyColor(difficulty));
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void func_231175_as__() {
        super.func_231175_as__();
        ConfigSettings.DIFFICULTY.get().load();
        ConfigScreen.saveConfig();
        ConfigScreen.MC.func_147108_a(this.parentScreen);
    }

    boolean isMouseOverSlider(double mouseX, double mouseY) {
        return mouseX >= (double)this.field_230708_k_ / 2.0 - 80.0 && mouseX <= (double)this.field_230708_k_ / 2.0 + 80.0 && mouseY >= (double)this.field_230709_l_ / 2.0 - 67.0 && mouseY <= (double)this.field_230709_l_ / 2.0 - 35.0;
    }

    public void func_231023_e_() {
        double x = ConfigScreen.MOUSE_X;
        double y = ConfigScreen.MOUSE_Y;
        if (ConfigScreen.IS_MOUSE_DOWN && this.isMouseOverSlider(x, y)) {
            ConfigSettings.Difficulty newDifficulty = ConfigSettings.Difficulty.values()[(int)Math.round(CSMath.blend(0.0, 4.0, x, (double)this.field_230708_k_ / 2.0 - 76.0, (double)this.field_230708_k_ / 2.0 + 76.0))];
            if (newDifficulty != ConfigSettings.DIFFICULTY.get()) {
                ConfigScreen.MC.func_147118_V().func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)new SoundEvent(new ResourceLocation("minecraft:block.note_block.hat")), (float)1.8f, (float)0.5f));
            }
            ConfigSettings.DIFFICULTY.set(newDifficulty);
        }
    }
}

