/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.particle;

import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.util.ReuseableStream;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VaporParticle
extends SpriteTexturedParticle {
    private final IAnimatedSprite ageSprite;
    private final boolean hasGravity;
    private boolean collidedY;
    private float maxAlpha;
    VaporType type;

    protected VaporParticle(ClientWorld world, double x, double y, double z, double vx, double vy, double vz, IAnimatedSprite spriteSet, VaporType type) {
        super(world, x, y, z);
        this.ageSprite = spriteSet;
        this.field_82339_as = 0.0f;
        this.maxAlpha = (float)(Math.random() / 3.0 + 0.5);
        this.func_70541_f(3.0f + (float)(Math.random() / 2.5));
        this.func_187115_a(this.field_70544_f / 10.0f, this.field_70544_f / 10.0f);
        this.field_70547_e = 40 + (int)(Math.random() * 20.0 - 10.0);
        this.field_190017_n = true;
        this.func_217566_b(spriteSet);
        this.hasGravity = type == VaporType.GROUND_MIST;
        this.type = type;
        switch (type) {
            case STEAM: {
                this.field_70545_g = -0.04f;
                break;
            }
            case GROUND_MIST: {
                this.field_70545_g = 0.04f;
                break;
            }
            case MIST: {
                this.field_70545_g = 0.0f;
            }
        }
        if (type == VaporType.MIST) {
            this.maxAlpha = 0.2f;
        }
    }

    @Nonnull
    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    public void func_189213_a() {
        if (Minecraft.func_71410_x().field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) {
            this.func_187112_i();
        }
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        } else {
            this.field_187130_j -= 0.04 * (double)this.field_70545_g;
            this.func_187110_a(this.field_187129_i * (this.field_187132_l ? 1.0 : 0.2), this.field_187130_j, this.field_187131_k * (this.field_187132_l ? 1.0 : 0.2));
            this.field_187129_i *= 0.99;
            this.field_187130_j *= 0.99;
            this.field_187129_i *= 0.99;
        }
        this.func_217566_b(this.ageSprite);
        if (this.type == VaporType.GROUND_MIST) {
            if (this.field_82339_as < this.maxAlpha) {
                this.field_82339_as += 0.02f;
            } else if (this.field_70546_d > 32) {
                this.field_82339_as -= 0.02f;
            }
            if ((double)this.field_82339_as < 0.035 && this.field_70546_d > 10) {
                this.func_187112_i();
            }
        } else if (this.type == VaporType.MIST || this.type == VaporType.STEAM) {
            if (this.field_82339_as < this.maxAlpha) {
                this.field_82339_as += this.maxAlpha / 20.0f;
            } else if ((float)this.field_70546_d > this.maxAlpha / (this.maxAlpha / 20.0f)) {
                this.field_82339_as -= this.maxAlpha / 20.0f;
            }
            if ((double)this.field_82339_as < 0.02 && this.field_70546_d > 10) {
                this.func_187112_i();
            }
        }
    }

    public void func_187110_a(double x, double y, double z) {
        double d0 = x;
        double d1 = y;
        double d2 = z;
        if (this.field_190017_n && (x != 0.0 || y != 0.0 || z != 0.0)) {
            Vector3d vec3 = Entity.func_213313_a((Vector3d)new Vector3d(x, y, z), (AxisAlignedBB)this.func_187116_l(), (IWorldReader)this.field_187122_b, (ISelectionContext)ISelectionContext.func_216377_a(), (ReuseableStream)new ReuseableStream(Stream.of(new VoxelShape[0])));
            x = vec3.field_72450_a;
            y = vec3.field_72448_b;
            z = vec3.field_72449_c;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.func_187108_a(this.func_187116_l().func_72317_d(x, this.collidedY ? 0.0 : y, z));
            AxisAlignedBB axisalignedbb = this.func_187116_l();
            this.field_187126_f = (axisalignedbb.field_72340_a + axisalignedbb.field_72336_d) / 2.0;
            this.field_187127_g = axisalignedbb.field_72338_b + (this.hasGravity ? 0.2 : 0.0);
            this.field_187128_h = (axisalignedbb.field_72339_c + axisalignedbb.field_72334_f) / 2.0;
        }
        if (Math.abs(d1) >= 1.0E-5 && Math.abs(y) < 1.0E-5) {
            this.collidedY = true;
        }
        boolean bl = this.field_187132_l = d1 != y && d1 < 0.0;
        if (d0 != x) {
            this.field_187129_i = 0.0;
        }
        if (d2 != z) {
            this.field_187131_k = 0.0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class MistFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite sprite;

        public MistFactory(IAnimatedSprite spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(BasicParticleType type, ClientWorld level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new VaporParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite, VaporType.MIST);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class GroundMistFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite sprite;

        public GroundMistFactory(IAnimatedSprite spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(BasicParticleType type, ClientWorld level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new VaporParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite, VaporType.GROUND_MIST);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SteamFactory
    implements IParticleFactory<BasicParticleType> {
        private final IAnimatedSprite sprite;

        public SteamFactory(IAnimatedSprite spriteSet) {
            this.sprite = spriteSet;
        }

        public Particle createParticle(BasicParticleType type, ClientWorld level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            if (Minecraft.func_71410_x().field_71474_y.field_74362_aa != ParticleStatus.MINIMAL) {
                return new VaporParticle(level, x, y, z, xSpeed, ySpeed, zSpeed, this.sprite, VaporType.STEAM);
            }
            return null;
        }
    }

    public static enum VaporType {
        STEAM,
        GROUND_MIST,
        MIST;

    }
}

