/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.momosoftworks.coldsweat.client.renderer.layer.ChameleonColorLayer;
import com.momosoftworks.coldsweat.client.renderer.model.entity.ChameleonModel;
import com.momosoftworks.coldsweat.common.entity.ChameleonEntity;
import com.momosoftworks.coldsweat.util.math.CSMath;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class ChameleonEntityRenderer<T extends ChameleonEntity>
extends MobRenderer<ChameleonEntity, ChameleonModel<ChameleonEntity>> {
    public static final ResourceLocation CHAMELEON_SHED = new ResourceLocation("cold_sweat", "textures/entity/chameleon/chameleon_shed.png");
    public static final ResourceLocation CHAMELEON_GREEN = new ResourceLocation("cold_sweat", "textures/entity/chameleon/chameleon_green.png");
    public static final ResourceLocation CHAMELEON_RED = new ResourceLocation("cold_sweat", "textures/entity/chameleon/chameleon_red.png");
    public static final ResourceLocation CHAMELEON_BLUE = new ResourceLocation("cold_sweat", "textures/entity/chameleon/chameleon_blue.png");

    public ChameleonEntityRenderer(EntityRendererManager context) {
        super(context, new ChameleonModel(), 0.5f);
        this.func_177094_a(new ChameleonColorLayer(this));
    }

    public void render(ChameleonEntity entity, float p_115456_, float partialTick, MatrixStack ms, IRenderTypeBuffer buffer, int light) {
        ms.func_227860_a_();
        if (entity.func_184187_bx() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity.func_184187_bx();
            float playerHeadYaw = CSMath.blend(player.field_70758_at, player.field_70759_as, partialTick, 0.0f, 1.0f);
            float playerHeadPitch = player.func_195050_f(partialTick);
            float ridingOffset = (float)entity.func_70033_W();
            ms.func_227861_a_(0.0, -((double)ridingOffset - 0.05), 0.0);
            ms.func_227863_a_(CSMath.toQuaternion(CSMath.toRadians(playerHeadPitch), -CSMath.toRadians(playerHeadYaw), 0.0));
            ms.func_227861_a_(0.0, (double)ridingOffset, 0.0);
            ms.func_227863_a_(CSMath.toQuaternion(0.0, CSMath.toRadians(playerHeadYaw), 0.0));
            ms.func_227861_a_(0.0, -1.45, 0.0);
        }
        super.func_225623_a_((MobEntity)entity, p_115456_, partialTick, ms, buffer, light);
        ms.func_227865_b_();
    }

    public ResourceLocation getTextureLocation(ChameleonEntity entity) {
        return CHAMELEON_GREEN;
    }

    @Nullable
    protected RenderType getRenderType(ChameleonEntity chameleon, boolean p_230496_2_, boolean p_230496_3_, boolean p_230496_4_) {
        return RenderType.func_228644_e_((ResourceLocation)this.getTextureLocation(chameleon));
    }
}

