/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.block;

import com.momosoftworks.coldsweat.common.blockentity.ThermolithBlockEntity;
import com.momosoftworks.coldsweat.core.init.BlockEntityInit;
import com.momosoftworks.coldsweat.core.itemgroup.ColdSweatGroup;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.ToIntFunction;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ThermolithBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.field_208157_J;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    private static final Map<Direction, VoxelShape> SHAPES = new HashMap<Direction, VoxelShape>();

    public ThermolithBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        ThermolithBlock.calculateFacingShapes(VoxelShapes.func_197872_a((VoxelShape)Block.func_208617_a((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)16.0, (double)16.0), (VoxelShape)Block.func_208617_a((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)6.0, (double)5.0)));
    }

    public static AbstractBlock.Properties getProperties() {
        return AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_235599_U_).func_200943_b(2.0f).func_226896_b_().func_208770_d().func_235838_a_(ThermolithBlock.getLightValueLit(5)).func_235828_a_((state, level, pos) -> true).func_235861_h_();
    }

    private static ToIntFunction<BlockState> getLightValueLit(int lightValue) {
        return state -> (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u) != false ? lightValue : 0;
    }

    public static Item.Properties getItemProperties() {
        return new Item.Properties().func_200916_a((ItemGroup)ColdSweatGroup.COLD_SWEAT).func_200917_a(64);
    }

    static void calculateFacingShapes(VoxelShape shape) {
        for (Direction direction : Direction.values()) {
            SHAPES.put(direction, CSMath.rotateShape(direction, shape));
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader getter, BlockPos pos, ISelectionContext context) {
        return SHAPES.get(state.func_177229_b((Property)FACING));
    }

    public BlockState func_185499_a(BlockState state, Rotation direction) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)direction.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, POWERED});
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)BlockEntityInit.THERMOLITH_BLOCK_ENTITY_TYPE.get()).func_200968_a();
    }

    public int func_180656_a(BlockState state, IBlockReader level, BlockPos pos, Direction direction) {
        TileEntity blockEntity = level.func_175625_s(pos);
        if (direction == ((Direction)state.func_177229_b((Property)FACING)).func_176734_d() && blockEntity instanceof ThermolithBlockEntity) {
            return ((ThermolithBlockEntity)blockEntity).getSignal();
        }
        return 0;
    }

    public int func_176211_b(BlockState state, IBlockReader level, BlockPos pos, Direction direction) {
        return state.func_185911_a(level, pos, direction);
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader level, BlockPos pos, Direction direction) {
        return direction == ((Direction)state.func_177229_b((Property)FACING)).func_176734_d();
    }

    public boolean func_149744_f(BlockState pState) {
        return true;
    }

    public void func_196243_a(BlockState state, World level, BlockPos pos, BlockState newState, boolean moved) {
        super.func_196243_a(state, level, pos, newState, moved);
        ThermolithBlock.updateFacingNeighbors(level, state, pos);
    }

    public static void updateFacingNeighbors(World level, BlockState state, BlockPos pos) {
        Direction facing = (Direction)state.func_177229_b((Property)FACING);
        level.func_195593_d(pos, state.func_177230_c());
        level.func_195593_d(pos.func_177972_a(facing), level.func_180495_p(pos.func_177972_a(facing)).func_177230_c());
    }

    public void func_180655_c(BlockState state, World world, BlockPos pos, Random random) {
        ParticleStatus status = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue() && status != ParticleStatus.MINIMAL) {
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            boolean xAxis = direction.func_176740_k() == Direction.Axis.X;
            float headLength = 0.25f;
            float offset = xAxis ? (direction.func_82601_c() < 0 ? headLength : -0.05f) : (direction.func_82599_e() < 0 ? headLength : -0.05f);
            double pY = Math.random() * 0.625 + 0.375;
            double pX = xAxis ? (double)random.nextInt(2) * 0.8 + (double)offset : 0.5;
            double pZ = xAxis ? 0.5 : (double)random.nextInt(2) * 0.8 + (double)offset;
            Vector3f particleColor = new Vector3f(Vector3d.func_237487_a_((int)4895036));
            world.func_195594_a((IParticleData)new RedstoneParticleData(particleColor.func_195899_a(), particleColor.func_195900_b(), particleColor.func_195902_c(), random.nextFloat() * 0.5f + 0.5f), (double)pos.func_177958_n() + pX, (double)pos.func_177956_o() + pY, (double)pos.func_177952_p() + pZ, 0.0, 0.0, 0.0);
            if (random.nextDouble() < 0.5) {
                float rX = xAxis ? (float)Math.random() * 0.8f + offset : 0.5f;
                float rZ = xAxis ? 0.5f : (float)Math.random() * 0.8f + offset;
                world.func_195594_a((IParticleData)new RedstoneParticleData(particleColor.func_195899_a(), particleColor.func_195900_b(), particleColor.func_195902_c(), random.nextFloat() * 0.5f + 0.5f), (double)((float)pos.func_177958_n() + rX), (double)pos.func_177956_o() + 1.05, (double)((float)pos.func_177952_p() + rZ), 0.0, 0.0, 0.0);
            }
        }
    }
}

