/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.handler;

import com.momosoftworks.coldsweat.common.capability.ModCapabilities;
import com.momosoftworks.coldsweat.common.capability.SidedCapabilityCache;
import com.momosoftworks.coldsweat.common.capability.shearing.IShearableCap;
import com.momosoftworks.coldsweat.common.capability.shearing.ShearableFurCap;
import com.momosoftworks.coldsweat.common.entity.GoatEntity;
import com.momosoftworks.coldsweat.compat.CompatManager;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.core.network.message.SyncShearableDataMessage;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityDropData;
import com.momosoftworks.coldsweat.data.loot.ModLootTables;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber
public class ShearableFurManager {
    public static SidedCapabilityCache<IShearableCap, Entity> CAP_CACHE = new SidedCapabilityCache(() -> ModCapabilities.SHEARABLE_FUR, ent -> ent.field_70128_L);

    public static boolean isShearable(Entity entity) {
        return entity instanceof GoatEntity || CompatManager.isGoat(entity);
    }

    @SubscribeEvent
    public static void attachCapabilityToEntityHandler(AttachCapabilitiesEvent<Entity> event) {
        if (ShearableFurManager.isShearable((Entity)event.getObject())) {
            final ShearableFurCap cap = new ShearableFurCap();
            final LazyOptional capOptional = LazyOptional.of(() -> cap);
            final Capability<IShearableCap> capability = ModCapabilities.SHEARABLE_FUR;
            ICapabilitySerializable<CompoundNBT> provider = new ICapabilitySerializable<CompoundNBT>(){

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap2, @Nullable Direction direction) {
                    if (cap2 == capability) {
                        return capOptional.cast();
                    }
                    return LazyOptional.empty();
                }

                public CompoundNBT serializeNBT() {
                    return cap.serializeNBT();
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    cap.deserializeNBT(nbt);
                }
            };
            event.addCapability(new ResourceLocation("cold_sweat", "fur"), (ICapabilityProvider)provider);
        }
    }

    public static LazyOptional<IShearableCap> getFurCap(Entity entity) {
        return ShearableFurManager.isShearable(entity) ? CAP_CACHE.get(entity) : LazyOptional.empty();
    }

    @SubscribeEvent
    public static void onShearGoat(PlayerInteractEvent.EntityInteract event) {
        Entity entity = event.getTarget();
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getItemStack();
        if (!(!(entity instanceof LivingEntity) || entity instanceof AgeableEntity && ((AgeableEntity)entity).func_70631_g_() || entity.field_70170_p.field_72995_K || !Tags.Items.SHEARS.func_230235_a_((Object)stack.func_77973_b()))) {
            ShearableFurManager.getFurCap(entity).ifPresent(cap -> {
                if (cap.isSheared()) {
                    event.setResult(Event.Result.DENY);
                    return;
                }
                player.func_226292_a_(event.getHand(), true);
                ShearableFurManager.shear((LivingEntity)entity, player);
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(player.func_184600_cs()));
                }
                cap.setSheared(true);
                cap.setFurGrowthCooldown(ConfigSettings.FUR_TIMINGS.get().cooldown());
                ShearableFurManager.syncData((LivingEntity)entity, null);
                event.setResult(Event.Result.ALLOW);
            });
        }
    }

    @SubscribeEvent
    public static void onShearableEntityTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        ShearableFurManager.getFurCap((Entity)entity).ifPresent(cap -> {
            EntityDropData furConfig = ConfigSettings.FUR_TIMINGS.get();
            if (cap.furGrowthCooldown() > 0) {
                cap.setFurGrowthCooldown(Math.min(cap.furGrowthCooldown() - 1, furConfig.cooldown()));
            }
            cap.setAge(cap.age() + 1);
            if (!entity.field_70170_p.field_72995_K && cap.isSheared() && cap.age() % Math.max(1, furConfig.interval()) == 0 && cap.furGrowthCooldown() == 0 && entity.func_70681_au().nextDouble() < furConfig.chance()) {
                WorldHelper.playEntitySound(SoundEvents.field_187550_ag, (Entity)entity, entity.func_184176_by(), 0.5f, 0.6f);
                WorldHelper.playEntitySound(SoundEvents.field_191257_dH, (Entity)entity, entity.func_184176_by(), 0.5f, 0.8f);
                WorldHelper.spawnParticleBatch(entity.field_70170_p, (IParticleData)ParticleTypes.field_197602_M, entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), 0.5, 0.5, 0.5, 10.0, 0.05f);
                cap.setSheared(false);
                ShearableFurManager.syncData(entity, null);
            }
        });
    }

    @SubscribeEvent
    public static void onEntityLoaded(PlayerEvent.StartTracking event) {
        if (event.getEntity() instanceof ServerPlayerEntity && ShearableFurManager.getFurCap(event.getTarget()).isPresent()) {
            ShearableFurManager.syncData((LivingEntity)event.getTarget(), (ServerPlayerEntity)event.getEntity());
        }
    }

    public static boolean shear(LivingEntity entity, @Nullable PlayerEntity player) {
        AtomicBoolean success = new AtomicBoolean(false);
        ShearableFurManager.getFurCap((Entity)entity).ifPresent(cap -> {
            if (!cap.isSheared()) {
                success.set(true);
                cap.setSheared(true);
                cap.setFurGrowthCooldown(ConfigSettings.FUR_TIMINGS.get().cooldown());
                for (ItemStack item : ModLootTables.getEntityDropsLootTable((Entity)entity, player, ModLootTables.GOAT_SHEARING)) {
                    WorldHelper.entityDropItem((Entity)entity, item);
                }
                entity.field_70170_p.func_217384_a(null, (Entity)entity, SoundEvents.field_187763_eJ, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                ShearableFurManager.syncData(entity, null);
            }
        });
        return success.get();
    }

    public static void syncData(LivingEntity entity, ServerPlayerEntity player) {
        if (!entity.field_70170_p.field_72995_K) {
            ShearableFurManager.getFurCap((Entity)entity).ifPresent(cap -> ColdSweatPacketHandler.INSTANCE.send(player != null ? PacketDistributor.PLAYER.with(() -> player) : PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)new SyncShearableDataMessage(entity.func_145782_y(), cap.serializeNBT())));
        }
    }
}

