/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.capability.temperature;

import com.google.common.math.DoubleMath;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.event.common.temperautre.TemperatureChangedEvent;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.api.temperature.modifier.TempModifier;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.core.advancement.trigger.ModAdvancementTriggers;
import com.momosoftworks.coldsweat.data.codec.configuration.EntityClimateData;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModDamageSources;
import com.momosoftworks.coldsweat.util.registries.ModEffects;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.NBTHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class AbstractTempCap
implements ITemperatureCap {
    boolean changed = true;
    int syncTimer = 0;
    Temperature.Units preferredUnits = Temperature.Units.F;
    private final Set<Attribute> persistentAttributes = new HashSet<Attribute>();
    private final EnumMap<Temperature.Trait, Double> traits = new EnumMap(Temperature.Trait.class);
    private final EnumMap<Temperature.Trait, List<TempModifier>> modifiers = new EnumMap(Temperature.Trait.class);
    private final EnumMap<Temperature.Trait, ModifiableAttributeInstance> attributes = new EnumMap(Temperature.Trait.class);
    private final Map<ModifiableAttributeInstance, Map<AttributeModifier.Operation, Set<AttributeModifier>>> attributeModifiers = new HashMap<ModifiableAttributeInstance, Map<AttributeModifier.Operation, Set<AttributeModifier>>>();
    private final HashMap<TempEffectType<?>, TempEffect> tempEffects = new HashMap();
    public boolean showBodyTemp;
    public boolean showWorldTemp;

    @Override
    public double getTrait(Temperature.Trait trait) {
        if (trait == Temperature.Trait.BODY) {
            return this.getTrait(Temperature.Trait.CORE) + this.getTrait(Temperature.Trait.BASE);
        }
        if (!trait.isForTemperature()) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Invalid temperature trait: " + trait));
        }
        return this.traits.computeIfAbsent(trait, t -> 0.0);
    }

    @Override
    public EnumMap<Temperature.Trait, Double> getTraits() {
        return new EnumMap<Temperature.Trait, Double>(this.traits);
    }

    @Override
    public void setTrait(Temperature.Trait trait, double value) {
        if (!trait.isForTemperature()) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Invalid temperature trait: " + trait));
        }
        switch (trait) {
            case CORE: {
                this.changed |= (int)value != (int)this.getTrait(Temperature.Trait.CORE);
                break;
            }
            case BASE: {
                this.changed |= (int)value != (int)this.getTrait(Temperature.Trait.BASE);
                break;
            }
            case WORLD: {
                this.changed |= Math.abs(value - this.getTrait(Temperature.Trait.WORLD)) >= 0.02;
                break;
            }
            default: {
                this.changed |= true;
            }
        }
        this.traits.put(trait, value);
    }

    public void setTrait(Temperature.Trait trait, double value, LivingEntity entity) {
        double oldTemp = this.getTrait(trait);
        this.setTrait(trait, value);
        if (entity.field_70173_aa > 5 && oldTemp != value && entity instanceof ServerPlayerEntity) {
            ModAdvancementTriggers.TEMPERATURE_CHANGED.trigger((ServerPlayerEntity)entity, this.getTraits());
        }
    }

    @Override
    public void addModifier(TempModifier modifier, Temperature.Trait trait) {
        if (!trait.isForModifiers()) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Invalid modifier trait: " + trait));
        }
        this.getModifiers(trait).add(modifier);
    }

    @Override
    public void removeModifier(TempModifier modifier, Temperature.Trait trait) {
        if (!trait.isForModifiers()) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Invalid modifier trait: " + trait));
        }
        this.getModifiers(trait).remove(modifier);
    }

    @Override
    public EnumMap<Temperature.Trait, List<TempModifier>> getModifiers() {
        return this.modifiers;
    }

    @Override
    public List<TempModifier> getModifiers(Temperature.Trait trait) {
        if (!trait.isForModifiers()) {
            throw (IllegalArgumentException)ColdSweat.LOGGER.throwing((Throwable)new IllegalArgumentException("Invalid modifier trait: " + trait));
        }
        return this.modifiers.computeIfAbsent(trait, t -> new ArrayList());
    }

    @Override
    public void clearModifiers() {
        this.modifiers.clear();
    }

    @Override
    public void setModifiers(Map<Temperature.Trait, List<TempModifier>> modifiers) {
        this.clearModifiers();
        this.modifiers.putAll(modifiers);
    }

    @Override
    public boolean hasModifier(Temperature.Trait trait, Class<? extends TempModifier> mod) {
        return this.getModifiers(trait).stream().anyMatch(mod::isInstance);
    }

    @Override
    public void markPersistentAttribute(Attribute attribute) {
        this.persistentAttributes.add(attribute);
    }

    @Override
    public void clearPersistentAttribute(Attribute attribute) {
        this.persistentAttributes.remove(attribute);
    }

    @Override
    public Collection<Attribute> getPersistentAttributes() {
        return this.persistentAttributes;
    }

    @Override
    public void clearModifiers(Temperature.Trait trait) {
        this.getModifiers(trait).clear();
    }

    public boolean shouldShowBodyTemp() {
        return this.showBodyTemp;
    }

    public boolean showAdvancedWorldTemp() {
        return this.showWorldTemp;
    }

    private ModifiableAttributeInstance getAttribute(LivingEntity entity, Temperature.Trait trait) {
        return this.attributes.computeIfAbsent(trait, t -> EntityTempManager.getAttribute(t, entity));
    }

    private Set<AttributeModifier> getAttributeModifiers(ModifiableAttributeInstance attribute, AttributeModifier.Operation operation) {
        Map modifiers = this.attributeModifiers.computeIfAbsent(attribute, at -> {
            HashMap<AttributeModifier.Operation, Set> map = new HashMap<AttributeModifier.Operation, Set>();
            for (AttributeModifier.Operation op : AttributeModifier.Operation.values()) {
                map.put(op, at.func_225504_a_(op));
            }
            return map;
        });
        return modifiers.computeIfAbsent(operation, arg_0 -> ((ModifiableAttributeInstance)attribute).func_225504_a_(arg_0));
    }

    public HashMap<TempEffectType<?>, TempEffect> getTempEffects() {
        return this.tempEffects;
    }

    @Override
    public void addTempEffect(TempEffect effect, boolean isClient) {
        if (!this.tempEffects.containsKey(effect.type())) {
            this.tempEffects.put(effect.type(), effect);
            if (effect.getSide().checkSide(isClient)) {
                MinecraftForge.EVENT_BUS.register((Object)effect);
            }
        }
    }

    @Override
    public void removeTempEffect(TempEffectType<?> effect) {
        this.tempEffects.computeIfPresent(effect, (type, e) -> {
            MinecraftForge.EVENT_BUS.unregister(e);
            return null;
        });
    }

    @Override
    public void clearTempEffects() {
        this.tempEffects.values().forEach(arg_0 -> ((IEventBus)MinecraftForge.EVENT_BUS).unregister(arg_0));
        this.tempEffects.clear();
    }

    @Override
    public void tickDummy(LivingEntity entity) {
        if (!(entity instanceof PlayerEntity)) {
            return;
        }
        Temperature.apply(0.0, entity, Temperature.Trait.WORLD, this.getModifiers(Temperature.Trait.WORLD));
        Temperature.apply(0.0, entity, Temperature.Trait.BASE, this.getModifiers(Temperature.Trait.WORLD));
        Temperature.apply(this.getTrait(Temperature.Trait.CORE), entity, Temperature.Trait.CORE, this.getModifiers(Temperature.Trait.CORE));
        Temperature.apply((double)ConfigSettings.MAX_TEMP.get(), entity, Temperature.Trait.BURNING_POINT, this.getModifiers(Temperature.Trait.BURNING_POINT));
        Temperature.apply((double)ConfigSettings.MIN_TEMP.get(), entity, Temperature.Trait.FREEZING_POINT, this.getModifiers(Temperature.Trait.FREEZING_POINT));
        Temperature.apply(0.0, entity, Temperature.Trait.COLD_DAMPENING, this.getModifiers(Temperature.Trait.COLD_DAMPENING));
        Temperature.apply(0.0, entity, Temperature.Trait.HEAT_DAMPENING, this.getModifiers(Temperature.Trait.HEAT_DAMPENING));
        Temperature.apply(0.0, entity, Temperature.Trait.COLD_RESISTANCE, this.getModifiers(Temperature.Trait.COLD_RESISTANCE));
        Temperature.apply(0.0, entity, Temperature.Trait.HEAT_RESISTANCE, this.getModifiers(Temperature.Trait.HEAT_RESISTANCE));
        Temperature.apply(0.0, entity, Temperature.Trait.RATE, this.getModifiers(Temperature.Trait.RATE));
    }

    @Override
    public void tick(LivingEntity entity) {
        boolean isFullyHeatDampened;
        double worldTemp = this.modifyFromAttribute(entity, Temperature.Trait.WORLD, 0.0);
        double baseTemp = this.modifyFromAttribute(entity, Temperature.Trait.BASE, 0.0);
        double coreTemp = Temperature.apply(this.getTrait(Temperature.Trait.CORE), entity, Temperature.Trait.CORE, this.getModifiers(Temperature.Trait.CORE));
        double maxTemp = this.modifyFromAttribute(entity, Temperature.Trait.BURNING_POINT, ConfigSettings.MAX_TEMP.get());
        double minTemp = this.modifyFromAttribute(entity, Temperature.Trait.FREEZING_POINT, ConfigSettings.MIN_TEMP.get());
        double coldDampening = this.modifyFromAttribute(entity, Temperature.Trait.COLD_DAMPENING, 0.0);
        double heatDampening = this.modifyFromAttribute(entity, Temperature.Trait.HEAT_DAMPENING, 0.0);
        double coldResistance = this.modifyFromAttribute(entity, Temperature.Trait.COLD_RESISTANCE, 0.0);
        double heatResistance = this.modifyFromAttribute(entity, Temperature.Trait.HEAT_RESISTANCE, 0.0);
        double rate = 0.0;
        int worldTempSign = CSMath.signForRange(worldTemp, minTemp, maxTemp);
        boolean immuneToTemp = EntityTempManager.isPeacefulMode(entity);
        boolean isFullyColdDampened = worldTempSign < 0 && (coldDampening >= 1.0 || immuneToTemp);
        boolean bl = isFullyHeatDampened = worldTempSign > 0 && (heatDampening >= 1.0 || immuneToTemp);
        if (!(worldTempSign == 0 || entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184812_l_() || entity.func_175149_v() || EntityTempManager.isPeacefulMode(entity))) {
            double difference = Math.abs(worldTemp - CSMath.clamp(worldTemp, minTemp, maxTemp));
            double changeBy = Math.max(difference / 7.0 * ConfigSettings.TEMP_RATE.get(), Math.abs(ConfigSettings.TEMP_RATE.get() / 50.0)) * (double)worldTempSign;
            if (changeBy < 0.0) {
                changeBy = coldDampening < 0.0 ? changeBy * (1.0 + Math.abs(coldDampening)) : CSMath.blend(changeBy, 0.0, coldDampening, 0.0, 1.0);
            } else if (changeBy > 0.0) {
                changeBy = heatDampening < 0.0 ? changeBy * (1.0 + Math.abs(heatDampening)) : CSMath.blend(changeBy, 0.0, heatDampening, 0.0, 1.0);
            }
            rate = this.modifyFromAttribute(entity, Temperature.Trait.RATE, changeBy);
            coreTemp += (rate *= CSMath.getIfNotNull(ConfigHelper.getFirstOrNull(ConfigSettings.ENTITY_CLIMATES, entity.func_200600_R(), data -> data.test((Entity)entity)), EntityClimateData::rate, 0.25) * 4.0);
        }
        int coreTempSign = CSMath.sign(coreTemp);
        double amount = 0.0;
        if (isFullyColdDampened && coreTempSign < 0) {
            amount = ConfigSettings.TEMP_RATE.get() / 10.0;
        } else if (isFullyHeatDampened && coreTempSign > 0) {
            amount = ConfigSettings.TEMP_RATE.get() / -10.0;
        } else if (coreTempSign != 0 && coreTempSign != worldTempSign) {
            amount = (coreTempSign == 1 ? worldTemp - maxTemp : worldTemp - minTemp) / 3.0;
        }
        if (amount != 0.0) {
            double changeBy = CSMath.maxAbs(amount * ConfigSettings.TEMP_RATE.get(), ConfigSettings.TEMP_RATE.get() / 10.0 * (double)(-coreTempSign));
            coreTemp += CSMath.minAbs(changeBy, -this.getTrait(Temperature.Trait.CORE));
        }
        this.setTrait(Temperature.Trait.CORE, CSMath.clamp(coreTemp, -150.0, 150.0), entity);
        this.setTrait(Temperature.Trait.BASE, CSMath.clamp(baseTemp, -150.0, 150.0), entity);
        this.setTrait(Temperature.Trait.WORLD, worldTemp, entity);
        this.setTrait(Temperature.Trait.BURNING_POINT, maxTemp);
        this.setTrait(Temperature.Trait.FREEZING_POINT, minTemp);
        this.setTrait(Temperature.Trait.COLD_RESISTANCE, coldResistance);
        this.setTrait(Temperature.Trait.HEAT_RESISTANCE, heatResistance);
        this.setTrait(Temperature.Trait.COLD_DAMPENING, coldDampening);
        this.setTrait(Temperature.Trait.HEAT_DAMPENING, heatDampening);
        this.setTrait(Temperature.Trait.RATE, rate);
        if (this.syncTimer > 0) {
            --this.syncTimer;
        }
        if (this.changed && this.syncTimer <= 0) {
            this.syncValues(entity);
        }
        this.tickHurting(entity);
    }

    protected double modifyFromAttribute(LivingEntity entity, Temperature.Trait trait, double baseValue) {
        double oldValue;
        double newValue = this.modifyFromAttribute(entity, trait, this.getModifiers(trait), baseValue);
        if (!DoubleMath.fuzzyEquals((double)newValue, (double)(oldValue = this.getTrait(trait)), (double)0.001)) {
            TemperatureChangedEvent event = new TemperatureChangedEvent(entity, trait, oldValue, newValue);
            MinecraftForge.EVENT_BUS.post((Event)event);
            double eventTemp = event.getTemperature();
            NBTHelper.getOrPutTag(entity, "Temperature", new CompoundNBT()).func_74780_a(trait.func_176610_l(), eventTemp);
            return eventTemp;
        }
        return oldValue;
    }

    @Override
    public double modifyFromAttribute(LivingEntity entity, Temperature.Trait trait, List<TempModifier> modifiers, double baseValue) {
        double newValue;
        Supplier<Double> defaultSupplier = () -> Temperature.apply(baseValue, entity, trait, this.getModifiers(trait));
        ModifiableAttributeInstance attribute = this.getAttribute(entity, trait);
        if (attribute == null) {
            newValue = defaultSupplier.get();
        } else {
            double base = CSMath.safeDouble(attribute.func_111125_b()).orElseGet(defaultSupplier);
            if (modifiers.isEmpty()) {
                newValue = base;
            } else {
                for (AttributeModifier mod : this.getAttributeModifiers(attribute, AttributeModifier.Operation.ADDITION)) {
                    base += mod.func_111164_d();
                }
                double value = base;
                for (AttributeModifier mod : this.getAttributeModifiers(attribute, AttributeModifier.Operation.MULTIPLY_BASE)) {
                    value += base * mod.func_111164_d();
                }
                for (AttributeModifier mod : this.getAttributeModifiers(attribute, AttributeModifier.Operation.MULTIPLY_TOTAL)) {
                    value *= 1.0 + mod.func_111164_d();
                }
                newValue = value;
            }
        }
        return newValue;
    }

    @Override
    public void syncValues(LivingEntity entity) {
        Temperature.updateTemperature(entity, this, false);
        this.changed = false;
        this.syncTimer = 5;
    }

    public int getHurtInterval(LivingEntity entity) {
        return ConfigSettings.TEMPERATURE_HURT_INTERVAL.get();
    }

    public void tickHurting(LivingEntity entity) {
        if (EntityTempManager.isPeacefulMode(entity)) {
            return;
        }
        double bodyTemp = this.getTrait(Temperature.Trait.BODY);
        double heatResistance = this.getTrait(Temperature.Trait.HEAT_RESISTANCE);
        double coldResistance = this.getTrait(Temperature.Trait.COLD_RESISTANCE);
        double damage = ConfigSettings.TEMP_DAMAGE.get();
        double rate = this.getTrait(Temperature.Trait.RATE);
        int hurtInterval = this.getHurtInterval(entity);
        if (hurtInterval < 1) {
            return;
        }
        boolean hasGrace = entity.func_70644_a(ModEffects.GRACE);
        boolean hasFireResist = entity.func_70644_a(Effects.field_76426_n);
        boolean hasIceResist = entity.func_70644_a(ModEffects.ICE_RESISTANCE);
        double rateFactor = CSMath.sign(bodyTemp) == CSMath.sign(rate) ? Math.abs(rate) : 0.0;
        int rateInterval = (int)CSMath.blend(1.0, 4.0, rateFactor, 0.0, 0.7);
        if (!hasGrace && entity.field_70173_aa % (hurtInterval / rateInterval) == 0) {
            if (!(!(bodyTemp >= 100.0) || hasFireResist && ConfigSettings.FIRE_RESISTANCE_ENABLED.get().booleanValue())) {
                DamageSource hot = ModDamageSources.HOT;
                entity.func_70097_a(hot, (float)CSMath.blend(damage, 0.0, heatResistance, 0.0, 1.0));
            } else if (!(!(bodyTemp <= -100.0) || hasIceResist && ConfigSettings.ICE_RESISTANCE_ENABLED.get().booleanValue())) {
                DamageSource cold = ModDamageSources.COLD;
                entity.func_70097_a(cold, (float)CSMath.blend(damage, 0.0, coldResistance, 0.0, 1.0));
            }
        }
    }

    @Override
    public void copy(ITemperatureCap cap) {
        for (Temperature.Trait trait : EntityTempManager.VALID_TEMPERATURE_TRAITS) {
            this.setTrait(trait, cap.getTrait(trait));
        }
        for (Temperature.Trait trait : EntityTempManager.VALID_MODIFIER_TRAITS) {
            this.getModifiers(trait).clear();
            this.getModifiers(trait).addAll(cap.getModifiers(trait));
        }
        this.persistentAttributes.clear();
        this.persistentAttributes.addAll(cap.getPersistentAttributes());
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a("Traits", (INBT)this.serializeTraits());
        nbt.func_218657_a("TempModifiers", (INBT)this.serializeModifiers());
        ListNBT attributes = new ListNBT();
        for (Attribute attribute : this.getPersistentAttributes()) {
            attributes.add((Object)StringNBT.func_229705_a_((String)ForgeRegistries.ATTRIBUTES.getKey((IForgeRegistryEntry)attribute).toString()));
        }
        nbt.func_218657_a("PersistentAttributes", (INBT)attributes);
        return nbt;
    }

    @Override
    public CompoundNBT serializeTraits() {
        CompoundNBT nbt = new CompoundNBT();
        for (Map.Entry<Temperature.Trait, Double> trait : this.traits.entrySet()) {
            nbt.func_74780_a(NBTHelper.getTraitTagKey(trait.getKey()), trait.getValue().doubleValue());
        }
        return nbt;
    }

    @Override
    public CompoundNBT serializeModifiers() {
        CompoundNBT nbt = new CompoundNBT();
        for (Temperature.Trait trait : EntityTempManager.VALID_MODIFIER_TRAITS) {
            ListNBT modifiers = new ListNBT();
            for (TempModifier modifier : this.getModifiers(trait)) {
                modifiers.add((Object)NBTHelper.modifierToTag(modifier));
            }
            nbt.func_218657_a(NBTHelper.getTraitTagKey(trait), (INBT)modifiers);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.deserializeTraits(nbt.func_74775_l("Traits"));
        this.deserializeModifiers(nbt.func_74775_l("TempModifiers"));
        ListNBT attributes = nbt.func_150295_c("PersistentAttributes", 8);
        for (int i = 0; i < attributes.size(); ++i) {
            this.markPersistentAttribute((Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(attributes.func_150307_f(i))));
        }
    }

    @Override
    public void deserializeTraits(CompoundNBT nbt) {
        for (Temperature.Trait trait : EntityTempManager.VALID_TEMPERATURE_TRAITS) {
            this.setTrait(trait, nbt.func_74769_h(NBTHelper.getTraitTagKey(trait)));
        }
    }

    @Override
    public void deserializeModifiers(CompoundNBT nbt) {
        EnumMap modifiers = new EnumMap(Temperature.Trait.class);
        HashMap modifierHashes = new HashMap();
        for (Temperature.Trait trait : EntityTempManager.VALID_MODIFIER_TRAITS) {
            ListNBT modTags = nbt.func_150295_c(NBTHelper.getTraitTagKey(trait), 10);
            modTags.forEach(entry -> {
                CompoundNBT modNBT = (CompoundNBT)entry;
                Optional modOpt = modNBT.func_74764_b("Hash") ? modifierHashes.computeIfAbsent(modNBT.func_74762_e("Hash"), hash -> NBTHelper.tagToModifier(modNBT)) : NBTHelper.tagToModifier(modNBT);
                modOpt.ifPresent(modifier -> modifiers.computeIfAbsent(trait, t -> new ArrayList()).add(modifier));
            });
        }
        this.modifiers.clear();
        this.modifiers.putAll(modifiers);
    }
}

