/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.command.argument;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.IArgumentSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TranslationTextComponent;

public class NicerEnumArgument<T extends Enum<T>>
implements ArgumentType<T> {
    private static final Dynamic2CommandExceptionType INVALID_ENUM = new Dynamic2CommandExceptionType((found, constants) -> new TranslationTextComponent("commands.forge.arguments.enum.invalid", new Object[]{constants, found}));
    private final Class<T> enumClass;

    public static <R extends Enum<R>> NicerEnumArgument<R> enumArgument(Class<R> enumClass) {
        return new NicerEnumArgument<R>(enumClass);
    }

    public NicerEnumArgument(Class<T> enumClass) {
        this.enumClass = enumClass;
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        String name = reader.readUnquotedString();
        try {
            return Enum.valueOf(this.enumClass, name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw INVALID_ENUM.createWithContext((ImmutableStringReader)reader, (Object)name, (Object)Arrays.toString(Arrays.stream(this.enumClass.getEnumConstants()).map(Enum::name).toArray()));
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return ISuggestionProvider.func_197013_a(Stream.of(this.enumClass.getEnumConstants()).map(en -> en.name().toLowerCase(Locale.ROOT)), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return Stream.of(this.enumClass.getEnumConstants()).map(en -> en.name().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
    }

    public static class Serializer<T extends Enum<T>>
    implements IArgumentSerializer<NicerEnumArgument<T>> {
        public void serializeToNetwork(NicerEnumArgument template, PacketBuffer buffer) {
            buffer.func_180714_a(template.enumClass.getName());
        }

        public NicerEnumArgument<T> deserializeFromNetwork(PacketBuffer buffer) {
            try {
                String name = buffer.func_218666_n();
                return new NicerEnumArgument(Class.forName(name));
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public void serializeToJson(NicerEnumArgument argument, JsonObject json) {
            json.addProperty("enum", argument.enumClass.getName());
        }
    }
}

