/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity.data.edible;

import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.common.entity.ChameleonEntity;
import com.momosoftworks.coldsweat.common.entity.data.edible.Edible;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import com.momosoftworks.coldsweat.util.entity.EntityHelper;
import com.momosoftworks.coldsweat.util.registries.ModSounds;
import com.momosoftworks.coldsweat.util.world.WorldHelper;
import java.util.function.BiPredicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;

public abstract class BiomeSearchingEdible
extends Edible {
    private final BiPredicate<World, Biome> biomePredicate;

    public BiomeSearchingEdible(BiPredicate<World, Biome> biomePredicate) {
        this.biomePredicate = biomePredicate;
    }

    @Override
    public Edible.Result onEaten(ChameleonEntity entity, ItemEntity item) {
        if (!entity.field_70170_p.field_72995_K) {
            entity.setSearching(true);
            Thread searchThread = new Thread(null, () -> {
                BlockPos pos = entity.func_233580_cy_();
                BlockPos biomePos = ((ServerWorld)entity.field_70170_p).func_72863_F().func_201711_g().func_202090_b().func_225531_a_(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 2000, biome -> this.biomePredicate.test(entity.field_70170_p, (Biome)biome), entity.func_70681_au());
                if (biomePos != null) {
                    Pair biomePair = Pair.of((Object)biomePos, (Object)entity.field_70170_p.func_226691_t_(biomePos));
                    TaskScheduler.scheduleServer(() -> {
                        entity.setTrackingPos((BlockPos)biomePair.getFirst());
                        WorldHelper.playEntitySound(ModSounds.CHAMELEON_FIND, (Entity)entity, entity.func_184176_by(), 1.2f, EntityHelper.getVoicePitch((LivingEntity)entity));
                        WorldHelper.spawnParticleBatch(entity.field_70170_p, (IParticleData)ParticleTypes.field_197632_y, entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), 1.0, 1.0, 1.0, 6.0, 0.01);
                        entity.setSearching(false);
                    }, (int)(Math.random() * 20.0 + 40.0));
                } else {
                    TaskScheduler.scheduleServer(() -> {
                        WorldHelper.spawnParticleBatch(entity.field_70170_p, (IParticleData)ParticleTypes.field_197601_L, entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), 1.0, 1.0, 1.0, 6.0, 0.01);
                        entity.setSearching(false);
                    }, (int)(Math.random() * 20.0 + 40.0));
                }
            }, "(Cold Sweat) Chameleon search thread");
            searchThread.start();
        }
        return Edible.Result.FAIL;
    }

    @Override
    public boolean shouldEat(ChameleonEntity entity, ItemEntity item) {
        return item.func_200215_l() != null && entity.isPlayerTrusted(item.func_200215_l());
    }
}

