/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.entity.task;

import com.google.common.collect.ImmutableMap;
import com.momosoftworks.coldsweat.core.init.MemoryInit;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.brain.Brain;
import net.minecraft.entity.ai.brain.memory.MemoryModuleStatus;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.brain.memory.WalkTarget;
import net.minecraft.entity.ai.brain.task.Task;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RangedInteger;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;

public class RamImpactTask<E extends CreatureEntity>
extends Task<E> {
    private final Function<E, RangedInteger> cooldownRange;
    private final EntityPredicate entityPredicate;
    private final float speed;
    private final ToDoubleFunction<E> strengthMultiplier;
    private Vector3d direction;
    private final Function<E, SoundEvent> sound;

    public RamImpactTask(Function<E, RangedInteger> cooldownRange, EntityPredicate entityPredicate, float speed, ToDoubleFunction<E> strengthMultiplier, Function<E, SoundEvent> sound) {
        super((Map)ImmutableMap.of((Object)MemoryInit.RAM_COOLDOWN_TICKS.get(), (Object)MemoryModuleStatus.VALUE_ABSENT, (Object)MemoryInit.RAM_TARGET.get(), (Object)MemoryModuleStatus.VALUE_PRESENT), 200);
        this.cooldownRange = cooldownRange;
        this.entityPredicate = entityPredicate;
        this.speed = speed;
        this.strengthMultiplier = strengthMultiplier;
        this.direction = Vector3d.field_186680_a;
        this.sound = sound;
    }

    protected boolean checkExtraStartConditions(ServerWorld worldIn, E owner) {
        return owner.func_213375_cj().func_218191_a((MemoryModuleType)MemoryInit.RAM_TARGET.get());
    }

    protected boolean canStillUse(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        return entityIn.func_213375_cj().func_218191_a((MemoryModuleType)MemoryInit.RAM_TARGET.get());
    }

    protected void start(ServerWorld worldIn, E entityIn, long gameTimeIn) {
        BlockPos pos = entityIn.func_233580_cy_();
        Brain brain = entityIn.func_213375_cj();
        Vector3d targetPos = (Vector3d)brain.func_218207_c((MemoryModuleType)MemoryInit.RAM_TARGET.get()).get();
        this.direction = new Vector3d((double)pos.func_177958_n() - targetPos.func_82615_a(), 0.0, (double)pos.func_177952_p() - targetPos.func_82616_c());
        brain.func_218205_a(MemoryModuleType.field_220950_k, (Object)new WalkTarget(targetPos, this.speed, 0));
    }

    protected void tick(ServerWorld worldIn, E owner, long gameTime) {
        List targettableEntities = worldIn.func_217374_a(LivingEntity.class, this.entityPredicate, owner, owner.func_174813_aQ());
        Brain brain = owner.func_213375_cj();
        if (!targettableEntities.isEmpty()) {
            LivingEntity entity = (LivingEntity)targettableEntities.get(0);
            entity.func_70097_a(DamageSource.func_76358_a(owner), (float)owner.func_233637_b_(Attributes.field_233823_f_));
            int speed = owner.func_70644_a(Effects.field_76424_c) ? owner.func_70660_b(Effects.field_76424_c).func_76458_c() + 1 : 0;
            int slowness = owner.func_70644_a(Effects.field_76421_d) ? owner.func_70660_b(Effects.field_76421_d).func_76458_c() + 1 : 0;
            float speedModifiers = 0.25f * (float)(speed - slowness);
            float speedStrength = MathHelper.func_76131_a((float)(owner.func_70689_ay() * 1.65f), (float)0.2f, (float)3.0f) + speedModifiers;
            float damageAmount = entity.func_184585_cz() ? 0.5f : 1.0f;
            entity.func_233627_a_((float)((double)(damageAmount * speedStrength) * this.strengthMultiplier.applyAsDouble(owner)), this.direction.func_82615_a(), this.direction.func_82616_c());
            this.finishRam(worldIn, owner);
            worldIn.func_217384_a(null, owner, this.sound.apply(owner), SoundCategory.HOSTILE, 1.0f, 1.0f);
        } else {
            boolean isRamExpired;
            Optional walkTarget = brain.func_218207_c(MemoryModuleType.field_220950_k);
            Optional ramTarget = brain.func_218207_c((MemoryModuleType)MemoryInit.RAM_TARGET.get());
            boolean bl = isRamExpired = !walkTarget.isPresent() || !ramTarget.isPresent() || ((WalkTarget)walkTarget.get()).func_220966_a().func_220609_b().func_72438_d((Vector3d)ramTarget.get()) < 0.25;
            if (isRamExpired) {
                this.finishRam(worldIn, owner);
            }
        }
    }

    protected void finishRam(ServerWorld worldIn, E entityIn) {
        worldIn.func_72960_a(entityIn, (byte)59);
        entityIn.func_213375_cj().func_233708_b_((MemoryModuleType)MemoryInit.RAM_COOLDOWN_TICKS.get(), (Object)this.cooldownRange.apply(entityIn).func_233018_a_(worldIn.func_201674_k()));
        entityIn.func_213375_cj().func_218189_b((MemoryModuleType)MemoryInit.RAM_TARGET.get());
    }
}

