/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.electronwill.nightconfig.core.file.FileWatcher;
import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.core.event.TaskScheduler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(modid="cold_sweat", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigPostProcessor {
    public static final Set<String> WRITING_CONFIGS = Collections.synchronizedSet(new HashSet());

    @SubscribeEvent
    public static void onConfigLoad(ModConfig.Loading event) {
        ModConfig config = event.getConfig();
        if (config.getModId().equals("cold_sweat")) {
            ConfigPostProcessor.formatConfig(config, 10);
            ConfigPostProcessor.disableUpdates(config);
        }
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfig.Reloading event) {
        ModConfig config = event.getConfig();
        if (config.getModId().equals("cold_sweat")) {
            ConfigPostProcessor.formatConfig(config, 10);
            ConfigPostProcessor.disableUpdates(config);
        }
    }

    public static void formatConfig(ModConfig config, int delay) {
        TaskScheduler.schedule(() -> ConfigPostProcessor.formatConfigIfNeeded(config), delay);
    }

    public static void formatConfigIfNeeded(ModConfig config) {
        Path filePath = config.getFullPath().toAbsolutePath();
        if (WRITING_CONFIGS.contains(filePath.toString())) {
            return;
        }
        try {
            List<String> lines = Files.readAllLines(filePath);
            boolean containsDrillDown = lines.stream().anyMatch(line -> line.trim().startsWith("#") && line.contains("//v"));
            boolean containsVerticalArrays = ConfigPostProcessor.containsVerticallyFormattedArrays(lines);
            if (containsDrillDown || containsVerticalArrays) {
                ConfigPostProcessor.processConfigFormatting(config);
            }
        }
        catch (IOException e) {
            ColdSweat.LOGGER.error("Failed to check config file: {}/{}", (Object)config.getModId(), (Object)config.getFileName(), (Object)e);
        }
    }

    private static boolean containsVerticallyFormattedArrays(List<String> lines) {
        for (int i = 0; i < lines.size() - 2; ++i) {
            String nextLine;
            String line = lines.get(i).trim();
            if (!line.contains("=") || !line.trim().endsWith("= [") || i + 1 >= lines.size() || !(nextLine = lines.get(i + 1)).startsWith("    ") && !nextLine.startsWith("\t")) continue;
            return true;
        }
        return false;
    }

    private static void processConfigFormatting(ModConfig config) {
        Path filePath = config.getFullPath().toAbsolutePath();
        ConfigPostProcessor.markWriting(config);
        TaskScheduler.schedule(() -> ConfigPostProcessor.unmarkWriting(config), 10);
        try {
            List<String> lines = Files.readAllLines(config.getFullPath());
            ArrayList<String> processedLines = new ArrayList<String>();
            boolean nextArrayShouldDrillDown = false;
            boolean fileModified = false;
            for (int i = 0; i < lines.size(); ++i) {
                String line = lines.get(i);
                String trimmed = line.trim();
                if (trimmed.startsWith("#") && trimmed.contains("//v")) {
                    nextArrayShouldDrillDown = true;
                    processedLines.add(line);
                    continue;
                }
                if (trimmed.isEmpty() || trimmed.startsWith("#") && !trimmed.contains("//v")) {
                    processedLines.add(line);
                    continue;
                }
                if (nextArrayShouldDrillDown && line.contains("=")) {
                    ArrayParseResult result = ConfigPostProcessor.parseCompleteArray(lines, i);
                    if (result.isArray) {
                        List<String> formattedLines = ConfigPostProcessor.formatArrayWithNewlines(result.keyPart, result.arrayContent, ConfigPostProcessor.getIndentation(line));
                        processedLines.addAll(formattedLines);
                        i = result.endIndex;
                        nextArrayShouldDrillDown = false;
                        if (!lines.get(i).endsWith("]")) continue;
                        fileModified = true;
                        continue;
                    }
                    processedLines.add(line);
                    nextArrayShouldDrillDown = false;
                    continue;
                }
                if (line.contains("=") && line.trim().endsWith("= [")) {
                    VerticalArrayParseResult verticalResult = ConfigPostProcessor.parseVerticalArray(lines, i);
                    if (verticalResult.isVerticalArray) {
                        String horizontalFormat = ConfigPostProcessor.formatArrayHorizontally(verticalResult.keyPart, verticalResult.elements, ConfigPostProcessor.getIndentation(line));
                        processedLines.add(horizontalFormat);
                        i = verticalResult.endIndex;
                        fileModified = true;
                        continue;
                    }
                    processedLines.add(line);
                    continue;
                }
                processedLines.add(line);
            }
            if (fileModified) {
                Files.write(filePath, processedLines, new OpenOption[0]);
                ColdSweat.LOGGER.debug("Formatted config file: {}", (Object)config.getFileName());
            }
        }
        catch (IOException e) {
            ColdSweat.LOGGER.error("Failed to process config file: {}", (Object)filePath, (Object)e);
        }
    }

    public static void markWriting(ModConfig config) {
        WRITING_CONFIGS.add(config.getFullPath().toString());
    }

    public static void unmarkWriting(ModConfig config) {
        WRITING_CONFIGS.remove(config.getFullPath().toString());
    }

    public static void disableUpdates(ModConfig config) {
        try {
            FileWatcher.defaultInstance().setWatch(config.getFullPath(), () -> {});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static VerticalArrayParseResult parseVerticalArray(List<String> lines, int startIndex) {
        String firstLine = lines.get(startIndex);
        if (!firstLine.trim().endsWith("= [")) {
            return new VerticalArrayParseResult(false, "", new ArrayList<String>(), startIndex);
        }
        String keyPart = firstLine.substring(0, firstLine.lastIndexOf("= [")).trim() + " =";
        ArrayList<String> elements = new ArrayList<String>();
        for (int currentIndex = startIndex + 1; currentIndex < lines.size(); ++currentIndex) {
            String element;
            String line = lines.get(currentIndex);
            String trimmed = line.trim();
            if (trimmed.equals("]")) {
                return new VerticalArrayParseResult(true, keyPart, elements, currentIndex);
            }
            if (line.startsWith("    ") || line.startsWith("\t")) {
                element = trimmed;
                if (element.endsWith(",")) {
                    element = element.substring(0, element.length() - 1);
                }
            } else {
                return new VerticalArrayParseResult(false, "", new ArrayList<String>(), startIndex);
            }
            elements.add(element);
        }
        return new VerticalArrayParseResult(false, "", new ArrayList<String>(), startIndex);
    }

    private static String formatArrayHorizontally(String keyPart, List<String> elements, String indentation) {
        StringBuilder result = new StringBuilder();
        result.append(indentation).append(keyPart).append(" [");
        for (int i = 0; i < elements.size(); ++i) {
            result.append(elements.get(i));
            if (i >= elements.size() - 1) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    private static ArrayParseResult parseCompleteArray(List<String> lines, int startIndex) {
        String firstLine = lines.get(startIndex);
        int equalsIndex = firstLine.indexOf(61);
        if (equalsIndex == -1) {
            return new ArrayParseResult(false, "", "", startIndex);
        }
        String keyPart = firstLine.substring(0, equalsIndex + 1).trim();
        String valuePart = firstLine.substring(equalsIndex + 1).trim();
        if (!valuePart.startsWith("[")) {
            return new ArrayParseResult(false, "", "", startIndex);
        }
        StringBuilder arrayContent = new StringBuilder();
        int currentIndex = startIndex;
        int bracketCount = 0;
        boolean inString = false;
        boolean escapeNext = false;
        for (int i = 0; i < valuePart.length(); ++i) {
            char c = valuePart.charAt(i);
            arrayContent.append(c);
            if (escapeNext) {
                escapeNext = false;
                continue;
            }
            if (c == '\\') {
                escapeNext = true;
                continue;
            }
            if (c == '\"' && !escapeNext) {
                inString = !inString;
                continue;
            }
            if (inString) continue;
            if (c == '[') {
                ++bracketCount;
                continue;
            }
            if (c != ']') continue;
            --bracketCount;
        }
        if (bracketCount == 0) {
            return new ArrayParseResult(true, keyPart, arrayContent.toString(), startIndex);
        }
        ++currentIndex;
        while (currentIndex < lines.size() && bracketCount > 0) {
            String line = lines.get(currentIndex);
            arrayContent.append(" ").append(line.trim());
            for (char c : line.toCharArray()) {
                if (escapeNext) {
                    escapeNext = false;
                    continue;
                }
                if (c == '\\') {
                    escapeNext = true;
                    continue;
                }
                if (c == '\"' && !escapeNext) {
                    inString = !inString;
                    continue;
                }
                if (inString) continue;
                if (c == '[') {
                    ++bracketCount;
                    continue;
                }
                if (c != ']') continue;
                --bracketCount;
            }
            ++currentIndex;
        }
        return new ArrayParseResult(true, keyPart, arrayContent.toString(), currentIndex - 1);
    }

    private static List<String> formatArrayWithNewlines(String keyPart, String arrayContent, String indentation) {
        ArrayList<String> result = new ArrayList<String>();
        List<String> elements = ConfigPostProcessor.parseTopLevelArrayElements(arrayContent);
        if (elements.isEmpty()) {
            result.add(indentation + keyPart + " " + arrayContent);
            return result;
        }
        result.add(indentation + keyPart + " [");
        for (int i = 0; i < elements.size(); ++i) {
            String element = elements.get(i).trim();
            String line = indentation + "    " + element;
            if (i < elements.size() - 1) {
                line = line + ",";
            }
            result.add(line);
        }
        result.add(indentation + "]");
        return result;
    }

    private static List<String> parseTopLevelArrayElements(String arrayString) {
        ArrayList<String> elements = new ArrayList<String>();
        String content = arrayString.trim();
        if (content.startsWith("[")) {
            content = content.substring(1);
        }
        if (content.endsWith("]")) {
            content = content.substring(0, content.length() - 1);
        }
        if (content.trim().isEmpty()) {
            return elements;
        }
        int bracketDepth = 0;
        int braceDepth = 0;
        boolean inString = false;
        boolean escapeNext = false;
        StringBuilder currentElement = new StringBuilder();
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (escapeNext) {
                currentElement.append(c);
                escapeNext = false;
                continue;
            }
            if (c == '\\') {
                currentElement.append(c);
                escapeNext = true;
                continue;
            }
            if (c == '\"') {
                inString = !inString;
                currentElement.append(c);
                continue;
            }
            if (!inString) {
                if (c == '[') {
                    ++bracketDepth;
                    currentElement.append(c);
                    continue;
                }
                if (c == ']') {
                    --bracketDepth;
                    currentElement.append(c);
                    continue;
                }
                if (c == '{') {
                    ++braceDepth;
                    currentElement.append(c);
                    continue;
                }
                if (c == '}') {
                    --braceDepth;
                    currentElement.append(c);
                    continue;
                }
                if (c == ',' && bracketDepth == 0 && braceDepth == 0) {
                    elements.add(currentElement.toString());
                    currentElement = new StringBuilder();
                    continue;
                }
                currentElement.append(c);
                continue;
            }
            currentElement.append(c);
        }
        if (currentElement.length() > 0) {
            elements.add(currentElement.toString());
        }
        return elements;
    }

    private static String getIndentation(String line) {
        int firstNonSpace;
        for (firstNonSpace = 0; firstNonSpace < line.length() && Character.isWhitespace(line.charAt(firstNonSpace)); ++firstNonSpace) {
        }
        return line.substring(0, firstNonSpace);
    }

    private static class ArrayParseResult {
        boolean isArray;
        String keyPart;
        String arrayContent;
        int endIndex;

        ArrayParseResult(boolean isArray, String keyPart, String arrayContent, int endIndex) {
            this.isArray = isArray;
            this.keyPart = keyPart;
            this.arrayContent = arrayContent;
            this.endIndex = endIndex;
        }
    }

    private static class VerticalArrayParseResult {
        boolean isVerticalArray;
        String keyPart;
        List<String> elements;
        int endIndex;

        VerticalArrayParseResult(boolean isVerticalArray, String keyPart, List<String> elements, int endIndex) {
            this.isVerticalArray = isVerticalArray;
            this.keyPart = keyPart;
            this.elements = elements;
            this.endIndex = endIndex;
        }
    }
}

