/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.api.temperature.effect.TempEffect;
import com.momosoftworks.coldsweat.api.temperature.effect.TempEffectType;
import com.momosoftworks.coldsweat.common.capability.handler.EntityTempManager;
import com.momosoftworks.coldsweat.common.capability.temperature.ITemperatureCap;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.configuration.TempEffectsData;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class HandleTempEffects {
    @SubscribeEvent
    public static void addTempEffects(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living.field_70173_aa % 20 == 0) {
            EntityTempManager.getTemperatureCap((Entity)living).ifPresent(cap -> {
                TempEffectsData effectsData = ConfigHelper.getFirstOrNull(ConfigSettings.ENTITY_TEMP_EFFECTS, living.func_200600_R(), data -> data.test((Entity)living));
                if (effectsData == null) {
                    return;
                }
                ArrayList addedEffects = new ArrayList();
                effectsData.effects().forEach(holder -> {
                    TempEffectType effectType = holder.effect();
                    cap.addTempEffect((TempEffect)effectType.create(effectType, living, holder.range()), living.field_70170_p.field_72995_K);
                    addedEffects.add(effectType);
                });
                cap.getTempEffects().keySet().stream().filter(type -> !addedEffects.contains(type)).forEach(cap::removeTempEffect);
            });
        }
    }

    @SubscribeEvent
    public static void clearTempEffects(EntityLeaveWorldEvent event) {
        if (event.getEntity() instanceof LivingEntity) {
            EntityTempManager.getTemperatureCap(event.getEntity()).ifPresent(ITemperatureCap::clearTempEffects);
        }
    }
}

