/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.event;

import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.loot.ModLootTables;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.TieredItem;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class IceBreakingEvents {
    @SubscribeEvent
    public static void onIceBreak(BlockEvent.BreakEvent event) {
        if (!ConfigSettings.USE_CUSTOM_ICE_DROPS.get().booleanValue()) {
            return;
        }
        BlockState state = event.getState();
        IWorld level = event.getWorld();
        BlockPos pos = event.getPos();
        Material belowMaterial = level.func_180495_p(pos.func_177977_b()).func_185904_a();
        if (state.func_203425_a(Blocks.field_150432_aD) && !ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)event.getPlayer(), (IBlockReader)level, (BlockPos)pos) && !event.getPlayer().field_71075_bZ.field_75098_d && (belowMaterial.func_76230_c() || belowMaterial.func_76224_d())) {
            level.func_180501_a(pos, Blocks.field_150355_j.func_176223_P(), 3);
        }
    }

    @SubscribeEvent
    public static void onIceMining(PlayerEvent.BreakSpeed event) {
        if (!ConfigSettings.USE_CUSTOM_ICE_DROPS.get().booleanValue()) {
            return;
        }
        BlockState state = event.getState();
        PlayerEntity player = event.getPlayer();
        ItemStack tool = player.func_184614_ca();
        float speed = event.getNewSpeed();
        if (IceBreakingEvents.isModifiableIceBlock(state) && !ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)event.getPlayer(), (IBlockReader)player.field_70170_p, (BlockPos)event.getPos())) {
            if (tool.getToolTypes().contains(ToolType.PICKAXE)) {
                event.setNewSpeed(speed * 2.0f);
            } else {
                event.setNewSpeed(speed * 5.0f);
            }
        }
        if (state.func_203425_a(Blocks.field_150403_cj)) {
            event.setNewSpeed(event.getNewSpeed() / 3.0f);
        }
    }

    @SubscribeEvent
    public static void iceHarvestCheck(PlayerEvent.HarvestCheck event) {
        if (!ConfigSettings.USE_CUSTOM_ICE_DROPS.get().booleanValue()) {
            return;
        }
        BlockState state = event.getTargetBlock();
        PlayerEntity player = event.getPlayer();
        ItemStack tool = player.func_184586_b(Hand.MAIN_HAND);
        if (IceBreakingEvents.isModifiableIceBlock(state)) {
            event.setCanHarvest(tool.getToolTypes().contains(ToolType.PICKAXE) && IceBreakingEvents.isCorrectToolForDrops(tool, state));
        }
    }

    public static boolean isModifiableIceBlock(BlockState state) {
        return state.func_203425_a(Blocks.field_150432_aD) || state.func_203425_a(Blocks.field_150403_cj) || state.func_203425_a(Blocks.field_205164_gk);
    }

    public static boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (!IceBreakingEvents.isModifiableIceBlock(state)) {
            return false;
        }
        if (!stack.func_150998_b(state) || !(stack.func_77973_b() instanceof TieredItem)) {
            return false;
        }
        TieredItem tool = (TieredItem)stack.func_77973_b();
        if (state.func_177230_c() == Blocks.field_150432_aD) {
            return tool.func_200891_e().func_200925_d() >= ItemTier.STONE.func_200925_d();
        }
        if (state.func_177230_c() == Blocks.field_150403_cj || state.func_177230_c() == Blocks.field_205164_gk) {
            return tool.func_200891_e().func_200925_d() >= ItemTier.IRON.func_200925_d();
        }
        return false;
    }

    public static ResourceLocation getLootTableForIce(BlockState state) {
        if (state.func_203425_a(Blocks.field_150432_aD)) {
            return ModLootTables.CUSTOM_ICE_DROP;
        }
        if (state.func_203425_a(Blocks.field_150403_cj)) {
            return ModLootTables.CUSTOM_PACKED_ICE_DROP;
        }
        if (state.func_203425_a(Blocks.field_205164_gk)) {
            return ModLootTables.CUSTOM_BLUE_ICE_DROP;
        }
        return null;
    }
}

