/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.common.world.feature;

import com.mojang.serialization.Codec;
import com.momosoftworks.coldsweat.common.block.SoulStalkBlock;
import com.momosoftworks.coldsweat.common.world.feature.SoulStalkFeatureConfig;
import com.momosoftworks.coldsweat.data.tag.ModBlockTags;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.registries.ModBlocks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.feature.Feature;

public class SoulStalkFeature
extends Feature<SoulStalkFeatureConfig> {
    public SoulStalkFeature(Codec<SoulStalkFeatureConfig> config) {
        super(config);
    }

    public boolean isAirOrLeaves(IWorld level, BlockPos pos) {
        return level.func_180495_p(pos).func_196958_f() || level.func_180495_p(pos).func_235714_a_((ITag)BlockTags.field_206952_E);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos blockPos, SoulStalkFeatureConfig config) {
        ISeedReader level = world;
        BlockPos.Mutable pos = blockPos.func_239590_i_();
        int successes = 0;
        for (int t = 0; t < config.tries; ++t) {
            pos.func_189533_g((Vector3i)blockPos).func_196234_d(rand.nextInt(config.spreadXZ) - config.spreadXZ / 2, rand.nextInt(config.spreadY) - config.spreadY / 2, rand.nextInt(config.spreadXZ) - config.spreadXZ / 2);
            int startY = pos.func_177956_o();
            int minHeight = 0;
            int maxHeight = level.func_217301_I();
            for (int i = -10; i < 10; ++i) {
                pos.func_185336_p(startY + i);
                if (pos.func_177956_o() >= minHeight && (pos.func_177956_o() > maxHeight || level.func_180495_p((BlockPos)pos).func_196958_f() && level.func_180495_p(pos.func_177977_b()).func_235785_r_((IBlockReader)level, pos.func_177977_b()))) break;
            }
            if (!level.func_180495_p(pos.func_177977_b()).func_235714_a_(ModBlockTags.SOUL_STALK_PLACEABLE_ON)) {
                SoulStalkFeature.placeDisk((IWorld)level, (BlockPos)pos, config);
            }
            if (!level.func_180495_p(pos.func_177984_a()).func_196958_f()) continue;
            level.func_180501_a((BlockPos)pos, (BlockState)ModBlocks.SOUL_STALK.func_176223_P().func_206870_a(SoulStalkBlock.SECTION, (Comparable)((Object)SoulStalkBlock.Section.BASE)), 2);
            int height = new Random().nextInt(5) + 2;
            for (int i = 0; i < height && this.isAirOrLeaves((IWorld)level, pos.func_177984_a()); ++i) {
                pos.func_196234_d(0, 1, 0);
                level.func_180501_a((BlockPos)pos, (BlockState)ModBlocks.SOUL_STALK.func_176223_P().func_206870_a(SoulStalkBlock.SECTION, (Comparable)((Object)SoulStalkBlock.getRandomMidsection())), 2);
            }
            level.func_180501_a((BlockPos)pos, (BlockState)ModBlocks.SOUL_STALK.func_176223_P().func_206870_a(SoulStalkBlock.SECTION, (Comparable)((Object)SoulStalkBlock.Section.TOP)), 2);
            int minCount = config.minCount;
            int maxCount = config.maxCount;
            if (++successes >= maxCount || successes >= minCount && rand.nextInt(maxCount - minCount) == 0) break;
        }
        return successes > 0;
    }

    private static void placeDisk(IWorld level, BlockPos pos, SoulStalkFeatureConfig config) {
        int diskWidth = config.diskWidth;
        int diskHeight = config.diskHeight;
        double diskDecay = config.diskDecay;
        BlockStateProvider diskProvider = config.diskStateProvider;
        ITag<Block> diskReplacer = config.replaceBlocks;
        if (diskWidth <= 0 || diskHeight <= 0 || diskProvider == null || diskReplacer == null) {
            return;
        }
        for (int x = -diskWidth; x <= diskWidth; ++x) {
            for (int y = -diskHeight; y <= diskHeight; ++y) {
                for (int z = -diskWidth; z <= diskWidth; ++z) {
                    if (!(Math.pow((double)x / (double)diskWidth, 2.0) + Math.pow((double)y / (double)diskHeight, 2.0) + Math.pow((double)z / (double)diskWidth, 2.0) < 1.0)) continue;
                    BlockPos diskPos = pos.func_177982_a(x, y, z);
                    double distance = Math.sqrt(diskPos.func_177951_i((Vector3i)pos));
                    double distFactor = CSMath.blend(level.func_201674_k().nextDouble(), 0.0, distance, 0.0, (double)diskWidth);
                    if (!diskPos.equals((Object)pos.func_177977_b()) && (!(diskDecay > 0.0) || !(distFactor > diskDecay)) || !level.func_180495_p(diskPos).func_235714_a_(diskReplacer)) continue;
                    level.func_180501_a(diskPos, diskProvider.func_225574_a_(level.func_201674_k(), diskPos), 2);
                }
            }
        }
    }
}

