/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.compat.kubejs.event.builder;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import com.momosoftworks.coldsweat.api.util.Temperature;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.data.codec.requirement.BlockRequirement;
import com.momosoftworks.coldsweat.util.serialization.ConfigHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import dev.latvian.kubejs.world.BlockContainerJS;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlockTempBuilderJS {
    public final Set<Block> blocks = new HashSet<Block>();
    public double maxEffect = Double.POSITIVE_INFINITY;
    public double maxTemperature = Double.POSITIVE_INFINITY;
    public double minTemperature = Double.NEGATIVE_INFINITY;
    public double range = ConfigSettings.BLOCK_RANGE.get().intValue();
    public boolean fade = true;
    public Temperature.Units units = Temperature.Units.MC;
    public boolean logarithmic = false;
    public Map<String, Object> state = new HashMap<String, Object>();
    public Predicate<BlockContainerJS> predicate = blockInstance -> true;

    public BlockTempBuilderJS blocks(String ... blocks) {
        this.blocks.addAll(RegistryHelper.mapTaggableList(ConfigHelper.getBlocks(blocks)));
        return this;
    }

    public BlockTempBuilderJS maxEffect(double maxEffect) {
        this.maxEffect = Temperature.convert(maxEffect, this.units, Temperature.Units.MC, false);
        return this;
    }

    public BlockTempBuilderJS maxTemperature(double maxTemperature) {
        this.maxTemperature = Temperature.convert(maxTemperature, this.units, Temperature.Units.MC, true);
        return this;
    }

    public BlockTempBuilderJS minTemperature(double minTemperature) {
        this.minTemperature = Temperature.convert(minTemperature, this.units, Temperature.Units.MC, true);
        return this;
    }

    public BlockTempBuilderJS range(double range) {
        this.range = range;
        return this;
    }

    public BlockTempBuilderJS fades(boolean fade) {
        this.fade = fade;
        return this;
    }

    public BlockTempBuilderJS blockPredicate(Predicate<BlockContainerJS> predicate) {
        this.predicate = predicate;
        return this;
    }

    public BlockTempBuilderJS state(String name, Object value) {
        Optional block = this.blocks.stream().findFirst();
        if (!block.isPresent()) {
            ColdSweat.LOGGER.error("No blocks have been added to this KubeJS block temp yet. Cannot add state check {{} = {}}", (Object)name, value);
            return this;
        }
        Property property = ((Block)block.get()).func_176194_O().func_185920_a(name);
        if (property != null) {
            property.func_185929_b(value.toString()).ifPresent(propertyValue -> this.state.put(name, propertyValue));
        }
        return this;
    }

    public BlockTempBuilderJS units(Temperature.Units units) {
        this.units = units;
        return this;
    }

    public BlockTempBuilderJS logarithmic(boolean logarithmic) {
        this.logarithmic = logarithmic;
        return this;
    }

    public BlockTemp build(final Function function) {
        final BlockRequirement.StateRequirement stateRequirement = new BlockRequirement.StateRequirement(this.state);
        return new BlockTemp(-this.maxEffect, this.maxEffect, this.minTemperature, this.maxTemperature, this.range, this.fade, this.logarithmic, this.blocks.toArray(new Block[0])){

            @Override
            public double getTemperature(World level, LivingEntity entity, BlockState state, BlockPos pos, double distance) {
                return Temperature.convert(function.getTemperature(level, entity, state, pos, distance), BlockTempBuilderJS.this.units, Temperature.Units.MC, false);
            }

            @Override
            public boolean isValid(World level, BlockPos pos, BlockState state) {
                return this.hasBlock(state.func_177230_c()) && BlockTempBuilderJS.this.predicate.test(new BlockContainerJS(level, pos)) && stateRequirement.test(state);
            }
        };
    }

    @FunctionalInterface
    public static interface Function {
        public double getTemperature(World var1, LivingEntity var2, BlockState var3, BlockPos var4, double var5);
    }
}

