/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.ColdSweat;
import com.momosoftworks.coldsweat.config.ConfigSettings;
import com.momosoftworks.coldsweat.config.spec.EntitySettingsConfig;
import com.momosoftworks.coldsweat.config.spec.ItemSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.MainSettingsConfig;
import com.momosoftworks.coldsweat.config.spec.WorldSettingsConfig;
import com.momosoftworks.coldsweat.core.network.BufferHelper;
import com.momosoftworks.coldsweat.core.network.ColdSweatPacketHandler;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class SyncConfigSettingsMessage {
    CompoundNBT configValues;
    UUID menuOpener;

    public SyncConfigSettingsMessage(DynamicRegistries registryAccess) {
        this(null, registryAccess);
    }

    public SyncConfigSettingsMessage(UUID menuOpener, DynamicRegistries registryAccess) {
        this(ConfigSettings.encode(registryAccess), menuOpener);
    }

    private SyncConfigSettingsMessage(CompoundNBT values, UUID menuOpener) {
        this.configValues = values;
        this.menuOpener = menuOpener;
    }

    public static void encode(SyncConfigSettingsMessage message, PacketBuffer buffer) {
        buffer.func_150786_a(message.configValues);
        BufferHelper.writeOptional(buffer, Optional.ofNullable(message.menuOpener), PacketBuffer::func_179252_a);
    }

    public static SyncConfigSettingsMessage decode(PacketBuffer buffer) {
        return new SyncConfigSettingsMessage(buffer.func_150793_b(), BufferHelper.readOptional(buffer, PacketBuffer::func_179253_g).orElse(null));
    }

    public static void handle(SyncConfigSettingsMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            DynamicRegistries registryAccess = RegistryHelper.getDynamicRegistries();
            if (context.getDirection().getReceptionSide().isServer()) {
                if (context.getSender() != null && context.getSender().func_211513_k(2)) {
                    ConfigSettings.decode(message.configValues, registryAccess);
                    ConfigSettings.saveValues(registryAccess);
                    MainSettingsConfig.save();
                    WorldSettingsConfig.save();
                    ItemSettingsConfig.save();
                    EntitySettingsConfig.save();
                    ColdSweatPacketHandler.INSTANCE.send(PacketDistributor.ALL.noArg(), (Object)new SyncConfigSettingsMessage(null, registryAccess));
                }
            } else if (context.getDirection().getReceptionSide().isClient()) {
                try {
                    ConfigSettings.decode(message.configValues, registryAccess);
                }
                catch (Exception e) {
                    ColdSweat.LOGGER.error("Failed to decode config settings from server: ", (Throwable)e);
                }
                if (message.menuOpener != null && message.menuOpener.equals(ClientOnlyHelper.getClientPlayer().func_110124_au())) {
                    ClientOnlyHelper.openConfigScreen();
                }
            }
        });
        context.setPacketHandled(true);
    }
}

