/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import com.momosoftworks.coldsweat.util.math.CSMath;
import java.util.function.Supplier;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncContainerSlotMessage {
    int slot;
    ItemStack stack;
    int containerId = -1;

    public SyncContainerSlotMessage(int slot, ItemStack stack, int containerId) {
        this.slot = slot;
        this.stack = stack;
        this.containerId = containerId;
    }

    public SyncContainerSlotMessage(int slot, ItemStack stack, Container container) {
        this.slot = slot;
        this.stack = stack;
        this.containerId = container.field_75152_c;
    }

    public static void encode(SyncContainerSlotMessage msg, PacketBuffer buffer) {
        buffer.writeInt(msg.slot);
        buffer.func_150786_a(msg.stack.func_77955_b(new CompoundNBT()));
        buffer.func_150787_b(msg.containerId);
    }

    public static SyncContainerSlotMessage decode(PacketBuffer buffer) {
        int slot = buffer.readInt();
        ItemStack stack = ItemStack.func_199557_a((CompoundNBT)buffer.func_150793_b());
        int containerId = buffer.func_150792_a();
        return new SyncContainerSlotMessage(slot, stack, containerId);
    }

    public static void handle(SyncContainerSlotMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                Container container = ClientOnlyHelper.getClientPlayer().field_71070_bA;
                if (container.field_75152_c == message.containerId && CSMath.betweenInclusive(message.slot, 0.0, container.field_75151_b.size() - 1)) {
                    ((Slot)container.field_75151_b.get(message.slot)).func_75215_d(message.stack);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

