/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.core.network.message;

import com.momosoftworks.coldsweat.common.capability.handler.ShearableFurManager;
import com.momosoftworks.coldsweat.util.ClientOnlyHelper;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class SyncShearableDataMessage {
    private final int entityId;
    private final CompoundNBT nbt;

    public SyncShearableDataMessage(int entityId, CompoundNBT nbt) {
        this.entityId = entityId;
        this.nbt = nbt;
    }

    public static void encode(SyncShearableDataMessage msg, PacketBuffer buffer) {
        buffer.writeInt(msg.entityId);
        buffer.func_150786_a(msg.nbt);
    }

    public static SyncShearableDataMessage decode(PacketBuffer buffer) {
        return new SyncShearableDataMessage(buffer.readInt(), buffer.func_150793_b());
    }

    public static void handle(SyncShearableDataMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isClient()) {
            context.enqueueWork(() -> {
                try {
                    Entity entity;
                    World world = ClientOnlyHelper.getClientWorld();
                    if (world != null && (entity = world.func_73045_a(message.entityId)) instanceof LivingEntity) {
                        ShearableFurManager.getFurCap((Entity)((LivingEntity)entity)).ifPresent(cap -> cap.deserializeNBT(message.nbt));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        context.setPacketHandled(true);
    }
}

