/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.codec.util;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.momosoftworks.coldsweat.util.math.CSMath;
import com.momosoftworks.coldsweat.util.serialization.RegistryHelper;
import com.momosoftworks.coldsweat.util.serialization.StringRepresentable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ExtraCodecs {
    public static final Codec<EquipmentSlotType> EQUIPMENT_SLOT = Codec.STRING.xmap(EquipmentSlotType::func_188451_a, EquipmentSlotType::func_188450_d);
    private static final Map<String, RegistryKey<?>> REGISTRY_VALUES = Collections.synchronizedMap(Maps.newIdentityHashMap());

    public static <T> Codec<RegistryKey<T>> registry(RegistryKey<? extends Registry<T>> registry) {
        return ResourceLocation.field_240908_a_.xmap(p_195979_ -> ExtraCodecs.create(registry, p_195979_), RegistryKey::func_240901_a_);
    }

    public static <T> RegistryKey<T> create(RegistryKey<? extends Registry<T>> pRegistryKey, ResourceLocation pLocation) {
        String s = (pRegistryKey + ":" + pLocation).intern();
        return REGISTRY_VALUES.computeIfAbsent(s, p_195971_ -> RegistryKey.func_240903_a_((RegistryKey)pRegistryKey, (ResourceLocation)pLocation));
    }

    public static Codec<Object> anyOf(final Codec<?> ... codecs) {
        return new Codec<Object>(){

            public <T> DataResult<T> encode(Object input, DynamicOps<T> ops, T prefix) {
                for (Codec codec : codecs) {
                    try {
                        DataResult result = codec.encode(input, ops, prefix);
                        if (!result.result().isPresent()) continue;
                        return result;
                    }
                    catch (ClassCastException classCastException) {
                        // empty catch block
                    }
                }
                return DataResult.error((String)("No codecs could encode input " + input));
            }

            public <T> DataResult<Pair<Object, T>> decode(DynamicOps<T> ops, T input) {
                for (Codec codec : codecs) {
                    DataResult result = codec.decode(ops, input);
                    if (!result.result().isPresent()) continue;
                    return result;
                }
                return DataResult.error((String)("No codecs could decode input " + input));
            }
        };
    }

    public static <E> Codec<E> orCompressed(final Codec<E> pFirst, final Codec<E> pSecond) {
        return new Codec<E>(){

            public <T> DataResult<T> encode(E p_184483_, DynamicOps<T> p_184484_, T p_184485_) {
                return p_184484_.compressMaps() ? pSecond.encode(p_184483_, p_184484_, p_184485_) : pFirst.encode(p_184483_, p_184484_, p_184485_);
            }

            public <T> DataResult<Pair<E, T>> decode(DynamicOps<T> p_184480_, T p_184481_) {
                return p_184480_.compressMaps() ? pSecond.decode(p_184480_, p_184481_) : pFirst.decode(p_184480_, p_184481_);
            }

            public String toString() {
                return pFirst + " orCompressed " + pSecond;
            }
        };
    }

    public static <E> Codec<E> stringResolverCodec(Function<E, String> encoder, Function<String, E> decoder) {
        return Codec.STRING.flatXmap(p_184404_ -> Optional.ofNullable(decoder.apply((String)p_184404_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown element name:" + p_184404_))), p_184401_ -> Optional.ofNullable(encoder.apply(p_184401_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Element with unknown name: " + p_184401_))));
    }

    public static <E> Codec<E> idResolverCodec(ToIntFunction<E> encoder, IntFunction<E> decoder, int id) {
        return Codec.INT.flatXmap(p_184414_ -> Optional.ofNullable(decoder.apply((int)p_184414_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown element id: " + p_184414_))), p_274850_ -> {
            int i = encoder.applyAsInt(p_274850_);
            return i == id ? DataResult.error((String)("Element with unknown id: " + p_274850_)) : DataResult.success((Object)i);
        });
    }

    public static <F, S> Codec<Pair<F, S>> pair(Codec<F> firstCodec, Codec<S> secondCodec) {
        return RecordCodecBuilder.create(instance -> instance.group((App)firstCodec.fieldOf("first").forGetter(Pair::getFirst), (App)secondCodec.fieldOf("second").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
    }

    public static <T> Codec<T> deferred(final Supplier<Codec<T>> codecSupplier) {
        return new Codec<T>(){

            public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U input) {
                return ((Codec)codecSupplier.get()).decode(ops, input);
            }

            public <U> DataResult<U> encode(T input, DynamicOps<U> ops, U prefix) {
                return ((Codec)codecSupplier.get()).encode(input, ops, prefix);
            }
        };
    }

    public static <K extends IForgeRegistryEntry<K>, V> Codec<Map<K, V>> builtinMapCodec(final IForgeRegistry<K> keyRegistry, final Codec<V> valueCodec) {
        return new Codec<Map<K, V>>(){

            public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
                Optional keyMapResult = Codec.unboundedMap((Codec)Codec.STRING, (Codec)valueCodec).decode(ops, input).result();
                Map keyMap = (Map)((Pair)keyMapResult.orElseThrow(RuntimeException::new)).getFirst();
                HashMap holderMap = new HashMap();
                for (Map.Entry entry : keyMap.entrySet()) {
                    ResourceLocation id = new ResourceLocation((String)entry.getKey());
                    IForgeRegistryEntry key = keyRegistry.getValue(id);
                    if (key == null) continue;
                    holderMap.put(key, entry.getValue());
                }
                return DataResult.success((Object)Pair.of(holderMap, (Object)keyMapResult.map(Pair::getSecond).orElseThrow(RuntimeException::new)));
            }

            public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
                HashMap keyMap = new HashMap();
                for (Map.Entry entry : input.entrySet()) {
                    keyMap.put(keyRegistry.getKey((IForgeRegistryEntry)entry.getKey()).toString(), entry.getValue());
                }
                return Codec.unboundedMap((Codec)Codec.STRING, (Codec)valueCodec).encode(keyMap, ops, prefix);
            }
        };
    }

    public static <K extends IForgeRegistryEntry<K>, V> Codec<Multimap<K, V>> builtinMultimapCodec(IForgeRegistry<K> keyRegistry, Codec<V> valueCodec) {
        return ExtraCodecs.builtinMapCodec(keyRegistry, valueCodec.listOf()).xmap(map -> {
            HashMultimap multimap = HashMultimap.create();
            for (Map.Entry entry : map.entrySet()) {
                multimap.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
            return multimap;
        }, multimap -> {
            HashMap fastMultiMap = new HashMap();
            for (Map.Entry entry : multimap.asMap().entrySet()) {
                fastMultiMap.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
            }
            return fastMultiMap;
        });
    }

    public static <K, V> Codec<Map<K, V>> registryMapCodec(final RegistryKey<Registry<K>> keyRegistry, final Codec<V> valueCodec) {
        return new Codec<Map<K, V>>(){

            public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
                Optional keyMapResult = Codec.unboundedMap((Codec)Codec.STRING, (Codec)valueCodec).decode(ops, input).result();
                Map keyMap = (Map)((Pair)keyMapResult.orElseThrow(RuntimeException::new)).getFirst();
                DynamicRegistries registryAccess = RegistryHelper.getDynamicRegistries();
                MutableRegistry reg = registryAccess.func_243612_b(keyRegistry);
                HashMap holderMap = new HashMap();
                for (Map.Entry entry : keyMap.entrySet()) {
                    RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)keyRegistry, (ResourceLocation)new ResourceLocation((String)entry.getKey()));
                    CSMath.doIfNotNull(reg.func_230516_a_(key), k -> holderMap.put(k, entry.getValue()));
                }
                return DataResult.success((Object)Pair.of(holderMap, (Object)keyMapResult.map(Pair::getSecond).orElseThrow(RuntimeException::new)));
            }

            public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
                DynamicRegistries registryAccess = RegistryHelper.getDynamicRegistries();
                MutableRegistry reg = registryAccess.func_243612_b(keyRegistry);
                HashMap keyMap = new HashMap();
                for (Map.Entry entry : input.entrySet()) {
                    keyMap.put(reg.func_177774_c(entry.getKey()).toString(), entry.getValue());
                }
                return Codec.unboundedMap((Codec)Codec.STRING, (Codec)valueCodec).encode(keyMap, ops, prefix);
            }
        };
    }

    public static <K, V> Codec<Multimap<K, V>> registryMultimapCodec(RegistryKey<Registry<K>> keyRegistry, Codec<V> valueCodec) {
        return ExtraCodecs.registryMapCodec(keyRegistry, valueCodec.listOf()).xmap(map -> {
            HashMultimap multimap = HashMultimap.create();
            for (Map.Entry entry : map.entrySet()) {
                multimap.putAll(entry.getKey(), (Iterable)entry.getValue());
            }
            return multimap;
        }, multimap -> {
            HashMap fastMultiMap = new HashMap();
            for (Map.Entry entry : multimap.asMap().entrySet()) {
                fastMultiMap.put(entry.getKey(), new ArrayList((Collection)entry.getValue()));
            }
            return fastMultiMap;
        });
    }

    public static <T extends Enum<T>> Codec<T> enumIgnoreCase(T[] values) {
        return Codec.STRING.xmap(str -> {
            if (values.length == 0) {
                throw new IllegalArgumentException("Enum has no values");
            }
            for (Enum value : values) {
                if (!((StringRepresentable)((Object)value)).func_176610_l().equalsIgnoreCase((String)str)) continue;
                return value;
            }
            throw new IllegalArgumentException(String.format("Unknown %s value: %s", values[0].getClass().getSimpleName(), str));
        }, rec$ -> ((StringRepresentable)rec$).func_176610_l());
    }
}

