/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.data.loot_modifier;

import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import com.momosoftworks.coldsweat.util.serialization.JsonHelper;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class AddDropsModifier
extends LootModifier {
    private final Item addition;
    private final Pair<Integer, Integer> count;

    protected AddDropsModifier(ILootCondition[] conditionsIn, Item addition, Pair<Integer, Integer> count) {
        super(conditionsIn);
        this.addition = addition;
        this.count = count;
    }

    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        int countMin = (Integer)this.count.getFirst();
        int countMax = (Integer)this.count.getSecond();
        int countRange = countMax - countMin + 1;
        generatedLoot.add(new ItemStack((IItemProvider)this.addition, context.func_216032_b().nextInt(countRange) + countMin + context.func_216032_b().nextInt(countRange * context.getLootingModifier() + 1)));
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<AddDropsModifier> {
        public AddDropsModifier read(@Nonnull ResourceLocation location, JsonObject object, ILootCondition[] conditionsIn) {
            JsonObject countTable = JsonHelper.getAsJsonObject(object, "count");
            return new AddDropsModifier(conditionsIn, (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(JsonHelper.getAsString(object, "addition"))), (Pair<Integer, Integer>)Pair.of((Object)JsonHelper.getAsInt(countTable, "min"), (Object)JsonHelper.getAsInt(countTable, "max")));
        }

        public JsonObject write(AddDropsModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("addition", instance.addition.getRegistryName().toString());
            return json;
        }
    }
}

